#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_tex2;
uniform sampler2D u_tex3; // infoTexture with airlight

varying vec2 coord;

#include utils

void main()
{
    vec4 rgba = texture2D(u_tex, coord);
#ifdef EXT_color_buffer_half_float
    float meanA = rgba.x;
    float meanB = rgba.y;
#else
    float meanA = 2. * unpack_float16(rgba.xy) - 1.;
    float meanB = 2. * unpack_float16(rgba.zw) - 1.;
#endif
    float gray = dot(texture2D(u_tex2, coord).rgb, grayCol);

    float f = gray * meanA + meanB;
    float newDarkChannel = clamp(f, .2, 1.);

    // Adjust intermediate guiding image for airlight brightness
    /*vec3 airlight = texture2D(u_tex3, vec2(.5)).rgb;
    float air = dot(airlight, grayCol);

    float grayNorm = 1. - (gray - 0.00039063) / air;
    newDarkChannel = max(newDarkChannel, grayNorm);
    if(gray < 1./256.)
        grayNorm = (1. - gray / air) / (1. - gray / air * 256.);
    newDarkChannel = clamp(newDarkChannel, grayNorm, 1.);
*/
    // Second calc pass
    vec4 data = vec4(gray, newDarkChannel, gray * newDarkChannel, gray * gray);


    gl_FragColor = data;
}