precision mediump float;

uniform sampler2D u_tex;
uniform sampler2D u_tex2; // tone curves
uniform vec4 u_offset; // curvesRes;

varying vec2 coord;

void main()
{
    vec4 col = texture2D(u_tex, coord);

    // Fetch from curves
    vec3 lumFactors = (u_offset.x - 1.) / u_offset.x * vec3(0.2126, 0.7152, 0.0722);
    float lum = dot(lumFactors, col.rgb);
    float lc = lum + .5 / u_offset.x; // Account for pixel center
    float newLum = texture2D(u_tex2, vec2(lc, .5)).a;

    gl_FragColor = vec4(col.rgb * newLum / lum, col.a);
}