#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_tex2;
uniform sampler2D u_tex3; // infoTexture (darkest, brightest, average, gammaAverage) x (original, collapsed)
uniform sampler2D u_curves;
uniform float u_curvesRes;
uniform float u_alpha;
uniform vec2 u_size;

varying vec2 coord;

#include utils

void main()
{
    float clarityStrength = u_alpha;

    vec4 originalInfo = texture2D(u_tex3, vec2(.25, .5));
    vec4 collapsedInfo = texture2D(u_tex3, vec2(.75, .5));

    const float logOffset = 1. / 4096.;
    vec2 gammaAverages = vec2(originalInfo.a, collapsedInfo.a);
    gammaAverages = log2(gamma24(gammaAverages) + logOffset); // TODO: Preprocess this
    float diff = gammaAverages.x - gammaAverages.y;

    originalInfo.rgb = 12. * (originalInfo.rgb - 1.);
    collapsedInfo.rgb = 12. * (collapsedInfo.rgb - 1.);

    float middlePoint = gammaAverages.x;
    float darkest = originalInfo.x;
    float brightest = originalInfo.y;
    float collapsedDarkest = collapsedInfo.x + diff;
    float collapsedBrightest = collapsedInfo.y + diff;

    vec4 col = texture2D(u_tex, coord);

    vec3 rgb = colorspace(col.rgb, u_curves, u_curvesRes);

    float g = dot(rgb, grayCol);
    float linearOldGray = g;
    g = log2(g + logOffset);

    // From delta shader: mask = collapsedImage - originalImage + (originalImageGammaAverage - collapsedImageGammaAverage)
    float mask = getGaussianBlurred(u_tex2, coord, u_size);

    float remap; // Remapped darkest to 0, midpoint to .5 and brightest to 1, with two line segments
    float rescaledG; // Remaps darkest to collapsedDarkest, midpoint to midpoint and (2*darkest - collapsedDarkest)? to collapsedDarkest

    if(middlePoint < g) {
        if(darkest >= middlePoint)
            remap = .5;
        else
            remap = (g - brightest) / (brightest - middlePoint) * .5 + 1.;

        if(collapsedDarkest >= middlePoint) {
            rescaledG = middlePoint;
        }
        else {
            rescaledG = (collapsedBrightest - middlePoint) / (brightest - middlePoint);
            rescaledG = rescaledG * g - rescaledG * brightest + collapsedBrightest;
        }

    }
    else {
        if(brightest <= middlePoint)
            remap = .5;
        else
            remap = (g - darkest) / (middlePoint - darkest) * .5;

        if(collapsedBrightest <= middlePoint) {
            rescaledG = middlePoint;
        }
        else {
            float darkPoint = 2. * darkest - collapsedDarkest;
            rescaledG = (collapsedDarkest - middlePoint) / (darkPoint - middlePoint);
            rescaledG = rescaledG * g - rescaledG * darkPoint + collapsedDarkest;
        }

    }
    remap = clamp(remap, 0., 1.);

    float change = (g + mask - rescaledG) * clarityStrength * 2.;

    if (change > 0.)
        remap = 1. - remap;

    remap *= remap;
    remap *= remap;
    remap *= remap;
    change *= 1. - remap;

    // Corrects extreme tones if the change is making them more extreme
    float topLimit = change + change;
    float bottomLimit = -12. - topLimit;
    if(change < 0. && g < bottomLimit) {
        float quota = (g - bottomLimit) / (-12. - bottomLimit);
        quota = clamp(quota, 0., 1.);
        change += quota * quota * -change;
    }
    else if (change > 0. && g > topLimit){
        float quota = (g - topLimit) / ( - topLimit);
        quota = clamp(quota, 0., 1.);
        change += quota * quota * -change;
    }

    g += change;

    g = exp2(g) - logOffset;

    const float minDiv = 0.0001; // 2^-10
    linearOldGray = max(linearOldGray, minDiv);

    rgb *= g / linearOldGray;

    col.rgb = colorspaceInv(rgb, u_curves, u_curvesRes);

    gl_FragColor = col;
}