#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_curves;
uniform float u_curvesRes;

varying vec2 coord;

#include utils

void main()
{
    vec3 rgb = texture2D(u_tex, coord).rgb;

    rgb = colorspace(rgb, u_curves, u_curvesRes);

    float gray = dot(rgb, grayCol);

#ifdef EXT_color_buffer_half_float
    gl_FragColor = vec4(gray, 0., 0., 1.);
#else
    gl_FragColor = vec4(pack_float16(gray), 0., 1.);
#endif
}