#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform vec2 u_size;
uniform vec2 u_offset; // direction

varying vec2 coord;

#include utils

void main()
{
    vec4 col = getPlainGaussianBlurred1D(u_tex, coord, u_size, u_offset);

#ifdef EXT_color_buffer_half_float
    gl_FragColor = vec4(col.rg, 0., 1.);
#else
    gl_FragColor = vec4(balance_packed16(col.rg), 0, 1.);
#endif
}