#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_tex2;
uniform sampler2D u_curves;
uniform float u_curvesRes;
uniform float u_alpha;

varying vec2 coord;

#include utils

void main()
{
    float strength = .25 * u_alpha + 1.;
    strength = 1. - strength * strength * (.5 * u_alpha + 1.);

    vec4 col = texture2D(u_tex, coord);
#ifdef EXT_color_buffer_half_float
    float maskGray = texture2D(u_tex2, coord).r;
#else
    float maskGray = get_value16(u_tex2, coord);
#endif

    vec3 rgb = colorspace(col.rgb, u_curves, u_curvesRes);

    const float invScale = 0.93945121; // = sqrt(1 + 1 / 256) - 1/ 16
    const float scale = 1.064451221; // = 1 / invScale

    float mask = sqrt(maskGray + 1. / 256.) - 1. / 16.;
    mask *= scale;

    float oldGray = (rgb.r + rgb.g + rgb.g + rgb.b) * .25;

    float gray = (sqrt(oldGray + 1. / 256.) - 1. / 16.) * scale;

    float sg = gray + gray - 1.;
    sg *= sg;
    sg *= sg; // (g + g - 1.)^4
    sg = 1. - sg * sg;
    sg *= sg;
    sg *= sg; // (1. - (g + g - 1.)^8)^4

    strength *= sg;

    gray = mix(gray, mask, strength);
    gray = clamp(gray, 0., 1.);

    gray = gray * invScale + 1. / 16.;
    gray = gray * gray - 1. / 256.;

    float minDiv = 0.0001; // 2^-10
    float invOldGray = 1. / max(oldGray, minDiv);
    float gain = gray * invOldGray;

    gain *= 2. - max(oldGray, 1. / 256.) * invOldGray;

    rgb *= min(gain, 2.);


    col.rgb = colorspaceInv(rgb, u_curves, u_curvesRes);

    gl_FragColor = col;
}