#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_tex2; // half of u_tex size
uniform sampler2D u_tex3;
uniform sampler2D u_tex4;
uniform vec4 u_offset; // center, offset, scale, first/middle/last = 0./.5/1.
uniform vec2 u_size; // u_tex size

varying vec2 coord;


#include utils

void main()
{
    float lower = u_offset.x - u_offset.y;
    float center = u_offset.x;
    float higher = u_offset.x + u_offset.y;
    float scale = u_offset.z; // scale = 1. / (center - lower) or 1. / (higher - center)
    float order = u_offset.w;

    float clamped = get_value(u_tex, coord);
    float original = get_value(u_tex3, coord);
    float accumulator = get_value(u_tex4, coord);

    float clampedBlur = getExpanded(u_tex2, coord, u_size);

    float blend = clamp(1. - abs((center - original) / (higher - center)), 0., 1.);
    if( (order < .25 && original < center) || (order > .75 && original > center))
        blend = 1.;

    float g = blend * (clamped - clampedBlur);

    if(order > .25)
        g += accumulator;

    write(gl_FragColor, g);
}