#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex; // gaussian
uniform sampler2D u_tex2; // half size reduced gaussian
uniform vec2 u_size;

varying vec2 coord;


#include utils

void main()
{
    float g0 = get_value(u_tex, coord);
    float g1 = getExpanded(u_tex2, coord, u_size); // expanded reduced gaussian
    float g = g0 - g1;

    write(gl_FragColor, g);
}