#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_curves;
uniform float u_curvesRes;

varying vec2 coord;

#include utils

void main()
{
    vec3 rgb = texture2D(u_tex, coord).rgb;

    rgb = colorspace(rgb, u_curves,  u_curvesRes);

    float g = dot(rgb, grayCol);

    const float offset = 1. / 4096.;
    g = log2(g + offset);

    write(gl_FragColor, g);
}