#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex; // original
uniform sampler2D u_tex2; // dehazeTexture
uniform sampler2D u_tex3; // infoTexture

varying vec2 coord;


#include utils

void main()
{

    float origin = get_value(u_tex, coord);
    float dehaze = get_value(u_tex2, coord);

    vec4 originalInfo = texture2D(u_tex3, vec2(.25, .5));
    vec4 collapsedInfo = texture2D(u_tex3, vec2(.75, .5));
    vec4 averages = vec4(originalInfo.a, collapsedInfo.a, 0., 0.);
    vec2 avs = gamma24(averages).xy;
    const float logOffset = 1. / 4096.;
    // log(a) - log(b) = log(a/b)
    avs = avs + logOffset;
    float diff = log2(avs.x / avs.y);

    float g = min(dehaze + diff - origin, 4.);

    write(gl_FragColor, g);
}