#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_tex2; // textureInfo
uniform float u_offset;

varying vec2 coord;


#include utils

void main()
{

    float g = get_value(u_tex, coord);
    vec4 originalInfo = texture2D(u_tex2, vec2(.25, .5));

    vec2 range = 12. * (originalInfo.rg - 1.);

    float center = u_offset;
    float span = range.y - range.x;

    float width = 1.12874 + 0.06023622 * span + 0.02965879 * span * span;
    width = clamp(width, 1.4, 2.5);
    const float logOffset = 1./4096.;
    width = log2(width + logOffset);

    g = clamp(g, center - width, center + width);

    write(gl_FragColor, g);
}