#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform vec2 u_size;
uniform vec4 u_offset; // float sampleCount, float start, float blur, float aberration

varying vec2 coord;

void main() {
    float sampleCount = u_offset.x;
    float start = u_offset.y;
    float blur = u_offset.z;
    float aberration = u_offset.w;

    int sampleCountInt = int(floor(sampleCount));
    vec4 accumulator = vec4(0.0);
    vec2 dc = coord * u_size;//gl_FragCoord.xy;
    float normalisedValue = length(((dc / u_size) - 0.5) * 2.0);
    float strength = clamp((normalisedValue - start) * (1.0 / (1.0 - start)), 0.0, 1.0);
    vec2 vector = normalize((dc - (u_size / 2.0)) / u_size);
    vec2 velocity = vector * strength * blur;
    vec2 redOffset = -vector * strength * (aberration * -0.5);
    vec2 greenOffset = -vector * strength * (aberration * 0.0);
    vec2 blueOffset = -vector * strength * (aberration * 0.5);

    for (int i=0; i < sampleCountInt; i++) {
        accumulator.r += texture2D(u_tex, (dc + redOffset) / u_size).r;
        accumulator.g += texture2D(u_tex, (dc + greenOffset) / u_size).g;
        accumulator.b += texture2D(u_tex, (dc + blueOffset) / u_size).b;

        redOffset -= velocity / sampleCount;
        greenOffset -= velocity / sampleCount;
        blueOffset -= velocity / sampleCount;
    }

    gl_FragColor = vec4(accumulator.rgb / float(sampleCountInt), 1.0);
}
