precision mediump float;

uniform sampler2D u_tex;
uniform vec3 u_offset; // (rPower, gPower, bPower)

varying vec2 coord;


void main()
{
    vec2 c = sign(coord) * vec2(.5);

    vec2 rr = u_offset.r * (coord - c) + c;
    vec2 gg = u_offset.g * (coord - c) + c;
    vec2 bb = u_offset.b * (coord - c) + c;

    float r = texture2D(u_tex, rr).r;
    float g = texture2D(u_tex, gg).g;
    float b = texture2D(u_tex, bb).b;

    gl_FragColor = vec4(r, g, b, 1.);
}
