// Modified from https://www.shadertoy.com/view/XlfGRj

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;


// Star Nest by Pablo Roman Andrioli

// This content is under the MIT License.

#define iterations 14
#define formuparam 0.53

#define volsteps 14
#define stepsize 0.1

#define zoom   0.800
#define tile   0.850
#define speed  0.010

#define brightness 0.0015
#define darkmatter 0.300
#define def_distfading 0.730
#define saturation 0.850


float sampleMusicA() {
/*
	return 0.5 * (
		texture2D( iChannel0, vec2( 0.15, 0.25 ) ).x +
		texture2D( iChannel0, vec2( 0.30, 0.25 ) ).x);
*/
	return 0.25 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
/*
    float v = 0.0;
    v = max(v, texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x);
    v = max(v, texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x);
    v = max(v, texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x);
    v = max(v, texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x);
    v = max(v, texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x);
    return v;
*/
}

void main()
{
	//get coords and direction
	vec2 uv=fragCoord.xy-.5;
    if (iResolution.x > iResolution.y)
        uv.x *= iResolution.x / iResolution.y;
    else
        uv.y *= iResolution.y / iResolution.x;

	vec3 dir=vec3(uv*zoom,1.);
	float time=iTime*speed+.25;

	//mouse rotation
	float a1=.5; //+iMouse.x/iResolution.x*2.;
	float a2=.8; //+iMouse.y/iResolution.y*2.;
	mat2 rot1=mat2(cos(a1),sin(a1),-sin(a1),cos(a1));
	mat2 rot2=mat2(cos(a2),sin(a2),-sin(a2),cos(a2));
	dir.xz*=rot1;
	dir.xy*=rot2;
	vec3 from=vec3(1.,.5,0.5);
	from+=vec3(time*2.,time,-2.);
	from.xz*=rot1;
	from.xy*=rot2;

    float distfading = def_distfading;
    distfading *= min(1.0, sampleMusicA()*0.5 + 0.5);

	//volumetric rendering
	float s=0.1,fade=1.;
	vec3 v=vec3(0.);
	for (int r=0; r<volsteps; r++) {
		vec3 p=from+s*dir*.5;
		p = abs(vec3(tile)-mod(p,vec3(tile*2.))); // tiling fold
		float pa,a=pa=0.;
		for (int i=0; i<iterations; i++) {
			p=abs(p)/dot(p,p)-formuparam; // the magic formula
			a+=abs(length(p)-pa); // absolute sum of average change
			pa=length(p);
		}
		float dm=max(0.,darkmatter-a*a*.001); //dark matter
		a*=a*a; // add contrast
		if (r>6) fade*=1.-dm; // dark matter, don't render near
		//v+=vec3(dm,dm*.5,0.);
		v+=fade;
		v+=vec3(s,s*s,s*s*s*s)*a*brightness*fade; // coloring based on distance
		fade*=distfading; // distance fading
		s+=stepsize;
	}
	v=mix(vec3(length(v)),v,saturation); //color adjust
	gl_FragColor = vec4(v*.01, 1.0);

}