// Modified from https://www.shadertoy.com/view/Xd3GRX

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;

// Credits: https://www.youtube.com/watch?v=KGJUl8Teipk

#define S(a, b, t) smoothstep(a, b, t)

float getFFT() {
/*
	return 0.5 * (
		texture2D( iChannel0, vec2( 0.15, 0.25 ) ).x +
		texture2D( iChannel0, vec2( 0.30, 0.25 ) ).x);
*/
	return 0.2 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

float DistLine(vec2 p, vec2 a, vec2 b) {
    vec2 pa = p - a;
    vec2 ba = b - a;
    float t = clamp(dot(pa, ba)/dot(ba, ba), 0.0, 1.0);

    return length(pa - ba*t);
}

float N21(vec2 p) {
	p = fract(p * vec2(233.34, 851.73));
    p += dot(p, p + 23.45);

    return fract(p.x * p.y);
}

vec2 N22(vec2 p) {
	float n = N21(p);

    return vec2(n, N21(p + n));
}

float speed = 1.0;//ORG:.4; slowhand:reduced for performance

vec2 GetPos(vec2 id, vec2 offs) {
    vec2 n = N22(id + offs);

    return offs + sin(n * speed * iTime) * .4;
}

float Line(vec2 p, vec2 a, vec2 b) {
	float d = DistLine( p, a, b);
    float m = S(.03, .01, d);
    float d2 = length(a-b);
    m *= S(1., .0, d2) * .5 + S(.05, .03, abs(d2 - .75));

    return m;
}

float Layer(vec2 uv) {
    float m = .0;
    vec2 gv = fract(uv) - .5;
    vec2 id = floor(uv);

    vec2 p[9];
    int i = 0;
    for(float y=-1.; y<=1.; y++) {
        for(float x=-1.; x<=1.; x++, i++) {
            p[i] = GetPos(id, vec2(x, y));
        }
    }

    for(int i=0; i<9; i++) {
        m += Line(gv, p[4], p[i]);

        vec2 j = (p[i] - gv) * 20.;
        float sparkle = 1./dot(j, j);
        //float sparkle = texture2D( iChannel0, vec2( float(i)*float(i)*100.0/22050.0, 0.25 ) ).x*5.0/dot(j, j);
        //float sparkle = texture2D( iChannel0, vec2( dot(j, j)*dot(j, j)*100.0/22050.0, 0.25 ) ).x*5.0/dot(j, j);
        m += sparkle * ( sin(speed * iTime + fract(p[i].x) * 10.) * .4 + .4);
    }
    m += Line(gv, p[1], p[3]);
    m += Line(gv, p[1], p[5]);
    m += Line(gv, p[5], p[7]);
    m += Line(gv, p[7], p[3]);

    return m;
}

void main()
{
//    vec2 uv = (fragCoord - .5*iResolution.xy)/iResolution.y;
    vec2 uv = (fragCoord - .5);
    if (iResolution.x > iResolution.y)
        uv.x *= iResolution.x / iResolution.y;
    else
        uv.y *= iResolution.y / iResolution.x;

//    vec2 mouse = (iMouse.xy / iResolution.xy) - .5;

    float gradient = uv.y - 0.15;

    float m = 0.0;
    float t = iTime * speed * .1;

    float s = sin(t);
    float c = cos(t);
    mat2 rot = mat2(c, -s, s, c);
    uv *= rot;

    for(float i=0.; i<= 1.; i+= 2./4.) {
        float z = fract(i + t);
        float size = mix(10., .5, z);
        float fade = S(0., .5, z) * S(1.2, .8, z);
        m += Layer(uv * size + i * 20.) * fade;
    }

    vec3 base = sin((t * t + 100.) * vec3(.345, .456, .657)) * .4 + .6;

    vec3 col = base * m;

    float fft = getFFT(); //texture2D(iChannel0, vec2(0.7, 0)).x;

    gradient *= fft;

    col -= gradient * base;

    gl_FragColor = vec4(col, 1.0);
}