// Modified from https://www.shadertoy.com/view/MslGWN

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;


////////////////////////////////////////////////////////////////////////////////
//simplicity_galaxy.fsh

//CBS
//Parallax scrolling fractal galaxy.
//Inspired by JoshP's Simplicity shader: https://www.shadertoy.com/view/lslGWr

// http://www.fractalforums.com/new-theories-and-research/very-simple-formula-for-fractal-patterns/
float field(vec3 p, float s, int iter, float time) {
	//float strength = 7. + .03 * log(1.e-6 + fract(sin(time) * 4373.11));
	float strength = 9. + .03 * log(1.e-6 + fract(sin(time) * 4373.11));
	float accum = s/4.;
	float prev = 0.;
	float tw = 0.;
	for (int i = 0; i < iter; ++i) {
		float mag = dot(p, p);
		p = abs(p) / mag + vec3(-.5, -.4, -1.5);
		float w = exp(-float(i) / 7.);
		accum += w * exp(-strength * pow(abs(mag - prev), 2.2));
		tw += w;
		prev = mag;
	}
	return max(0., 5. * accum / tw - .7);
}

// Less iterations for second layer
/*
float field2(in vec3 p, float s) {
	//float strength = 7. + .03 * log(1.e-6 + fract(sin(iTime) * 4373.11));
	float strength = 9. + .03 * log(1.e-6 + fract(sin(iTime) * 4373.11));
	float accum = s/4.;
	float prev = 0.;
	float tw = 0.;
	for (int i = 0; i < 18; ++i) {
		float mag = dot(p, p);
		p = abs(p) / mag + vec3(-.5, -.4, -1.5);
		float w = exp(-float(i) / 7.);
		accum += w * exp(-strength * pow(abs(mag - prev), 2.2));
		tw += w;
		prev = mag;
	}
	return max(0., 5. * accum / tw - .7);
}
*/

vec3 nrand3( vec2 co )
{
	vec3 a = fract( cos( co.x*8.3e-3 + co.y )*vec3(1.3e5, 4.7e5, 2.9e5) );
	vec3 b = fract( sin( co.x*0.3e-3 + co.y )*vec3(8.1e5, 1.0e5, 0.1e5) );
	vec3 c = mix(a, b, 0.5);
	return c;
}
//simplicity_galaxy.fsh
////////////////////////////////////////////////////////////////////////////////


#define DUST_MOTE_COUNT 10
#define WIDTH 1.0

float audio_freq( in sampler2D channel, in float f) { return texture2D( channel, vec2(f, 0.25) ).x; }
float audio_ampl( in sampler2D channel, in float t) { return texture2D( channel, vec2(t, 0.75) ).x; }

vec3 dust_mote(vec3 color, vec2 pos, vec2 center, float radius, float alpha, float focus){
    vec2 disp = pos - center;
    float dist = dot(disp,disp);
    vec3 mote = (color+0.005)*alpha* vec3(smoothstep(radius * (1.0+focus), radius, dist));
    return (1.0-mote)*color + mote;
}

float rnd(float s) { return sin(2923.138674*s); }

vec3 dust_motes(vec3 color, vec2 pos, const int number, float t) {
    vec3 new_color = color;
    for(int i = 0; i < DUST_MOTE_COUNT; i++) {
        float fudge = rnd(float(i));
        float cycle = fract(t+fudge);
    	float fade = 2.0 * cycle * (1.0 - cycle);
        vec2 center = vec2(fudge+sin(t*fudge+fudge), 1.1-cycle*2.0+rnd(fudge));
        new_color = dust_mote(new_color, pos, center, 0.01+0.007*fudge, 0.5*fade, 0.6 + 0.4*fudge);
    }
    return new_color;
}

vec3 B2_spline(vec3 x) { // returns 3 B-spline functions of degree 2
    vec3 t = 3.0 * x;
    vec3 b0 = step(0.0, t)     * step(0.0, 1.0-t);
	vec3 b1 = step(0.0, t-1.0) * step(0.0, 2.0-t);
	vec3 b2 = step(0.0, t-2.0) * step(0.0, 3.0-t);
	return 0.5 * (
    	b0 * pow(t, vec3(2.0)) +
    	b1 * (-2.0*pow(t, vec3(2.0)) + 6.0*t - 3.0) +
    	b2 * pow(3.0-t,vec3(2.0))
    );
}


void main() {
    vec4 outColor;

	////////////////////////////////////////////////////////////////////////////////
	//simplicity_galaxy.fsh
    {
        vec2 uv = 2. * fragCoord.xy - 1.;
        vec2 uvs = uv * iResolution.xy / max(iResolution.x, iResolution.y);
        vec3 p = vec3(uvs / 4., 0) + vec3(1., -1.3, 0.);
        float xTime = iTime * 2.0;
        p += .2 * vec3(sin(xTime / 16.), sin(xTime / 12.),  sin(xTime / 128.));

        float freqs[4];
        //Sound
        freqs[0] = texture2D( iChannel0, vec2( 0.01, 0.25 ) ).x;
        freqs[1] = texture2D( iChannel0, vec2( 0.07, 0.25 ) ).x;
        freqs[2] = texture2D( iChannel0, vec2( 0.15, 0.25 ) ).x;
        freqs[3] = texture2D( iChannel0, vec2( 0.30, 0.25 ) ).x;

        float t = field(p,freqs[2],26,xTime);
        float v = (1. - exp((abs(uv.x) - 1.) * 6.)) * (1. - exp((abs(uv.y) - 1.) * 6.));

        //Second Layer
        vec3 p2 = vec3(uvs / (4.+sin(xTime*0.11)*0.2+0.2+sin(xTime*0.15)*0.3+0.4), 1.5) + vec3(2., -1.3, -1.);
        p2 += 0.25 * vec3(sin(xTime / 16.), sin(xTime / 12.),  sin(xTime / 128.));
        float t2 = field(p2,freqs[3],18,xTime); //field2(p2,freqs[3]);
        vec4 c2 = mix(.4, 1., v) * vec4(1.3 * t2 * t2 * t2 ,1.8  * t2 * t2 , t2* freqs[0], t2);


        //Let's add some stars
        //Thanks to http://glsl.heroku.com/e#6904.0
        vec2 seed = p.xy * 2.0;
        seed = floor(seed * iResolution.x);
        vec3 rnd = nrand3( seed );
        vec4 starcolor = vec4(pow(rnd.y,40.0));

        //Second Layer
        vec2 seed2 = p2.xy * 2.0;
        seed2 = floor(seed2 * iResolution.x);
        vec3 rnd2 = nrand3( seed2 );
        starcolor += vec4(pow(rnd2.y,40.0));

        outColor = mix(freqs[3]-.3, 1., v) * vec4(1.5*freqs[2] * t * t* t , 1.2*freqs[1] * t * t, freqs[3]*t, 1.0)+c2+starcolor;
    }

    {
        vec2 uv = fragCoord.xy;// / iResolution.xy;
        //uv.y += 0.02 * sin(3.0*uv.x+iTime / 2.0);
        vec2 centered = (uv - 0.5)/WIDTH;
        float intro = 1.0; //smoothstep(0.0, 5.0, iTime);
        centered.y -=  intro - 1.0;
        float sample0 = audio_ampl(iChannel0, 0.02);
        centered /= 1.0 + 0.03*(sample0-0.5);
        //centered.x *= 0.97 + 0.01*(1.0 + cos(iTime));
        float mirrored = abs(centered.x);

        if (iResolution.x > iResolution.y)
            centered.x *= iResolution.x / iResolution.y;
        else
            centered.y *= iResolution.y / iResolution.x;

        float dist2 = 6.0 * dot(centered, centered); //slowhand: *6.0 for smaller circle
        float clamped_dist = smoothstep(0.0, 1.0, dist2);
        float arclength    = abs(atan(centered.y, centered.x) / radians(360.0))+0.01;
        float shine_shift = 0.15-centered.y;

        float sample1 = audio_freq(iChannel0, mirrored + 0.01);
        float sample2 = audio_ampl(iChannel0, clamped_dist);
        float sample3 = audio_ampl(iChannel0, arclength);
        float sample4 = audio_freq(iChannel0, 0.01+.05*mirrored/(shine_shift));

        // Color variation functions
        float t = iTime / 100.0;
        float polychrome = (1.0 + sin(t*50.0))/2.0; // 0 -> uniform color, 1 -> full spectrum
        vec3 spline_args = fract(vec3(polychrome*uv.x-t) + vec3(0.0, -1.0/3.0, -2.0/3.0));
        vec3 spline = B2_spline(spline_args);

        float f = abs(centered.y);
        vec3 base_color  = vec3(1.0, 1.0, 1.0) - f*spline;
        vec3 flame_color = pow(base_color, vec3(3.0)); //pow(base_color, vec3(3.0)); //slowhand: 15.0 for more color
        vec3 disc_color  = 0.30 * base_color; //0.20
        //vec3 wave_color  = 0.40 * base_color; //0.10
        //vec3 flash_color = 0.30 * base_color; //0.05

        float disp_dist = smoothstep(-0.2, -0.1, sample3-dist2);
        disp_dist *= (1.0 - disp_dist);

        vec3 color = vec3(0.0);

        float shine = (sample4)*smoothstep(1.5, 0.0, shine_shift)*smoothstep(0.05, 0.3, shine_shift);
        shine = pow(shine, 4.0); //pow(shine, 5.0); //slowhand: 4.0 for bright lines

        // spline debug
        // vec3 s = smoothstep(-0.01, 0.01, spline-uv.y); color += (1.0-s) * s;

        float v = abs(centered.y);
        color += flame_color * smoothstep(v, v*8.0, sample1);
        color += disc_color  * smoothstep(0.5, 1.0, sample2) * (1.0 - clamped_dist);
        //color += flash_color * smoothstep(0.5, 1.0, sample3) * clamped_dist;
        //color += wave_color  * disp_dist;
        color = dust_motes(color, centered+sample0*0.03-0.06, 10, t*10.0);
        color += intro * intro*flame_color * shine;
        //color = pow(color, vec3(0.4545));
        outColor += vec4(color, 1.0);
    }

	gl_FragColor = outColor;
}