// Modified from https://www.shadertoy.com/view/4sXfzj

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;

const int numWaves = 6;
const float numStripes = 1.0;
const float numFreqs = 8.0;
const float meanFreq = 4.0;
const float stdDev = 2.0;
const float period = 3.0;
const float pi = 4.0 * atan(1.0);
const float pi2 = 2.0 * pi;
const float ln2 = log(2.0);
const float mean = meanFreq * .69314718;

float wavething(int n, float x){
    float l = ln2 * float(n) + log(x);
    l -= mean;
    return exp(-l * l / stdDev) / 2.0;
}

void main()
{
    vec4 color = vec4(0.0);
    float scale = exp2(-fract(iTime / period));
    float sum1 = 0.0;
    for(int n = 0; n < int(numFreqs); n++){
        sum1 += wavething(n, scale);
    }
    //vec2 xy = pi2 * numStripes
    //    * ((2.0 * fragCoord - iResolution.xy) / iResolution.y);

	vec2 uv=fragCoord.xy -.5;
    if (iResolution.x > iResolution.y)
        uv.x *= iResolution.x / iResolution.y;
    else
        uv.y *= iResolution.y / iResolution.x;
    vec2 xy = pi2 * numStripes * uv * 2.0;


    float sum2 = 0.0;
    for(int n = 0; n < numWaves; n++){
        float theta = pi * float(n) / float(numWaves);
        vec2 waveVec = vec2(cos(theta), sin(theta));
        float phase = dot(xy, waveVec);
        for(int k = 0; k < int(numFreqs); k++){
            sum2 += cos(phase * scale * exp2(float(k))) * wavething(k, scale);
        }
    }
    color += vec4(1.0 - sum2 / sum1);
    xy /= pi2 * numStripes;
    float r = length(xy);
    if(sum2 / sum1 < .5){
        color.x *= texture2D(iChannel0, vec2(.161616 * r, .2)).x;
        color.y *= texture2D(iChannel0, vec2(.161616 * r + .161616, .2)).x;
        color.z *= texture2D(iChannel0, vec2(.161616 * r + .333333, .2)).x;
        color = 1.0 - color;
    }
    color = 1.0 - (r + 1.0) * color;
    if(length(color) > 3.0) color = vec4(0.0);

    gl_FragColor = color;
}