// Modified from https://www.shadertoy.com/view/MtByRh

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;

////////////////////////////////////////////////////////////////////////////////
//lensing.fsh
// This content is under the MIT License.

#define iterations 12
#define formuparam 0.57

#define volsteps 10
#define stepsize 0.2

#define zoom   1.200
#define tile   1.0
#define speed  0.010

#define brightness 0.0015
#define darkmatter 1.00
#define def_distfading 0.730
#define saturation 1.0

//#define mo (2.0 * iMouse.xy - iResolution.xy) / iResolution.y
#define blackholeCenter vec3(time*2.,time,-2.)
#define def_blackholeRadius 0.5
#define blackholeIntensity 1.0

float iSphere(vec3 ray, vec3 dir, vec3 center, float radius)
{
	vec3 rc = ray-center;
	float c = dot(rc, rc) - (radius*radius);
	float b = dot(dir, rc);
	float d = b*b - c;
	float t = -b - sqrt(abs(d));
	float st = step(0.0, min(t,d));
	return mix(-1.0, t, st);
}

vec3 iPlane(vec3 ro, vec3 rd, vec3 po, vec3 pd){
    float d = dot(po - ro, pd) / dot(rd, pd);
    return d * rd + ro;
}

vec3 r(vec3 v, vec2 r)//incomplete but ultrafast rotation fcn thnx to rodolphito
{
    vec4 t = sin(vec4(r, r + 1.5707963268));
    float g = dot(v.yz, t.yw);
    return vec3(v.x * t.z - g * t.x,
                v.y * t.w - v.z * t.y,
                v.x * t.x + g * t.z);
}

float sampleMusicA() {
/*
	return 0.5 * (
		texture2D( iChannel0, vec2( 0.15, 0.25 ) ).x +
		texture2D( iChannel0, vec2( 0.30, 0.25 ) ).x);
*/
	return 1.0 / 3.0 * (
//		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

float sampleMusicB() {
	return 1.0 / 2.0 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

float sampleMusic() {
	return 1.0 / 5.0 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}
//lensing.fsh
////////////////////////////////////////////////////////////////////////////////


//CBS
//Parallax scrolling fractal galaxy.
//Inspired by JoshP's Simplicity shader: https://www.shadertoy.com/view/lslGWr

// http://www.fractalforums.com/new-theories-and-research/very-simple-formula-for-fractal-patterns/
float field(vec3 p, float s, int iter, float time) {
	//float strength = 7. + .03 * log(1.e-6 + fract(sin(time) * 4373.11));
	float strength = 9. + .03 * log(1.e-6 + fract(sin(time) * 4373.11));
	float accum = s/4.;
	float prev = 0.;
	float tw = 0.;
	for (int i = 0; i < iter; ++i) {
		float mag = dot(p, p);
		p = abs(p) / mag + vec3(-.5, -.4, -1.5);
		float w = exp(-float(i) / 7.);
		accum += w * exp(-strength * pow(abs(mag - prev), 2.2));
		tw += w;
		prev = mag;
	}
	return max(0., 5. * accum / tw - .7);
}

// Less iterations for second layer
/*
float field2(in vec3 p, float s) {
	//float strength = 7. + .03 * log(1.e-6 + fract(sin(iTime) * 4373.11));
	float strength = 9. + .03 * log(1.e-6 + fract(sin(iTime) * 4373.11));
	float accum = s/4.;
	float prev = 0.;
	float tw = 0.;
	for (int i = 0; i < 18; ++i) {
		float mag = dot(p, p);
		p = abs(p) / mag + vec3(-.5, -.4, -1.5);
		float w = exp(-float(i) / 7.);
		accum += w * exp(-strength * pow(abs(mag - prev), 2.2));
		tw += w;
		prev = mag;
	}
	return max(0., 5. * accum / tw - .7);
}
*/

vec3 nrand3( vec2 co )
{
	vec3 a = fract( cos( co.x*8.3e-3 + co.y )*vec3(1.3e5, 4.7e5, 2.9e5) );
	vec3 b = fract( sin( co.x*0.3e-3 + co.y )*vec3(8.1e5, 1.0e5, 0.1e5) );
	vec3 c = mix(a, b, 0.5);
	return c;
}


void main()
{
    vec4 outColor;

	////////////////////////////////////////////////////////////////////////////////
	//lensing.fsh
	{
        //get coords and direction
        vec2 uv=fragCoord.xy-.5;
        if (iResolution.x > iResolution.y)
            uv.x *= iResolution.x / iResolution.y;
        else
            uv.y *= iResolution.y / iResolution.x;

        vec3 dir=vec3(uv*zoom,1.);
        float time=iTime*speed+.25;

        //mouse rotation
        vec3 from=vec3(0.0, 0.0, -15.0);
        //from = r(from, mo / 10.0);
        //dir = r(dir, mo / 10.0);
        from+=blackholeCenter;

        vec3 nml = normalize(blackholeCenter - from);
        vec3 pos = iPlane(from, dir, blackholeCenter, nml);
        pos = blackholeCenter - pos;

        float intensity = dot(pos, pos) * 0.4; //0.5 for bigger blackhole
        float pulse = sampleMusic();
        intensity *= -0.5*pulse*1.5 + 1.0;
        //intensity += -0.2*sampleMusicB();

        float distfading = def_distfading;
        distfading *= pulse*0.8 + 0.4;

        float blackholeRadius = def_blackholeRadius;
        //blackholeRadius += sampleMusicB();

        if(intensity > blackholeRadius * blackholeRadius){
            intensity = 1.0 / intensity;
            dir = mix(dir, pos * sqrt(intensity), blackholeIntensity * intensity);

            //volumetric rendering
            float s=0.1,fade=1.;
            vec3 v=vec3(0.);
            for (int r=0; r<volsteps; r++) {
                vec3 p=from+s*dir*.5;
                p = abs(vec3(tile)-mod(p,vec3(tile*2.))); // tiling fold
                float pa,a=pa=0.;
                for (int i=0; i<iterations; i++) {
                    p=abs(p)/dot(p,p)-formuparam; // the magic formula
                    a+=abs(length(p)-pa); // absolute sum of average change
                    pa=length(p);
                }
                float dm=max(0.,darkmatter-a*a*.001); //dark matter
                a*=a*a; // add contrast
                if (r>6) fade*=1.-dm; // dark matter, don't render near
                //v+=vec3(dm,dm*.5,0.);
                v+=fade;
                v+=vec3(s,s*s,s*s*s*s)*a*brightness*fade; // coloring based on distance
                fade*=distfading; // distance fading
                s+=stepsize;
            }
            v=mix(vec3(length(v)),v,saturation); //color adjust
            outColor = vec4(v*.01, 1.0);
        }
        else outColor = vec4(0.0);
    }

	{
        vec2 uv = 2. * fragCoord.xy - 1.;
        vec2 uvs = uv * iResolution.xy / max(iResolution.x, iResolution.y);
        vec3 p = vec3(uvs / 4., 0) + vec3(1., -1.3, 0.);
        float xTime = iTime * 2.0;
        p += .2 * vec3(sin(xTime / 16.), sin(xTime / 12.),  sin(xTime / 128.));

        float freqs[4];
        //Sound
        freqs[0] = texture2D( iChannel0, vec2( 0.01, 0.25 ) ).x;
        freqs[1] = texture2D( iChannel0, vec2( 0.07, 0.25 ) ).x;
        freqs[2] = texture2D( iChannel0, vec2( 0.15, 0.25 ) ).x;
        freqs[3] = texture2D( iChannel0, vec2( 0.30, 0.25 ) ).x;

        float t = field(p,freqs[2],26,xTime);
        float v = (1. - exp((abs(uv.x) - 1.) * 6.)) * (1. - exp((abs(uv.y) - 1.) * 6.));

        //Second Layer
        vec3 p2 = vec3(uvs / (4.+sin(xTime*0.11)*0.2+0.2+sin(xTime*0.15)*0.3+0.4), 1.5) + vec3(2., -1.3, -1.);
        p2 += 0.25 * vec3(sin(xTime / 16.), sin(xTime / 12.),  sin(xTime / 128.));
        float t2 = field(p2,freqs[3],18,xTime); //field2(p2,freqs[3]);
        vec4 c2 = mix(.4, 1., v) * vec4(1.3 * t2 * t2 * t2 ,1.8  * t2 * t2 , t2* freqs[0], t2);


        //Let's add some stars
        //Thanks to http://glsl.heroku.com/e#6904.0
        vec2 seed = p.xy * 2.0;
        seed = floor(seed * iResolution.x);
        vec3 rnd = nrand3( seed );
        vec4 starcolor = vec4(pow(rnd.y,40.0));

        //Second Layer
        vec2 seed2 = p2.xy * 2.0;
        seed2 = floor(seed2 * iResolution.x);
        vec3 rnd2 = nrand3( seed2 );
        starcolor += vec4(pow(rnd2.y,40.0));

        outColor += mix(freqs[3]-.3, 1., v) * vec4(1.5*freqs[2] * t * t* t , 1.2*freqs[1] * t * t, freqs[3]*t, 1.0)+c2+starcolor;
	}

	gl_FragColor = outColor;
}