// Modified from https://www.shadertoy.com/view/MtByRh

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;

////////////////////////////////////////////////////////////////////////////////
//lensing.fsh
// This content is under the MIT License.

#define iterations 12
#define formuparam 0.57

#define volsteps 10
#define stepsize 0.2

#define zoom   1.200
#define tile   1.0
#define speed  0.010

#define brightness 0.0015
#define darkmatter 1.00
#define def_distfading 0.730
#define saturation 1.0

//#define mo (2.0 * iMouse.xy - iResolution.xy) / iResolution.y
#define blackholeCenter vec3(time*2.,time,-2.)
#define def_blackholeRadius 0.5
#define blackholeIntensity 1.0

float iSphere(vec3 ray, vec3 dir, vec3 center, float radius)
{
	vec3 rc = ray-center;
	float c = dot(rc, rc) - (radius*radius);
	float b = dot(dir, rc);
	float d = b*b - c;
	float t = -b - sqrt(abs(d));
	float st = step(0.0, min(t,d));
	return mix(-1.0, t, st);
}

vec3 iPlane(vec3 ro, vec3 rd, vec3 po, vec3 pd){
    float d = dot(po - ro, pd) / dot(rd, pd);
    return d * rd + ro;
}

vec3 r(vec3 v, vec2 r)//incomplete but ultrafast rotation fcn thnx to rodolphito
{
    vec4 t = sin(vec4(r, r + 1.5707963268));
    float g = dot(v.yz, t.yw);
    return vec3(v.x * t.z - g * t.x,
                v.y * t.w - v.z * t.y,
                v.x * t.x + g * t.z);
}

float sampleMusicA() {
/*
	return 0.5 * (
		texture2D( iChannel0, vec2( 0.15, 0.25 ) ).x +
		texture2D( iChannel0, vec2( 0.30, 0.25 ) ).x);
*/
	return 1.0 / 3.0 * (
//		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

float sampleMusicB() {
	return 1.0 / 2.0 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

float sampleMusic() {
	return 1.0 / 5.0 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}
//lensing.fsh
////////////////////////////////////////////////////////////////////////////////


#define WIDTH 1.0

float audio_freq( in sampler2D channel, in float f) { return texture2D( channel, vec2(f, 0.25) ).x; }
float audio_ampl( in sampler2D channel, in float t) { return texture2D( channel, vec2(t, 0.75) ).x; }

vec3 B2_spline(vec3 x) { // returns 3 B-spline functions of degree 2
    vec3 t = 3.0 * x;
    vec3 b0 = step(0.0, t)     * step(0.0, 1.0-t);
	vec3 b1 = step(0.0, t-1.0) * step(0.0, 2.0-t);
	vec3 b2 = step(0.0, t-2.0) * step(0.0, 3.0-t);
	return 0.5 * (
    	b0 * pow(t, vec3(2.0)) +
    	b1 * (-2.0*pow(t, vec3(2.0)) + 6.0*t - 3.0) +
    	b2 * pow(3.0-t,vec3(2.0))
    );
}


void main()
{
    vec4 outColor;

	////////////////////////////////////////////////////////////////////////////////
	//lensing.fsh
	{
        //get coords and direction
        vec2 uv=fragCoord.xy-.5;
        if (iResolution.x > iResolution.y)
            uv.x *= iResolution.x / iResolution.y;
        else
            uv.y *= iResolution.y / iResolution.x;

        vec3 dir=vec3(uv*zoom,1.);
        float time=iTime*speed+.25;

        //mouse rotation
        vec3 from=vec3(0.0, 0.0, -15.0);
        //from = r(from, mo / 10.0);
        //dir = r(dir, mo / 10.0);
        from+=blackholeCenter;

        vec3 nml = normalize(blackholeCenter - from);
        vec3 pos = iPlane(from, dir, blackholeCenter, nml);
        pos = blackholeCenter - pos;

        float intensity = dot(pos, pos) * 0.4; //0.5 for bigger blackhole
        float pulse = sampleMusic();
        intensity *= -0.5*pulse*1.5 + 1.0;
        //intensity += -0.2*sampleMusicB();

        float distfading = def_distfading;
        distfading *= pulse*0.8 + 0.4;

        float blackholeRadius = def_blackholeRadius;
        //blackholeRadius += sampleMusicB();

        if(intensity > blackholeRadius * blackholeRadius){
            intensity = 1.0 / intensity;
            dir = mix(dir, pos * sqrt(intensity), blackholeIntensity * intensity);

            //volumetric rendering
            float s=0.1,fade=1.;
            vec3 v=vec3(0.);
            for (int r=0; r<volsteps; r++) {
                vec3 p=from+s*dir*.5;
                p = abs(vec3(tile)-mod(p,vec3(tile*2.))); // tiling fold
                float pa,a=pa=0.;
                for (int i=0; i<iterations; i++) {
                    p=abs(p)/dot(p,p)-formuparam; // the magic formula
                    a+=abs(length(p)-pa); // absolute sum of average change
                    pa=length(p);
                }
                float dm=max(0.,darkmatter-a*a*.001); //dark matter
                a*=a*a; // add contrast
                if (r>6) fade*=1.-dm; // dark matter, don't render near
                //v+=vec3(dm,dm*.5,0.);
                v+=fade;
                v+=vec3(s,s*s,s*s*s*s)*a*brightness*fade; // coloring based on distance
                fade*=distfading; // distance fading
                s+=stepsize;
            }
            v=mix(vec3(length(v)),v,saturation); //color adjust
            outColor = vec4(v*.01, 1.0);
        }
        else outColor = vec4(0.0);
    }

	{
        vec2 uv = fragCoord.xy; // / iResolution.xy;
        vec2 centered = 2.0 * uv - 1.0;
        if (iResolution.x > iResolution.y)
            centered.x *= iResolution.x / iResolution.y;
        else
            centered.y *= iResolution.y / iResolution.x;

        float dist2 = 1.5 * dot(centered, centered);
        float clamped_dist = smoothstep(0.0, 1.0, dist2);
        float arclength    = abs(atan(centered.y, centered.x) / radians(360.0))+0.01;

        // Color variation functions
        float t = iTime / 100.0;
        float polychrome = (1.0 + sin(t*50.0))/2.0; // 0 -> uniform color, 1 -> full spectrum
        vec3 spline_args = fract(vec3(polychrome*uv.x-t) + vec3(0.0, -1.0/3.0, -2.0/3.0));
        vec3 spline = B2_spline(spline_args);

        float f = abs(centered.y);
        vec3 base_color  = vec3(1.0, 1.0, 1.0) - f*spline;
        vec3 flame_color = pow(base_color, vec3(3.0));
        vec3 disc_color  = 0.30 * base_color; //0.20 * base_color;
        vec3 wave_color  = 0.30 * base_color; //0.10 * base_color;
        vec3 flash_color = 0.15 * base_color; //0.05 * base_color;

        float sample1 = audio_freq(iChannel0, abs((uv.x - .5) / WIDTH) + 0.01);
        float sample2 = audio_ampl(iChannel0, clamped_dist);
        float sample3 = audio_ampl(iChannel0, arclength);

        float disp_dist = smoothstep(-0.2, -0.1, sample3-dist2);
        disp_dist *= (1.0 - disp_dist);

        vec3 color = vec3(0.0);

        // spline debug
        // vec3 s = smoothstep(-0.01, 0.01, spline-uv.y); color += (1.0-s) * s;

		float v = abs(uv.y - 0.5); //*2.0 for smaller waveform
        color += flame_color * smoothstep(v, v*8.0, sample1);
        color += disc_color  * smoothstep(0.5, 1.0, sample2) * (1.0 - clamped_dist);
        color += flash_color * smoothstep(0.5, 1.0, sample3) * clamped_dist;
        color += wave_color  * disp_dist;
        //color = pow(color, vec3(0.4545));
        //color = pow(color, vec3(0.7));

        outColor += vec4(color, 1.0);
	}

	gl_FragColor = outColor;
}