// Modified from https://www.shadertoy.com/view/XlX3Rj

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform float iTime;
uniform float iAlpha;


// This content is under the MIT License.

#define time iTime*.02
#define num_loop 4


#define width .005
float zoom = .18;

float shape=0.;
vec3 color=vec3(0.);

float sampleMusic()
{
/*
	return 0.5 * (
			//texture( iChannel0, vec2( 0.01, 0.25 ) ).x +
			//texture( iChannel0, vec2( 0.07, 0.25 ) ).x +
			texture2D( iChannel0, vec2( 0.15, 0.25 ) ).x +
			texture2D( iChannel0, vec2( 0.30, 0.25 ) ).x);
*/
	return 0.2 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

void formula(vec2 z, float c, float pulse) {
	float minit=0.;
	float o,ot2,ot=ot2=1000.;
	for (int i=0; i<9; i++) {
		z=abs(z)/clamp(dot(z,z),.1,.5)-c;
		float l=length(z);
		o=min(max(abs(min(z.x,z.y)),-l+.25),abs(l-.25));
		ot=min(ot,o);
		ot2=min(l*.1,ot2);
		minit=max(minit,float(i)*(1.-abs(sign(ot-o))));
	}
	minit+=1.;
	float w=width*minit*2.;
	float circ=pow(max(0.,w-ot2)/w,6.);
	shape+=max(pow(max(0.,w-ot)/w,.25),circ);
	vec3 col=normalize(.1+texture2D(iChannel1,vec2(minit*.1)).rgb);
	color+=col*(.4+mod(minit/9.-time*10.+ot2*2.,1.)*1.6);
	//color+=vec3(1.,.7,.3)*circ*(10.-minit)*3.*smoothstep(0.,.5,.15+texture2D(iChannel0,vec2(.0,1.)).x-.5);
	color+=vec3(1.,.7,.3)*circ*(10.-minit)*3.*smoothstep(0.,.5,.15+pulse-.5);
}


void main()
{
	vec2 pos = fragCoord.xy - .5; // / iResolution.xy - .5;
	//pos.x*=iResolution.x/iResolution.y;
	if (iResolution.x > iResolution.y)
		pos.x *= iResolution.x / iResolution.y;
	else
		pos.y *= iResolution.y / iResolution.x;

	vec2 uv=pos;
	float pulse = sampleMusic();
	float sph = length(uv); sph = sqrt(1. - sph*sph)*1.0*(1.0+pulse*0.5);
	uv=normalize(vec3(uv,sph)).xy;
	float a=time;//+mod(time,1.)*.5;
	//vec2 luv=uv;
	float b=a*5.48535;
	uv*=mat2(cos(b),sin(b),-sin(b),cos(b));
	uv+=vec2(sin(a),cos(a*.5))*8.;
	uv*=zoom;
	float pix=.5/iResolution.x*zoom/sph;
	//float dof=max(1.,(10.-mod(time,1.)/.01));
	float dof=1.; //SLOWHAND: to remove blurring first time
	float c=1.5+mod(floor(time),6.)*.125;
	for (int aa=0; aa<num_loop; aa++) {
		vec2 aauv=floor(vec2(float(aa)/6.,mod(float(aa),6.)));
		formula(uv+aauv*pix*dof,c,pulse);
	}
	shape/=float(num_loop); color/=float(num_loop);
	vec3 colo=mix(vec3(.15),color,shape)*(1.-length(pos))*min(1.,abs(.5-mod(time+.5,1.))*10.);
	//vec3 colo=mix(vec3(.15),color,shape)*(1.-length(pos)); //SLOWHAND: to remove fade in at first time
	colo*=vec3(1.2,1.1,1.0);
	gl_FragColor = vec4(colo, 1.0);
}
