// Modified from https://www.shadertoy.com/view/7slGWj

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;

float RAYS = 54.0;
//https://soundcloud.com/castorcinema/beat-of-broken-hearts-feat
//https://soundcloud.com/clemenswenners/africa
//https://soundcloud.com/noa-edwardsson/we-are-the-ones
//https://soundcloud.com/br-ndon-kucharek/rings-of-saturn-utopia
//https://soundcloud.com/mukunda-mtandari/smooth-and-sexy-smooth-jazz-for-lovers

float R21(vec2 uv)
{
    float a = abs(sin(uv.x*1.1));
    float b = abs(cos(uv.y*104.7));
    return(a*b);
}


//Avståndet mellan punkten p och linjen från a till b
float DistLine(vec2 p, vec2 a, vec2 b)
{
    vec2 ap = p-a;
    vec2 ab = b-a;
    float lShadow = dot(ap, ab);
    float lab = dot(ab, ab);
    float t = clamp(lShadow/lab, 0.0, 1.0);
    vec2 sp = ap - ab*t;
    return length(sp);
}

float GetDist(vec2 uv, vec2 rayP)
{
    vec2 origin = vec2(0.0,0.0);
    float d = DistLine(uv, origin, rayP);
    float w = 0.05;
    float wz = 0.01;
    float c = smoothstep(w/RAYS, w/RAYS+wz, d);
    return c;
}

vec2 GetRayPoint(float rayNumber, float length)
{
    float angle = rayNumber/RAYS*6.28;
    float x = cos(angle)*length;
    float y = sin(angle)*length;
    vec2 p = vec2(x,y);
    return p;
}

vec2 Rotate(vec2 uv, float angle){
    float s = sin(angle);
    float c = cos(angle);
    float x = c*uv.x + s*uv.y;
    float y = s*uv.x - c*uv.y;
    return vec2(x,y);
}

float GetRayNumber(vec2 uv)
{
    float angle = (atan(uv.y, uv.x)/6.28);
    float ray = angle*RAYS;
    return ray;
}

float GetRayWheel(vec2 uv, float freqOffset, float raylength, float rotate)
{
    uv = Rotate(uv, rotate);
    float ray = GetRayNumber(uv);
    float raycenter = floor(ray);
    float frequency = raycenter + RAYS/2.0;
    if (frequency < 0.1) frequency = RAYS;
    frequency += freqOffset;
    float fft = raylength * texture2D(iChannel0, vec2(frequency/256., 0)).x;

    vec2 p = GetRayPoint(raycenter, fft);
    float d = (1.0-GetDist(uv, p));
    float pSize = 0.99;
    float pc = smoothstep(pSize, 1.0, 1.0-length(uv-p));
    float pcBlink = 0.5 + 0.5*sin(iTime*20.0+raycenter);
    pc *=pcBlink;

    raycenter = ceil(ray);
    frequency = raycenter + RAYS/2.0;
    if (frequency < 0.1) frequency = RAYS;
    frequency += freqOffset;
    fft = raylength * texture2D(iChannel0, vec2(frequency/256., 0)).x;
    p = GetRayPoint(raycenter, fft);
    d += (1.0-GetDist(uv, p));
    float c = d*length(uv);
    if ((RAYS/2.0-raycenter)<0.1) raycenter = -raycenter;
    pcBlink = 0.5 + 0.5*sin(iTime*20.0+raycenter);
    pc += smoothstep(pSize, 1.0, 1.0-length(uv-p))*pcBlink;
    c *= R21(uv);
    return 10.0*c+25.0*pc;
}

void main()
{
    // Normalized pixel coordinates (from -0.5 to 0.5 vertically)
    vec2 uv = (fragCoord-0.5);
	if (iResolution.x > iResolution.y)
		uv.x *= iResolution.x / iResolution.y;
	else
		uv.y *= iResolution.y / iResolution.x;
    uv*=1.5;
    uv = Rotate(uv,-iTime*0.3);
    vec3 col = 0.3+0.3*vec3(sin(iTime*0.5),sin(iTime*0.4),sin(iTime*0.3));

    float c = GetRayWheel(uv, 0.0, 1.0, 0.0);

    float rotation = -iTime*0.1;
    c += 1.4*GetRayWheel(uv, 2.0*RAYS, 0.4, rotation);

    rotation = -iTime*0.2;
    c += 1.4*GetRayWheel(uv, RAYS, 0.75, rotation);

    col *= c;
    float d = 1.5-length(uv);

    //vec3 dcol = vec3(0.5, 0.5, 0.1);
    float r = (sin(iTime * 0.2) * 0.5 + 0.3);
    float b = (cos(iTime * 0.2) * 0.5 + 0.3);
    vec3 dcol = vec3(r, 0.3, b);// * length(uv * 0.75) * 0.5;

    col += d*dcol;

    d = smoothstep(0.8, 1.2, 1.0-length(uv));
    dcol = vec3(0.5);
    col += d*dcol;

    // Output to screen
    gl_FragColor = vec4(col, 1.0);
}
