// Modified from https://www.shadertoy.com/view/4ljGD1

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;

float squared(float value) { return value * value; }

float getAmp(float frequency) { return texture2D(iChannel0, vec2(frequency / 22050.0, 0)).x; }  // todo

float getAmp2(float f1, float f2, float f3) {
	//return max(max(getAmp(f1), getAmp(f2)), getAmp(f3))
	return (getAmp(f1) + getAmp(f2) + getAmp(f3)) * 0.5 / 3.0;
}

float getWeight(float f) {
    return (+ getAmp(f-2.0) + getAmp(f-1.0) + getAmp(f+2.0) + getAmp(f+1.0) + getAmp(f)) / 5.0; }

void main()
{
	vec2 uvTrue = fragCoord.xy;
    vec2 uv = -1.0 + 2.0 * uvTrue;

	float lineIntensity;
    float glowWidth;
    vec3 color = vec3(0.0);
/*
	for(float i = 0.0; i < 3.0; i++) {

		uv.y += (0.2 * sin(uv.x + i/7.0 - iTime * 0.6));
        float Y = uv.y + getAmp((squared(i) * 20.0) + 60.0) *
            (texture2D(iChannel0, vec2(uvTrue.x, 1)).x - 0.5);
        lineIntensity = 0.4 + squared(1.6 * abs(mod(uvTrue.x + i / 1.3 + iTime,2.0) - 1.0));
		glowWidth = abs(lineIntensity / (150.0 * Y));
		color += vec3(glowWidth * (2.0 + sin(iTime * 0.13)),
                      glowWidth * (2.0 - sin(iTime * 0.23)),
                      glowWidth * (2.0 - cos(iTime * 0.19)));
	}
*/
    float i;
    float Y;

    i = 0.0;
		uv.y += (0.2 * sin(uv.x + i/7.0 - iTime * 0.6));
//        Y = uv.y + ((getAmp(60.0) + getAmp(100.0) + getAmp(140.0) + getAmp(180.0) + getAmp(220.0)) / 5.0) *
//            (texture2D(iChannel0, vec2(uvTrue.x, 1)).x - 0.5);
//        Y = uv.y + (getAmp(100.0)) * (texture2D(iChannel0, vec2(uvTrue.x, 1)).x - 0.5);
        Y = uv.y + getAmp2(60.0, 100.0, 140.0) *
            (texture2D(iChannel0, vec2(uvTrue.x, 1)).x - 0.5);
        lineIntensity = 0.2 + /*squared*/(1.6 * abs(mod(uvTrue.x + i / 1.3 + iTime,2.0) - 1.0));
		glowWidth = abs(lineIntensity / (150.0 * Y));
		color += vec3(glowWidth * (2.0 + sin(iTime * 0.13)),
                      glowWidth * (2.0 - sin(iTime * 0.23)),
                      glowWidth * (2.0 - cos(iTime * 0.19)));

    i = 1.0;
		uv.y += (0.2 * sin(uv.x + i/7.0 - iTime * 0.6));
//        Y = uv.y + ((getAmp(500.0) + getAmp(1000.0) + getAmp(1500.0) + getAmp(2000.0) + getAmp(2500.0)) / 5.0) *
//            (texture2D(iChannel0, vec2(uvTrue.x, 1)).x - 0.5);
//        Y = uv.y + (getAmp(1500.0)) * (texture2D(iChannel0, vec2(uvTrue.x, 1)).x - 0.5);
        Y = uv.y + getAmp2(500.0, 1000.0, 1500.0) *
            (texture2D(iChannel0, vec2(uvTrue.x, 1)).x - 0.5);
        lineIntensity = 0.2 + /*squared*/(1.6 * abs(mod(uvTrue.x + i / 1.3 + iTime,2.0) - 1.0));
		glowWidth = abs(lineIntensity / (150.0 * Y));
		color += vec3(glowWidth * (2.0 + sin(iTime * 0.13)),
                      glowWidth * (2.0 - sin(iTime * 0.23)),
                      glowWidth * (2.0 - cos(iTime * 0.19)));

    i = 2.0;
		uv.y += (0.2 * sin(uv.x + i/7.0 - iTime * 0.6));
//        Y = uv.y + ((getAmp(4000.0) + getAmp(5000.0) + getAmp(6000.0) + getAmp(7000.0) + getAmp(8000.0)) / 5.0) *
//            (texture2D(iChannel0, vec2(uvTrue.x, 1)).x - 0.5);
//        Y = uv.y + (getAmp(5000.0)) * (texture2D(iChannel0, vec2(uvTrue.x, 1)).x - 0.5);
        Y = uv.y + getAmp2(4000.0, 5000.0, 6000.0) *
            (texture2D(iChannel0, vec2(uvTrue.x, 1)).x - 0.5);
        lineIntensity = 0.2 + /*squared*/(1.6 * abs(mod(uvTrue.x + i / 1.3 + iTime,2.0) - 1.0));
		glowWidth = abs(lineIntensity / (150.0 * Y));
		color += vec3(glowWidth * (2.0 + sin(iTime * 0.13)),
                      glowWidth * (2.0 - sin(iTime * 0.23)),
                      glowWidth * (2.0 - cos(iTime * 0.19)));

	gl_FragColor = vec4(color, 1.0);
}