// Modified from https://www.shadertoy.com/view/3sGfD3

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform float iTime;
uniform float iAlpha;


float sampleMusic()
{
	return 0.2 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

#define rot(a) mat2(cos(a),sin(a),-sin(a),cos(a))

vec3 render(vec2 p, float pulse) {
//    p*=rot(iTime*.3)*(.2-(pulse*0.1)+.7*pow(smoothstep(0.,.5,abs(.5-fract(iTime*.02))),3.));
    p*=rot(iTime*.3)*(.2-(pulse*0.07)+.3*pow(smoothstep(0.,.5,abs(.5-fract(iTime*.02))),3.));
    p.y-=.2266;
    p.x+=.2082;
    vec2 ot=vec2(100.);
    float m=100.;
    for (int i=0; i<50; i++) {
        vec2 cp=vec2(p.x,-p.y);
		p=p+cp/dot(p,p)-vec2(0.,.25);
        p*=.1;
        p*=rot(1.5);
        ot=min(ot,abs(p)+.15*fract(max(abs(p.x),abs(p.y))*.25+iTime*.1+float(i)*.15));
        m=min(m,abs(p.y));
    }
    ot=exp(-200.*ot)*2.;
    m=exp(-200.*m);
    return vec3(ot.x,ot.y*.5+ot.x*.3,ot.y)+m*.2;
}

void main()
{
    vec2 uv = (fragCoord-.5);///iResolution.y;
	if (iResolution.x > iResolution.y)
        uv.x *= iResolution.x/iResolution.y;
    else
        uv.y *= iResolution.y/iResolution.x;

    //vec2 d=vec2(0.,.5);///iResolution.xy;
    float pulse = sampleMusic();
    vec3 col = render(uv, pulse)*(pulse*4.0+0.1);//+render(uv+d.xy)+render(uv-d.xy)+render(uv+d.yx)+render(uv-d.yx);
    gl_FragColor = vec4(col, 1.0);
}
