// Modified from https://www.shadertoy.com/view/MslGWN

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;


////////////////////////////////////////////////////////////////////////////////
//simplicity_galaxy.fsh

//CBS
//Parallax scrolling fractal galaxy.
//Inspired by JoshP's Simplicity shader: https://www.shadertoy.com/view/lslGWr

// http://www.fractalforums.com/new-theories-and-research/very-simple-formula-for-fractal-patterns/
float field(vec3 p, float s, int iter, float time) {
	//float strength = 7. + .03 * log(1.e-6 + fract(sin(time) * 4373.11));
	float strength = 9. + .03 * log(1.e-6 + fract(sin(time) * 4373.11));
	float accum = s/4.;
	float prev = 0.;
	float tw = 0.;
	for (int i = 0; i < iter; ++i) {
		float mag = dot(p, p);
		p = abs(p) / mag + vec3(-.5, -.4, -1.5);
		float w = exp(-float(i) / 7.);
		accum += w * exp(-strength * pow(abs(mag - prev), 2.2));
		tw += w;
		prev = mag;
	}
	return max(0., 5. * accum / tw - .7);
}

// Less iterations for second layer
/*
float field2(in vec3 p, float s) {
	//float strength = 7. + .03 * log(1.e-6 + fract(sin(iTime) * 4373.11));
	float strength = 9. + .03 * log(1.e-6 + fract(sin(iTime) * 4373.11));
	float accum = s/4.;
	float prev = 0.;
	float tw = 0.;
	for (int i = 0; i < 18; ++i) {
		float mag = dot(p, p);
		p = abs(p) / mag + vec3(-.5, -.4, -1.5);
		float w = exp(-float(i) / 7.);
		accum += w * exp(-strength * pow(abs(mag - prev), 2.2));
		tw += w;
		prev = mag;
	}
	return max(0., 5. * accum / tw - .7);
}
*/

vec3 nrand3( vec2 co )
{
	vec3 a = fract( cos( co.x*8.3e-3 + co.y )*vec3(1.3e5, 4.7e5, 2.9e5) );
	vec3 b = fract( sin( co.x*0.3e-3 + co.y )*vec3(8.1e5, 1.0e5, 0.1e5) );
	vec3 c = mix(a, b, 0.5);
	return c;
}
//simplicity_galaxy.fsh
////////////////////////////////////////////////////////////////////////////////


#define BARS 12.

#define PI 3.14159265359

// rotation transform
vec2 tRotate(vec2 p, float angel) {
    float s = sin(angel), c = cos(angel);
	p *= mat2(c, -s, s, c);
	return p;
}

// circle distance
float sdCircle(vec2 p, float r) {
    return length(p) - r;
}

// union
float opU(float a, float b) {
    return min(a, b);
}

// substraction
float opS(float a, float b) {
    return max(a, -b);
}

// distance function of half of an ark
// parameters: inner radius, outer radius, angle
float sdArk(vec2 p, float in_r, float out_r, float a) {

    // add outer circle
    float d = sdCircle(p, out_r);

    // substract inner circle
    d = opS(d, sdCircle(p, in_r));

    // rotate with angle
    p = tRotate(p, -a * PI / 2.);

    // clip the top
    d = opS(d, -p.y);

    // add circle to the top
    d = opU(d, sdCircle(p - vec2((out_r + in_r) / 2., 0.), (out_r - in_r) / 2.));
    return d;
}


void main() {
    vec4 outColor = vec4(0.0);
    float dist;

    {
        //vec2 uv = fragCoord.xy / iResolution.xy * 2. - 1.;
        vec2 uv=fragCoord.xy-.5;
        if (iResolution.x > iResolution.y)
            uv.x *= iResolution.x / iResolution.y;
        else
            uv.y *= iResolution.y / iResolution.x;

        // I wanted it to look good on my phone vertically :P
        //if (iResolution.x > iResolution.y) uv.x *= iResolution.x / iResolution.y; else uv.y *= iResolution.y / iResolution.x;

        // little white padding
        uv *= 2.0;
        uv *= 1.2;

        dist = length(uv);

        // add circles
        float d = sdCircle(uv, 1.);
        d = opS(d, sdCircle(uv, .34));
        d = opU(d, sdCircle(uv, .04));

        // calculate position of the bars
        float barsStart = .37;
        float barsEnd = .94;
        float barId = floor((length(uv) -barsStart) / (barsEnd - barsStart) * BARS);

        // only go forward if we're in a bar
        if (barId >= 0. && barId < BARS) {

            float barWidth = (barsEnd - barsStart) / BARS;
            float barStart = barsStart + barWidth * (barId + .25);
            float barAngel = texture2D(iChannel0, vec2(1. - barId / BARS, .25)).x * .7;

            // add a little rotation to completely ruin the beautiful symmetry
            uv = tRotate(uv, -barAngel * .2 * sin(barId + iTime));
            uv = tRotate(uv, iTime);

            // mirror everything
            uv = abs(uv);

            // add the bars
            d = opS(d, sdArk(uv, barStart, barStart + barWidth / 2., barAngel));
        }

        // use the slope to render the distance with antialiasing
        //float w = min(fwidth(d), .01);
        float w = 0.001; //android does not work with fwidth
        outColor += vec4(vec3(smoothstep(-w, w, d)), 1.0);
    }

	////////////////////////////////////////////////////////////////////////////////
	//simplicity_galaxy.fsh
	if (dist < 1.0)
    {
        vec2 uv = 2. * fragCoord.xy - 1.;
        vec2 uvs = uv * iResolution.xy / max(iResolution.x, iResolution.y);
        vec3 p = vec3(uvs / 4., 0) + vec3(1., -1.3, 0.);
        float xTime = iTime * 2.0;
        p += .2 * vec3(sin(xTime / 16.), sin(xTime / 12.),  sin(xTime / 128.));

        float freqs[4];
        //Sound
        freqs[0] = texture2D( iChannel0, vec2( 0.01, 0.25 ) ).x;
        freqs[1] = texture2D( iChannel0, vec2( 0.07, 0.25 ) ).x;
        freqs[2] = texture2D( iChannel0, vec2( 0.15, 0.25 ) ).x;
        freqs[3] = texture2D( iChannel0, vec2( 0.30, 0.25 ) ).x;

        float t = field(p,freqs[2],26,xTime);
        float v = (1. - exp((abs(uv.x) - 1.) * 6.)) * (1. - exp((abs(uv.y) - 1.) * 6.));

        //Second Layer
        vec3 p2 = vec3(uvs / (4.+sin(xTime*0.11)*0.2+0.2+sin(xTime*0.15)*0.3+0.4), 1.5) + vec3(2., -1.3, -1.);
        p2 += 0.25 * vec3(sin(xTime / 16.), sin(xTime / 12.),  sin(xTime / 128.));
        float t2 = field(p2,freqs[3],18,xTime); //field2(p2,freqs[3]);
        vec4 c2 = mix(.4, 1., v) * vec4(1.3 * t2 * t2 * t2 ,1.8  * t2 * t2 , t2* freqs[0], t2);


        //Let's add some stars
        //Thanks to http://glsl.heroku.com/e#6904.0
        vec2 seed = p.xy * 2.0;
        seed = floor(seed * iResolution.x);
        vec3 rnd = nrand3( seed );
        vec4 starcolor = vec4(pow(rnd.y,40.0));

        //Second Layer
        vec2 seed2 = p2.xy * 2.0;
        seed2 = floor(seed2 * iResolution.x);
        vec3 rnd2 = nrand3( seed2 );
        starcolor += vec4(pow(rnd2.y,40.0));

        outColor += mix(freqs[3]-.3, 1., v) * vec4(1.5*freqs[2] * t * t* t , 1.2*freqs[1] * t * t, freqs[3]*t, 1.0)+c2+starcolor;
    }

	gl_FragColor = outColor;
}