// Modified from https://www.shadertoy.com/view/MslGWN

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;


////////////////////////////////////////////////////////////////////////////////
//simplicity_galaxy.fsh

//CBS
//Parallax scrolling fractal galaxy.
//Inspired by JoshP's Simplicity shader: https://www.shadertoy.com/view/lslGWr

// http://www.fractalforums.com/new-theories-and-research/very-simple-formula-for-fractal-patterns/
float field(vec3 p, float s, int iter, float time) {
	//float strength = 7. + .03 * log(1.e-6 + fract(sin(time) * 4373.11));
	float strength = 9. + .03 * log(1.e-6 + fract(sin(time) * 4373.11));
	float accum = s/4.;
	float prev = 0.;
	float tw = 0.;
	for (int i = 0; i < iter; ++i) {
		float mag = dot(p, p);
		p = abs(p) / mag + vec3(-.5, -.4, -1.5);
		float w = exp(-float(i) / 7.);
		accum += w * exp(-strength * pow(abs(mag - prev), 2.2));
		tw += w;
		prev = mag;
	}
	return max(0., 5. * accum / tw - .7);
}

// Less iterations for second layer
/*
float field2(in vec3 p, float s) {
	//float strength = 7. + .03 * log(1.e-6 + fract(sin(iTime) * 4373.11));
	float strength = 9. + .03 * log(1.e-6 + fract(sin(iTime) * 4373.11));
	float accum = s/4.;
	float prev = 0.;
	float tw = 0.;
	for (int i = 0; i < 18; ++i) {
		float mag = dot(p, p);
		p = abs(p) / mag + vec3(-.5, -.4, -1.5);
		float w = exp(-float(i) / 7.);
		accum += w * exp(-strength * pow(abs(mag - prev), 2.2));
		tw += w;
		prev = mag;
	}
	return max(0., 5. * accum / tw - .7);
}
*/

vec3 nrand3( vec2 co )
{
	vec3 a = fract( cos( co.x*8.3e-3 + co.y )*vec3(1.3e5, 4.7e5, 2.9e5) );
	vec3 b = fract( sin( co.x*0.3e-3 + co.y )*vec3(8.1e5, 1.0e5, 0.1e5) );
	vec3 c = mix(a, b, 0.5);
	return c;
}
//simplicity_galaxy.fsh
////////////////////////////////////////////////////////////////////////////////


#define WAVES 8.0


void main() {
    vec4 outColor;

	////////////////////////////////////////////////////////////////////////////////
	//simplicity_galaxy.fsh
    {
        vec2 uv = 2. * fragCoord.xy - 1.;
        vec2 uvs = uv * iResolution.xy / max(iResolution.x, iResolution.y);
        vec3 p = vec3(uvs / 4., 0) + vec3(1., -1.3, 0.);
        float xTime = iTime * 2.0;
        p += .2 * vec3(sin(xTime / 16.), sin(xTime / 12.),  sin(xTime / 128.));

        float freqs[4];
        //Sound
        freqs[0] = texture2D( iChannel0, vec2( 0.01, 0.25 ) ).x;
        freqs[1] = texture2D( iChannel0, vec2( 0.07, 0.25 ) ).x;
        freqs[2] = texture2D( iChannel0, vec2( 0.15, 0.25 ) ).x;
        freqs[3] = texture2D( iChannel0, vec2( 0.30, 0.25 ) ).x;

        float t = field(p,freqs[2],26,xTime);
        float v = (1. - exp((abs(uv.x) - 1.) * 6.)) * (1. - exp((abs(uv.y) - 1.) * 6.));

        //Second Layer
        vec3 p2 = vec3(uvs / (4.+sin(xTime*0.11)*0.2+0.2+sin(xTime*0.15)*0.3+0.4), 1.5) + vec3(2., -1.3, -1.);
        p2 += 0.25 * vec3(sin(xTime / 16.), sin(xTime / 12.),  sin(xTime / 128.));
        float t2 = field(p2,freqs[3],18,xTime); //field2(p2,freqs[3]);
        vec4 c2 = mix(.4, 1., v) * vec4(1.3 * t2 * t2 * t2 ,1.8  * t2 * t2 , t2* freqs[0], t2);


        //Let's add some stars
        //Thanks to http://glsl.heroku.com/e#6904.0
        vec2 seed = p.xy * 2.0;
        seed = floor(seed * iResolution.x);
        vec3 rnd = nrand3( seed );
        vec4 starcolor = vec4(pow(rnd.y,40.0));

        //Second Layer
        vec2 seed2 = p2.xy * 2.0;
        seed2 = floor(seed2 * iResolution.x);
        vec3 rnd2 = nrand3( seed2 );
        starcolor += vec4(pow(rnd2.y,40.0));

        outColor = mix(freqs[3]-.3, 1., v) * vec4(1.5*freqs[2] * t * t* t , 1.2*freqs[1] * t * t, freqs[3]*t, 1.0)+c2+starcolor;
    }

    {
        vec2 uv = -1.0 + 2.0 * fragCoord.xy;// / iResolution.xy;

        float time = iTime * 5.0;

        vec3 color = vec3(0.0);

        for (float i=0.0; i<WAVES + 1.0; i++) {
            float freq = texture2D(iChannel0, vec2(i / WAVES, 0.0)).x * 5.0;

            vec2 p = vec2(uv);

            p.x += i * 0.04 + freq * 0.03;
            p.y += sin(p.x * 10.0 + time) * cos(p.x * 2.0) * freq * 0.2 * ((i + 1.0) / WAVES);
            float intensity = abs(0.01 / p.y) * clamp(freq, 0.35, 2.0);
            color += vec3(1.0 * intensity * (i / 5.0), 0.5 * intensity, 1.75 * intensity) * (3.0 / WAVES);
        }

        outColor += vec4(color, 1.0);
    }

	gl_FragColor = outColor;
}