// Modified from https://www.shadertoy.com/view/3sSfRd

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;


//https://www.shadertoy.com/view/XsXXDn
//credits to 'Danilo Guanabara'

#define t iTime
#define r iResolution.xy

float circleFade(float rr,vec2 center,vec2 uv){
    float col=0.;
    float dist=length(uv-center);
    if(dist<rr){
        col=clamp(dist,0.,1.);
    }
    return col;
}

float sampleMusic()
{
	return 0.2 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

void main(){

   	float angle = 0.1*t;
	mat2 rotationMatrix = mat2(cos(angle), -sin(angle),
                               sin(angle),  cos(angle));

    vec2 uv,p=fragCoord.xy;///r;
    uv=p;

    //p-=.5;
    //if (r.x > r.y)
    //   p.x *= r.x / r.y;
    //else
    //   p.y *= r.y / r.x;

    float mData = sampleMusic(); //texture2D( iChannel0, vec2(6,0) ).x; //音频数据
	vec3 c;
	float l,z=t;//音频数据影响时间
	for(int i=0;i<3;i++) {

		p-=.5;
		p.x*=r.x/r.y;
		z+=.07;
		l=length(p);
		uv+=p/l*(sin(z)+1.-mData*mData*mData)*abs(sin(9.-z*1.));
        uv*=rotationMatrix;
		c[i]=(.03/length(abs(mod(1.9*uv,1.)-.5)));
	}
    vec2 ct = vec2(.5);

    float dark=circleFade(.1,ct,uv);

    vec3 col=mix(c/l,vec3(dark),.1);
    //vec3 col = vec3(dark);
	gl_FragColor=vec4(col,t);
}