// Modified from https://www.shadertoy.com/view/MtByRh

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform float iTime;
uniform float iAlpha;

////////////////////////////////////////////////////////////////////////////////
//lensing.fsh
// This content is under the MIT License.

#define iterations 12
#define formuparam 0.57

#define volsteps 10
#define stepsize 0.2

#define zoom   1.200
#define tile   1.0
#define speed  0.010

#define brightness 0.0015
#define darkmatter 1.00
#define def_distfading 0.730
#define saturation 1.0

//#define mo (2.0 * iMouse.xy - iResolution.xy) / iResolution.y
#define blackholeCenter vec3(time*2.,time,-2.)
#define def_blackholeRadius 0.5
#define blackholeIntensity 1.0

float iSphere(vec3 ray, vec3 dir, vec3 center, float radius)
{
	vec3 rc = ray-center;
	float c = dot(rc, rc) - (radius*radius);
	float b = dot(dir, rc);
	float d = b*b - c;
	float t = -b - sqrt(abs(d));
	float st = step(0.0, min(t,d));
	return mix(-1.0, t, st);
}

vec3 iPlane(vec3 ro, vec3 rd, vec3 po, vec3 pd){
    float d = dot(po - ro, pd) / dot(rd, pd);
    return d * rd + ro;
}

vec3 r(vec3 v, vec2 r)//incomplete but ultrafast rotation fcn thnx to rodolphito
{
    vec4 t = sin(vec4(r, r + 1.5707963268));
    float g = dot(v.yz, t.yw);
    return vec3(v.x * t.z - g * t.x,
                v.y * t.w - v.z * t.y,
                v.x * t.x + g * t.z);
}

float sampleMusicA() {
/*
	return 0.5 * (
		texture2D( iChannel0, vec2( 0.15, 0.25 ) ).x +
		texture2D( iChannel0, vec2( 0.30, 0.25 ) ).x);
*/
	return 1.0 / 3.0 * (
//		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

float sampleMusicB() {
	return 1.0 / 2.0 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
//		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

float sampleMusic() {
	return 1.0 / 5.0 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}
//lensing.fsh
////////////////////////////////////////////////////////////////////////////////


#define BARS 12.

#define PI 3.14159265359

// rotation transform
vec2 tRotate(vec2 p, float angel) {
    float s = sin(angel), c = cos(angel);
	p *= mat2(c, -s, s, c);
	return p;
}

// circle distance
float sdCircle(vec2 p, float r) {
    return length(p) - r;
}

// union
float opU(float a, float b) {
    return min(a, b);
}

// substraction
float opS(float a, float b) {
    return max(a, -b);
}

// distance function of half of an ark
// parameters: inner radius, outer radius, angle
float sdArk(vec2 p, float in_r, float out_r, float a) {

    // add outer circle
    float d = sdCircle(p, out_r);

    // substract inner circle
    d = opS(d, sdCircle(p, in_r));

    // rotate with angle
    p = tRotate(p, -a * PI / 2.);

    // clip the top
    d = opS(d, -p.y);

    // add circle to the top
    d = opU(d, sdCircle(p - vec2((out_r + in_r) / 2., 0.), (out_r - in_r) / 2.));
    return d;
}


void main()
{
    vec4 outColor = vec4(0.0);
    float dist;

	{
        //vec2 uv = fragCoord.xy / iResolution.xy * 2. - 1.;
        vec2 uv=fragCoord.xy-.5;
        if (iResolution.x > iResolution.y)
            uv.x *= iResolution.x / iResolution.y;
        else
            uv.y *= iResolution.y / iResolution.x;

        // I wanted it to look good on my phone vertically :P
        //if (iResolution.x > iResolution.y) uv.x *= iResolution.x / iResolution.y; else uv.y *= iResolution.y / iResolution.x;

        // little white padding
        uv *= 2.0;
        uv *= 1.2;

        dist = length(uv);

        // add circles
        float d = sdCircle(uv, 1.);
        d = opS(d, sdCircle(uv, .34));
        d = opU(d, sdCircle(uv, .04));

        // calculate position of the bars
        float barsStart = .37;
        float barsEnd = .94;
        float barId = floor((length(uv) -barsStart) / (barsEnd - barsStart) * BARS);

        // only go forward if we're in a bar
        if (barId >= 0. && barId < BARS) {

            float barWidth = (barsEnd - barsStart) / BARS;
            float barStart = barsStart + barWidth * (barId + .25);
            float barAngel = texture2D(iChannel0, vec2(1. - barId / BARS, .25)).x * .7;

            // add a little rotation to completely ruin the beautiful symmetry
            uv = tRotate(uv, -barAngel * .2 * sin(barId + iTime));
            uv = tRotate(uv, iTime);

            // mirror everything
            uv = abs(uv);

            // add the bars
            d = opS(d, sdArk(uv, barStart, barStart + barWidth / 2., barAngel));
        }

        // use the slope to render the distance with antialiasing
        //float w = min(fwidth(d), .01);
        float w = 0.001; //android does not work with fwidth
        outColor += vec4(vec3(smoothstep(-w, w, d)), 1.0);
	}

	////////////////////////////////////////////////////////////////////////////////
	//lensing.fsh
	if (dist < 1.0)
	{
        //get coords and direction
        vec2 uv=fragCoord.xy-.5;
        if (iResolution.x > iResolution.y)
            uv.x *= iResolution.x / iResolution.y;
        else
            uv.y *= iResolution.y / iResolution.x;

        vec3 dir=vec3(uv*zoom,1.);
        float time=iTime*speed+.25;

        //mouse rotation
        vec3 from=vec3(0.0, 0.0, -15.0);
        //from = r(from, mo / 10.0);
        //dir = r(dir, mo / 10.0);
        from+=blackholeCenter;

        vec3 nml = normalize(blackholeCenter - from);
        vec3 pos = iPlane(from, dir, blackholeCenter, nml);
        pos = blackholeCenter - pos;

        float intensity = dot(pos, pos) * 0.4; //0.5 for bigger blackhole
        float pulse = sampleMusic();
        intensity *= -0.5*pulse*1.5 + 1.0;
        //intensity += -0.2*sampleMusicB();

        float distfading = def_distfading;
        distfading *= pulse*0.8 + 0.4;

        float blackholeRadius = def_blackholeRadius;
        //blackholeRadius += sampleMusicB();

        if(intensity > blackholeRadius * blackholeRadius){
            intensity = 1.0 / intensity;
            dir = mix(dir, pos * sqrt(intensity), blackholeIntensity * intensity);

            //volumetric rendering
            float s=0.1,fade=1.;
            vec3 v=vec3(0.);
            for (int r=0; r<volsteps; r++) {
                vec3 p=from+s*dir*.5;
                p = abs(vec3(tile)-mod(p,vec3(tile*2.))); // tiling fold
                float pa,a=pa=0.;
                for (int i=0; i<iterations; i++) {
                    p=abs(p)/dot(p,p)-formuparam; // the magic formula
                    a+=abs(length(p)-pa); // absolute sum of average change
                    pa=length(p);
                }
                float dm=max(0.,darkmatter-a*a*.001); //dark matter
                a*=a*a; // add contrast
                if (r>6) fade*=1.-dm; // dark matter, don't render near
                //v+=vec3(dm,dm*.5,0.);
                v+=fade;
                v+=vec3(s,s*s,s*s*s*s)*a*brightness*fade; // coloring based on distance
                fade*=distfading; // distance fading
                s+=stepsize;
            }
            v=mix(vec3(length(v)),v,saturation); //color adjust
            outColor += vec4(v*.01, 1.0);
        }
        else outColor += vec4(0.0);
    }

	gl_FragColor = outColor;
}