// Modified from https://www.shadertoy.com/view/tllfzB

precision highp float;

varying vec2 fragCoord;
uniform vec3 iResolution;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform float iTime;
uniform float iAlpha;


float sampleMusic()
{
	return 0.2 * (
		texture2D( iChannel0, vec2( 100.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 500.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 2000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 4000.0/22050.0, 0.25 ) ).x
		+ texture2D( iChannel0, vec2( 6000.0/22050.0, 0.25 ) ).x
		);
}

//#define r iResolution.xy

vec3 f(vec2 p) {
    p.y+=cos(iTime*.5)*.4; // move camera up and down;
    p.x=abs(p.x+.1+(sin(iTime*0.3)*0.3)); // offset and mirror x axis
    p*=mat2(.7,.7,-.7,.7); // rotate ~45deg
    float y=1.-abs(p.y*3.),l=1.-length(p), m=1e2; // used for: y=horizon, l=light, m=orbit trap
	p=fract(vec2(p.x/p.y,1./p.y+iTime*1.*sign(p.y))*.5); // 3D projection, tiling and and forward movement
    for (int i=0; i<18; i++) p=abs(p*1.5)/(p.x*p.y)-2.,m=min(m,abs(p.y)+abs(.5-fract(p.x*.5+iTime))); // fractal & orbit trap
    m=exp(-10.*m); // something like inverting and compressing the orbit trap result
    return mix(min(vec3(1.),vec3(m,m*m,m*m*m)*3.+p.x*p.x*.1),vec3(1,.5,.3),y)+l*l*l*sampleMusic()*2.; // coloring
}

void main()
{
    vec3 col;
    vec2 uv = (fragCoord-.5);
	if (iResolution.x > iResolution.y)
        uv.x *= iResolution.x/iResolution.y;
    else
        uv.y *= iResolution.y/iResolution.x;

	//vec2 d;
    // antialiasing
    //for (float i=-4.; i<4.; i++) {
    //	for (float j=-4.; j<4.; j++) {
    		//d=vec2(0.0,0.0)*.2/r;
    		col=f(uv);
	//    }
    //}
    gl_FragColor = vec4(col, 1.0);
}
