#!/usr/bin/env ruby

# This script generates file_locale.properties files
# out of iOS .lproj/*.strings files.
#
# 1. copy iOS .lproj folders into the script's directory
# 2. run ./convert.rb
# 3. enjoy

require 'fileutils'

def locale_and_file(path)
  components = path.split("/")
  locale = (components[0].gsub ".lproj", "").gsub "-", "_"
  file = (components[1].gsub ".strings", "").downcase
  "#{file}_#{locale}.properties"
end

def convert_content(path)
  File.readlines(path).each.map { |line|
    ((line
    .gsub "\"", "") # replace "
    .gsub ";", "") # remove ;
    .gsub " = ", "=" # remove spaces around =
  }.select { |line|
    !line.start_with?("/*") && line.length > 0 && line != "\n"
  }
end

def convert_file(path)
  target = locale_and_file(path).gsub "_Base", ""
  content = convert_content(path)
  File.open(target, "w") { |f|
    f.puts(content)
  }
end

# collect all .lproj folders
folders = Dir.glob("**/").select { |d|
  d.end_with? ".lproj/"
}

# read all *.strings file paths into array
string_files = folders.flat_map { |d|
  Dir["#{d}*.strings"]
}

# convert all *.strings files and delete
string_files.each { |f| convert_file(f) }

# remove folders
folders.each { |f| FileUtils.rm_rf(f) }
