//
//  site-info.js
//  Instapaper
//
//  Created by Brian Donohue on 11/11/24.
//
function retrieveSiteName(ldjsonData) {
    console.log("retrieveSiteName: " + ldjsonData)

    if (ldjsonData) {
        var name = ldjsonData.name;
        if (name) {
            return name;
        }
    }

    var elem = document.querySelector("meta[property='og:site_name']");
    if (!elem) {
        return null;
    }
    return elem.getAttribute('content');
}

function retrieveImage(ldjsonData) {
    console.log("retrieveSiteImage: " + ldjsonData)

    if (ldjsonData) {
        var logo = ldjsonData.logo;
        if (typeof(logo) == 'string') {
            return logo;
        }
        else if (typeof(logo) == 'object' && logo.url) {
            return logo.url;
        }
    }

    var elem = document.querySelector("link[rel='apple-touch-icon']");
    if (!elem) {
        return null;
    }
    var href = elem.getAttribute('href');
    if (!href) {
        return null;
    }
    return new URL(href, document.baseURI).href
}

function processLDJSON() {
    console.log("processLDJSON")

    const scripts = document.querySelectorAll('script[type="application/ld+json"]');
    for (var i = 0; i < scripts.length; i++) {
        const script = scripts[i];
        var data = undefined;
        console.log(script);
        try {
            data = JSON.parse(script.text);
        } catch (error) {
            console.error('Error parsing LD+JSON:', error);
            continue;
        }

        if (data['@type'] == 'NewsMediaOrganization') {
            return data;
        }
    }
    return undefined;
}

function retrieveSiteInfo() {
    console.log("retrieveSiteInfo")

    const url = window.location.href;
    console.log("url: " + url)

    const ldjsonData = processLDJSON();
    console.log("ldjson: " + ldjsonData)

    const image = retrieveImage(ldjsonData);
    console.log("image: " + image)

    const site_name = retrieveSiteName(ldjsonData);
    console.log("site_name: " + site_name)

    Instapaper.onSavePaywallLogin(site_name, url, image);
}

retrieveSiteInfo();
