/*
 * Google Analytics v4 plugin for phonegap
 * Ver: 1.0
 *
 * Copyright 2014 RhythmicWorks Software LLP
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
cordova.define("com.rhythmicworks.phonegap.plugin.sharedPreferences.SharedPrefs",function(require, exports, module) {

function SharedPrefs() {}

    SharedPrefs.prototype.getData = function(sharedName, key, value,win, fail) {
        return cordova.exec(
                function (args) { if(win !== undefined) { win(args); } },
                function (args) { if(fail !== undefined) { fail(args); } },
                "SharedPrefs", "getData", [sharedName, key, value]);
    };
    SharedPrefs.prototype.saveData = function(sharedName, key, value,win, fail) {
        return cordova.exec(
                function (args) { if(win !== undefined) { win(args); } },
                function (args) { if(fail !== undefined) { fail(args); } },
                "SharedPrefs", "saveData", [sharedName,key,value]);
    };
//    if(!window.plugins) {
//        window.plugins = {};
//    }
//
//    if (!window.plugins.SharedPrefs) {
//        window.plugins.SharedPrefs = new SharedPrefs();
//    }

 SharedPrefs.prototype.saveAsSharedPrefs = function(json,win, fail) {
        return cordova.exec(win,fail,"SharedPrefs", "saveAsSharedPrefs", [json]);
    };

module.exports = new SharedPrefs();

});
