/*
 * Google Analytics v4 plugin for phonegap
 * Ver: 1.0
 * 
 * Copyright 2014 RhythmicWorks Software LLP
 *   
 * Licensed under the Apache License, Version 2.0 (the "License");   
 * you may not use this file except in compliance with the License.   
 * You may obtain a copy of the License at       
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0   
 *
 * Unless required by applicable law or agreed to in writing, software   
 * distributed under the License is distributed on an "AS IS" BASIS,   
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   
 * See the License for the specific language governing permissions and   
 * limitations under the License.
 */

cordova.define("com.rhythmicworks.phonegap.plugin.analytics.UniversalAnalyticsPlugin",function(require, exports, module) {

			function UniversalAnalyticsPlugin() {
			}

			UniversalAnalyticsPlugin.prototype.startTrackerWithId = function(
					id, success, error) {
				cordova.exec(success, error, 'UniversalAnalyticsPlugin',
						'startTrackerWithId', [ id ]);
			};
			
			UniversalAnalyticsPlugin.prototype.trackView = function(screen,
					success, error) {
				cordova.exec(success, error, 'UniversalAnalyticsPlugin', 'trackView',
						[ screen ]);
			};

			UniversalAnalyticsPlugin.prototype.trackView = function(screen,
					success, error) {
				cordova.exec(success, error, 'UniversalAnalyticsPlugin', 'trackView',
						[ screen ]);
			};

			UniversalAnalyticsPlugin.prototype.trackEvent = function(category,action, label, value, nonInteraction, success, error) {
				if (typeof label === 'undefined' || label === null) {
					label = '';
				}
				if (typeof value === 'undefined' || value === null) {
					value = 0;
				}

				if (typeof nonInteraction === 'undefined'
						|| nonInteraction === null) {
					nonInteraction = false;
				}

				cordova.exec(success, error, 'UniversalAnalyticsPlugin',
						'trackEvent', [ category, action, label, value,
								nonInteraction ]);
			};
			
			
			
			UniversalAnalyticsPlugin.prototype.disableAnalytics = function(success, error) {
				cordova.exec(success, error, 'UniversalAnalyticsPlugin', 'disableAnalytics',
				[]);
			};

			module.exports = new UniversalAnalyticsPlugin();

});
