//LocalStorage key/values on this page
//1. window.localStorage.getItem("preferredActivityTypes")
//2. window.localStorage.setItem("enableGoogleFit", window.enableGoogleFit);
//3. window.localStorage.getItem("currentActivityType");

//= false in onGetSavedValues() by default
//var gFit_includeRest = false;


var googleFitPageTAG = "googleFitPage";
var mainPageTAG = "mainPage";

var googleFitConnectedStatus = false;
var gFit_startTime;
var gFit_EndTime;
var gFit_idOfActivity ="UNKNOWN!";

//TODO Activity type that is currently running (reset on workout end/done)
//TODO Also persist currentActivityType onStop() and get it back in checkIfServiceIsRunning() if(resumeWorkout on activity kill....)

window.defaultActivityType = 'other'; //Note: this is the id in JSON, not the name!
var currentActivityType = defaultActivityType;

var activityTypesDefault = null; //Set it in setStrings() based on l10n
/*[
    {
         "name":"Aerobics", //get it from strings.properties
         "id":"9",
         "checked":"true"
    },
    {
        "name":"Spinning",
        "id":"17",
        "checked":"true"
    }
];
*/

//Returns an array with preferredActivityTypes Ids
function getPreferredActivityTypes(){

    var TAG = arguments.callee.name + "(): ";
    var preferredActivityTypes = window.localStorage.getItem("preferredActivityTypes");
    log(TAG + "preferredActivityTypes are:  " + preferredActivityTypes);


    if(preferredActivityTypes== null){
            preferredActivityTypes = []; //empty array
            for(i=0;i<activityTypesDefaultJSON.length;i++){
                if(activityTypesDefaultJSON[i].checked == true)
                    preferredActivityTypes.push(activityTypesDefaultJSON[i].id);
            }
    }
    else{
        //Already saved preferredActivityTypes
        preferredActivityTypes = preferredActivityTypes.split(",");
    }
    if(loggingON)
        console.log(TAG + "return preferredActivityTypes(Array) are:" + preferredActivityTypes);
        
    return preferredActivityTypes;
}


function callBuildFitnessClient(){
    var TAG = arguments.callee.name +'():';
    
    log(TAG + " Calling native connectToFitnessClient...");

    if(!devicereadyStatus){
        log(TAG + "connectToFitnessClient.."); 
        return;    
     }
    window.connectToFitnessClient(function(json){
        onGoogleFitConnected(json);
    },function(msg){
        //Error CB
         log(TAG + msg);
         log(TAG + "Disabling google fit prefs...");
         onGoogleFitDisconnected();
        if(gaPlugin!=null)
          gaPlugin.trackEvent('Google Fit', 'Auth cancelled');
    });
}


function onGoogleFitDisconnected(){
    $('#gFitCB').prop('checked', false);
    window.enableGoogleFit = false;
    disablePreferredActivityDiv(true);
    window.localStorage.setItem("enableGoogleFit", window.enableGoogleFit);
    saveAllLocalStorageItemsAsSharedPrefs();
}



function onGoogleFitConnected(json){
            var TAG = arguments.callee.name +'():';
            log(TAG);
            log("---------------------------------------------------");
            log("Message: " + json.message);
            log("Height: " + json.height);
            log("Weight: " + json.weight);
            log("---------------------------------------------------");

            $('#gFitCB').prop('checked', true);


//            Save the weight and height
            if(json.weight != -1){
                personalDetailsLocal.weight = json.weight;
            }

            if(json.height != -1){
                personalDetailsLocal.height = json.height;
            }
            savePersonalDetails();
}



function showPreferredActivityTypes(){
     var TAG = arguments.callee.name +'()';
     log(TAG);

     //Get the activityTypes
     var preferredActivityTypes  = getPreferredActivityTypes().toString(); //Convert array to string
     var title = '';//window.selectPreferredActivityTypesTitleText;
     var positiveButton = window.saveText;
     var negativeButton = window.cancelText;

     if(devicereadyStatus){
         window.showPreferredActivityList(title,preferredActivityTypes,activityTypesDefaultJSON,positiveButton,negativeButton,
         function(msg){
            //successCB - preferredActivityTypes returned from Java

            //Save the activity type
             window.localStorage.setItem("preferredActivityTypes", msg);
            log(TAG + "Saved preferredActivityTypes: " + msg);
            saveAllLocalStorageItemsAsSharedPrefs();
         },
         function(){
            //errorCB
         });
      }
}


function disablePreferredActivityDiv(disable){
if(disable){
//                $('#gFitPreferredActivityDiv').css('opacity','.35');
//                $('#gFitPreferredActivityDiv').off('tap',showPreferredActivityTypes);

                $('#gFitDeleteAllDataDiv').css('opacity','.35');
                $('#gFitDeleteAllDataDiv').off('tap',gFit_deleteAppFitnessActivityData);


//                $('#gFitIncludeRestLi').css('opacity','.35');
//                $('#gFitIncludeRestCB').prop("disabled", true);
   }
   else{

//                $('#gFitPreferredActivityDiv').css('opacity','1');
//                $('#gFitPreferredActivityDiv').off('tap').on('tap',showPreferredActivityTypes);

                 $('#gFitDeleteAllDataDiv').css('opacity','1');
                 $('#gFitDeleteAllDataDiv').off('tap').on('tap',gFit_deleteAppFitnessActivityData);

//                 $('#gFitIncludeRestLi').css('opacity','1');
//                 $('#gFitIncludeRestCB').prop("disabled", false);


   }
}

//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
$('#googleFitPage').on('pageinit', function() {
    if (devicereadyStatus) {

    }
    log(googleFitPageTAG + "-pageinit");

});

$('#googleFitPage').on('pagebeforeshow', function() {

    log(googleFitPageTAG + "-pagebeforeshow");

    if (gaPlugin != null)
        gaPlugin.trackView('Google Fit Preferences');

    //Google Fit checkbox
    $('#gFitCB').prop('checked', window.enableGoogleFit);

//    //gFit_Include Rest CB
    $('#gFitIncludeRestCB').prop('checked', window.gFit_includeRest);

    if(enableGoogleFit){
          disablePreferredActivityDiv(false);
    }
    else{
           disablePreferredActivityDiv(true);
    }
});

$('#googleFitPage').on('pagehide', function() {
    log(googleFitPageTAG + "-pagehide");
    if (gaPlugin != null)
    		gaPlugin.trackView('Preferences-1');
});


//Google Fit Toggle
$('#gFitCB').on('change', function() {

    //Check for LITE version
    if (LITE) {
        $('#gFitCB').prop('checked', false);
        return;
    }

    if ($('#gFitCB').is(':checked')) {
         log("Enable Google Fit..");
         $('#gFitCB').prop('checked', false);


                     var title = connectGoogleFitText;
                     var message = connectGoogleFitDetailsText;
                     var connect = connectText;
                     var cancel = cancelText ;


                    window.showConnectGoogleFitScreen(function(){
                            // success - connect clicked
                            log("success - connect clicked");
                             window.connectToFitnessClient(function(json){
                                                                         log(json);
                                                                         $('#gFitCB').prop('checked', true);
                                                                          window.enableGoogleFit = true;
                                                                          disablePreferredActivityDiv(false)
                                                                         window.localStorage.setItem("enableGoogleFit", window.enableGoogleFit);
                                                                         saveAllLocalStorageItemsAsSharedPrefs();

                                                                         //Enable the currentActivityButton
                                                                         $("#activityTypeButton").css("display","block");
                                                                          //Enable the currentActivityIcons on presets page
                                                                          $(".pActivityTypeIcon").css("display","block");

                                                                         //Set the current activity type on app gFit_startTime
                                                                         setCurrentActivityType(getCurrentActivityType());

                                                                         if(gaPlugin!=null)
                                                                          gaPlugin.trackEvent('Google Fit', 'enable Google Fit');

                                                                         onGoogleFitConnected(json);
                                                                   },
                                                                   function(msg){
                                                                                 log(msg); //User cancelled action..
                                                                                 log("Disabling google fit prefs...");
                                                                                 onGoogleFitDisconnected();
                                                                                 if(gaPlugin!=null)
                                                                                   gaPlugin.trackEvent('Google Fit', 'Auth cancelled');
                                                                   });
                    },
                    function(){
                            // error - Cancel clicked
                            log("Cancel clicked");
                    });

//                     window.showConfirmDialog(title,message,connect,cancel,function(){
//                                            window.connectToFitnessClient(function(json){
//                                             log(json);
//                                             $('#gFitCB').prop('checked', true);
//                                              window.enableGoogleFit = true;
//                                              disablePreferredActivityDiv(false)
//                                             window.localStorage.setItem("enableGoogleFit", window.enableGoogleFit);
//                                             saveAllLocalStorageItemsAsSharedPrefs();
//
//                                             //Enable the currentActivityButton
//                                             $("#activityTypeButton").css("display","block");
//                                              //Enable the currentActivityIcons on presets page
//                                              $(".pActivityTypeIcon").css("display","block");
//
//                                             //Set the current activity type on app gFit_startTime
//                                             setCurrentActivityType(getCurrentActivityType());
//
//                                             if(gaPlugin!=null)
//                                              gaPlugin.trackEvent('Google Fit', 'enable Google Fit');
//
//                                             onGoogleFitConnected(json);
//                                       },
//                                       function(msg){
//                                                     log(msg); //User cancelled action..
//                                                     log("Disabling google fit prefs...");
//                                                     onGoogleFitDisconnected();
//                                                     if(gaPlugin!=null)
//                                                       gaPlugin.trackEvent('Google Fit', 'Auth cancelled');
//                                       });
//
//                     });


    } else {
            $('#gFitCB').prop('checked', true);
            // the checkbox was unchecked
            //alert("Disable Google Fit..");

            var title = disconnectGoogleFitText;
            var message = disconnectGoogleFitDetailsText;
            var cancel = cancelText;
            var ok = okText;

             window.showConfirmDialog(title,message,ok,cancel,function(){
                            window.disableGoogleFit(function(msg){
                                     log(msg);
                                     onGoogleFitDisconnected();
                                     if(gaPlugin!=null)
                                               gaPlugin.trackEvent('Google Fit', 'disable Google Fit');
                                 });
             });
    }
});




// $("#gFitDeleteAllDataDiv").on('touchstart',function(){
    // $("#gFitDeleteAllDataDiv").css("background-size","58px 58px");
// 
// });
// 
// $("#gFitDeleteAllDataDiv").on('touchend touchcancel',function(){
    // $("#gFitDeleteAllDataDiv").css("background-size","40px 40px");
// });



$("#activityTypeButton").on('tap',function(e){
    if(tempDisableGFit_tapholdFired){
        tempDisableGFit_tapholdFired = false;
        return;
    }
    log("Tap!!!");
    log("TODO: " + "prompt selectCurrentActivityType");
    window.showSetCurrentActivityTypeDialog(selectCurrentActivityTitleText,getPreferredActivityTypes().toString(),activityTypesDefaultJSON,
    function(currActivity){
        log("currentActivity = " + currActivity);
        setCurrentActivityType(currActivity);
    });
});

var tempDisableGFit = false;
var tempDisableGFit_tapholdFired = false;
$("#activityTypeButton").on('taphold',function(e){
    log("Taphold!!!");
    tempDisableGFit_tapholdFired = true;
    e.preventDefault();
    e.stopImmediatePropagation();
    e.stopPropagation();

    if(currentActivityType!="unknown"){
            vibrate(tvHapticFeedBack);
            setCurrentActivityType("unknown");
    }
});


$("#activityTypeButton").on('touchstart',function(){
//    $("#activityTypeButton").css("background-size","29px 29px");
    $("#activityTypeButton").addClass("bg29x29");
    
});

$("#activityTypeButton").on('touchend touchcancel touchmove',function(){
    
//    $("#activityTypeButton").css("background-size","24px 42px");
 $("#activityTypeButton").removeClass("bg29x29");
});



//gFit Include Rest toggle Toggle
//$('#gFitIncludeRestCB').on('change', function() {
//    if ($('#gFitIncludeRestCB').is(':checked')) {
//       window.gFit_includeRest = true;
//       if(gaPlugin!=null)gaPlugin.trackEvent('Google Fit', 'include Rest time');
//       saveValues();
//    } else {
//       window.gFit_includeRest = false;
//       if(gaPlugin!=null)gaPlugin.trackEvent('Google Fit', 'exclude Rest time');
//       saveValues();
//    }
//});

//---

//--------------------------------------------------------------
//Relative Picker
//--------------------------------------------------------------
window.currentRelativeIntensity = "medium";
$("#relativeIntensityPicker").on('touchstart', function() {
                                 //Fade the fadeDiv
                                 log("touchstart");
                                 $("#relativeIntensityImage").addClass("bg29x29");

                                 //Make currentActivity as selectedItem
                                 $("#select-list-intensity").val(currentRelativeIntensity);
                                 log("touchstart: " + "Modified list");
                                 });

$("#relativeIntensityPicker").on('touchend touchcancel touchmove',function(){
 $("#relativeIntensityImage").removeClass("bg29x29");
});

$("#select-list-intensity").change(function() {
                                   var newIntensity = $(this).val();
                                   log("New relative intensity is: " + newIntensity);
                                   //alert(newActType);
                                   setCurrentRelativeIntensity(newIntensity);
                                   });

//--------------------------------------------------------------
//--------------------------------------------------------------
//--------------------------------------------------------------
//--------------------------------------------------------------
//--------------------------------------------------------------

//--------------------------------------------------------------
//--------------------------------------------------------------
//-------------------Include Rest Div Event listeners------------
//--------------------------------------------------------------
//--------------------------------------------------------------
$("#includeRestDiv").on('touchstart', function() {
                        //Fade the fadeDiv
                        log("touchstart");
                        $("#includeRestImage").addClass("bg60x60");
                        });


$("#includeRestDiv").on('touchend touchcancel touchmove', function() {
                        $("#includeRestImage").removeClass("bg60x60");
                        });

$("#includeRestDiv").on('tap', function() {
                        toggleIncludeRest();
                        });

//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------

function toggleIncludeRest(){
    if(window.includeRest == 0){
        setIncludeRest(1);
    }else{
        setIncludeRest(0);
    }

    vibrateTick();
}

function setIncludeRest(status){
    var TAG = arguments.callee.name + "(): ";

    log(TAG + "TODO: set include rest");

    if(status==0){
        window.includeRest = 0;
        saveValues();
        var icon = "includeRest0" + ".png";
        var src = "icons/includeRest/";
        var path = "url(" + src + icon + ")";
        $("#includeRestImage").css("background-image", path);

        //Update the work/rest labels (Check for L10N strings)
        if(typeof wLabel != 'undefined'){
            $('#wlabel').html("<img style=\"height: 100%; vertical-align: baseline\"/>" + wLabel);
            $('#restlabel').html("<img style=\"height: 100%; vertical-align: baseline\"/>" + restLabel);
        }
    }
    else if(status==1){
        window.includeRest = 1;
        saveValues();
        var icon = "includeRest1" + ".png";
        var src = "icons/includeRest/";
        var path = "url(" + src + icon + ")";
        $("#includeRestImage").css("background-image", path);

        //Update the work/rest labels
        if(typeof wLabel != 'undefined'){
            $('#wlabel').html("<img style=\"height: 100%; vertical-align: baseline\"/>" + highIntensityLabel);
            $('#restlabel').html("<img style=\"height: 100%; vertical-align: baseline\"/>" + lowIntensityLabel);
        }
    }

    //Set include rest temp var
    window.includeRest_Temp = window.includeRest;
}

//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------

function setCurrentActivityType(actId){

//    if(!window.enableGoogleFit){
//            return;
//    }


    var TAG = arguments.callee.name + "():";
    window.currentActivityType = actId;

    //set the icon
    var currentActivityTypeReplaceDots = currentActivityType.replace(".","_");
    var icon = "ic_" + currentActivityTypeReplaceDots.toLowerCase() + ".png";
    // if(testingMode != "chrome"){
        // var src = "file:///android_res/drawable/";
    // }
    // else{
        var src = "icons/fitness/";
    // }

    var path = "url(" + src + icon +")";
//    alert(path);

   $("#activityTypeButton").css("background-image",path);

//         --------------------------------------------------------------------------------
//         Save the currActivity
//         window.localStorage.setItem("currentActivityType",currentActivityType);
         saveValues();
         log(TAG + "currentActivityType: " + '"' + currentActivityType +'"' + " saved!!!!");
         saveAllLocalStorageItemsAsSharedPrefs();
//         --------------------------------------------------------------------------------

//    Check for other and unknown currentActivivity
    if(currentActivityType =="unknown" || currentActivityType =="other" || currentActivityType == "HIIT" || currentActivityType == "Interval_Training"){
//        Hide the intensity
        showIntensityAndCalories(false);
    }else{
        showIntensityAndCalories(true);
    }
}


function getCurrentActivityType(){
         //--------------------------------------------------------------------------------
         var currentActivityType  = window.localStorage.getItem("currentActivityType");
         log("getCurrentActivityType(): " + currentActivityType);
         if(currentActivityType  == null){
            currentActivityType  = window.defaultActivityType;
            return currentActivityType;
         }
         //--------------------------------------------------------------------------------
         //Checking...

            if(getPreferredActivityTypes().toString().indexOf(currentActivityType) != -1){
              log("getCurrentActivityType (): " + "currentActivityType  is: " + currentActivityType  + " and it is enabled in preferredActivityTypes...");
              return currentActivityType ;
             }

         log("getLastSavedPresetActivity(): " + "currentActivityType  is: " + currentActivityType  + " but it is DISABLED in preferredActivityTypes...");

         return defaultActivityType;
}












function gFit_insertActivityData(doneWorkoutDetails){

    var TAG = arguments.callee.name + "():";

    log("TAG");
    window.insertFitnessActivityData(doneWorkoutDetails,function(msg){
        log(TAG + msg);
        if(loggingON)toast(msg,"short");
    },

    function(msg){
        log(TAG + msg);
    });

}



function gFit_deleteAppFitnessActivityData(){

    var TAG = arguments.callee.name + "():";
    log(TAG);

     var title = deleteAppFitnessDataText + "?";
     var message = deleteAppFitnessDataDetailsText;

      window.showConfirmDialog(title,message,okText,cancelText,function(){
                                  window.getGoogleFitClientStatus(function(msg){
                                           log(TAG + msg);
                                           window.deleteAppFitnessActivityData(function(msg){
                                                   log(TAG + msg);
                                                   toast(deletedAppFitnessData,"short");

                                                    if(gaPlugin!=null)
                                                              gaPlugin.trackEvent('Google Fit', 'deleted Google Fit app data');
                                               },

                                               function(msg){
                                                   log(TAG + msg);
                                               });
                                        },
                                        function(err){
                                             log(TAG + err);
                                             toast("Try again later","short");

                                              if(gaPlugin!=null)
                                                         gaPlugin.trackEvent('Google Fit', 'delete Google Fit data Error');
                                        });
     });

}


//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
function setCurrentRelativeIntensity(intensity) {
    var TAG = arguments.callee.name + "():";
    window.currentRelativeIntensity = intensity;
    //set the icon
    var icon = intensity + ".png";
    var src = "icons/intensity/";

    var path = "url(" + src + icon + ")";
    $("#relativeIntensityImage").css("background-image", path);
    //--------------------------------------------------------------------------------
    //Save the currentRelativeIntensity
    //window.localStorage.setItem("currentRelativeIntensity", intensity);
    saveValues();
    log(TAG + "currentRelativeIntensity: " + '"' + currentRelativeIntensity + '"' + " saved!!!!");
    saveAllLocalStorageItemsAsSharedPrefs();
    //--------------------------------------------------------------------------------

    //Set intensity temp variable
    window.intensity_Temp = window.currentRelativeIntensity;
}




//Show/hide calorie inputs
function showIntensityAndCalories(show){
    if(show){
        $("#relativeIntensityWrapper").css("visibility", "visible");
        $("#activeCaloriesEstimateDiv").css("visibility", "visible");

    }else{
        $("#relativeIntensityWrapper").css("visibility", "hidden");
        $("#activeCaloriesEstimateDiv").css("visibility", "hidden");
    }
}



function refreshRelativeIntensitySelector(){
    var TAG = arguments.callee.name + "(): ";
    log(TAG);
    $('#select-list-intensity').find('option').remove().end();
    $('#select-list-intensity').append($("<option></option>").attr("value", "low").text(lowIntensity));
    $('#select-list-intensity').append($("<option></option>").attr("value", "medium").text(mediumIntensity));
    $('#select-list-intensity').append($("<option></option>").attr("value", "high").text(highIntensity));
    // $('#select-list-intensity').append($("<option></option>").attr("value", "veryHigh").text(veryHighIntensity));
    //$('#select-list-intensity').append($("<option></option>").attr("value", "value").text(text));

    //Set the value
    setCurrentRelativeIntensity(window.currentRelativeIntensity);
}