var activeCaloriesDetailsPageTAG = "activeCaloriesDetailsPage";

//Local storage variabl
//Note this: personalDetailsLocal is always overwritten using data from HealthKit (if available)
var personalDetailsLocalDefault = {
    "weight" : "-1",
    "height" : "-1",
    "dob" : "-1",
    "age" : "-1",
    "sex" : "Male"
};
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
$('.infoHeaderImage').on('touchstart', function(e) {
                         e.target.style.backgroundSize = "15px 15px";
                         });
$('.infoHeaderImage').on('touchend touchcancel touchmove', function(e) {
                         e.target.style.backgroundSize = "20px 20px";
                         });

$('#activeCaloriesInfo').on('tap', function(e) {
                            var options =  'location=no,toolbarposition=top';
                            //open external help page
                            var ref = window.open('https://www.rhythmicworks.com/products/icounttimer/help/how-active-calories-are-calculated.html', '_blank',options);
                            });

//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
$('#activeCaloriesDetailsPage').on('pageshow', function() {
                                   log(activeCaloriesDetailsPageTAG + "-pageshow");
                                   log("Setting height of activeCaloriesPage to wHeight...(Fix for keyboard resize issue)");
                                   document.getElementById('activeCaloriesDetailsPage').style.height = window.wHeight * 1 + "px";

                                   });


$('#activeCaloriesDetailsPage').on('pageinit', function() {
                                   if (devicereadyStatus) {
                                   
                                   }
                                   log(activeCaloriesDetailsPageTAG + "-pageinit");
                                   });

$('#activeCaloriesDetailsPage').on('pagebeforeshow', function() {
                                   var TAG = activeCaloriesDetailsPageTAG;
                                   
                                   //Male/Female L10N
                                   $("#maleSexId").html(maleText);
                                   $("#femaleSexId").html(femaleText);
                                  
                                   //Set width of dobId
                                   $("#dobId").css("width",(wWidth*.35) + "px");
                                   
                                   log(TAG + "-pagebeforeshow");
                                   //l10n strings
                                   $("#personalDetailsInfoText").html(personalDetailsInfoText);                          
                                    if (window.metricInputEnabled) {
                                        $("#pdWeightLabel").html(pdWeight);
                                        $("#pdHeightLabel").html(pdHeight);
                                    } else {
                                        $("#pdWeightLabel").html(pdWeightLbs);
                                        $("#pdHeightLabel").html(pdHeightFeets);
                                    }               
                                   $("#pdDOBLabel").html(pdDOB);
                                   $("#pdSexLabel").html(pdSex);
                                   
                                   if (gaPlugin != null)
                                   gaPlugin.trackView('Estimate Calories Page');
                                   
                                   //Populate data
                                   populatePersonalDetailsData();
                                   
                                   //Enable estimate calories                         
                                    if (window.enableActiveCalories) {
                                        log(TAG + " Active Calories is enabled..");
                                        if (validatePersonalDetails()) {
                                            log(TAG + " Setting active calories toggle to ON..");
                                            $('#activeCaloriesCB').prop('checked', true);
                                        }
                                    } else {
                                        log(TAG + " activeCalories not enabled!");
                                        $('#activeCaloriesCB').prop('checked', false);
                                    }

                                   });

$('#activeCaloriesDetailsPage').on('pagehide', function() {
                                   log(activeCaloriesDetailsPageTAG + "-pagehide");
                                   if (gaPlugin != null)
                                   gaPlugin.trackView('Preferences-1');
                                   
                                   //Set active calories status in prefs if changed
                                   setActiveCaloriesStatusInPrefs();
                                   });
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//Estimate Calories Toggle
// Binding the checkboxes
$('#activeCaloriesCB').on('change', function() {
                          var TAG = "activeCaloriesCB onchange: ";
                          
                            if(LITE){
                                $('#activeCaloriesCB').prop('checked', false);
                                //Alert that pro version is needed
                                log(TAG + "TODO: " + "Alert that pro version is needed");
                                return;
                            }  

                        if ($('#activeCaloriesCB').is(':checked')) {
                          log(TAG + "the checkbox was checked");
                          //Disable the checkbox and validate personal details
                          $('#activeCaloriesCB').prop('checked', false);
                          
                                  if (validatePersonalDetails()) {//Check if personal details are available and valid
                                      window.enableActiveCalories = true;
                                      $('#activeCaloriesCB').prop('checked', true);
                                  } else {
                                      window.enableActiveCalories = false;
                                      log(TAG + "Personal details are not valid...so cannot enable active calories");
                                      var title = invalidPersonalDetailsText;
                                      var msg = invalidPersonalDetailsMsg;
                                      if (devicereadyStatus) {

                                            toast(title, "short");
//                                          window.plugins.workout.showInfoAlert(title, msg, okText, function(msg) {
//                                                                               log("Success: " + msg);
//                                                                               }, function(err) {
//                                                                               log("Error:" + err);
//                                                                               });
                                      }
                                      else{
                                          alert(msg);
                                      }
                                      setActiveCaloriesDisplayState(false);
                                  }
                          } else {
                              // the checkbox was unchecked
                              window.enableActiveCalories = false;
                              setActiveCaloriesDisplayState(false);
                          }
                          saveValues();
                          
                          //--------------------------------------------------------------------------------------------------------
                          //Since activeCalories affect presetsView and updateNativeDb reloads presets view (indirect update)
                          //saveValues();
                          updateNativeDB();
                          //--------------------------------------------------------------------------------------------------------
                        });
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//Binding events to input controls
//1. Weight input
    //Real time update on input
    $("#weightId").on("input", function() {
        var newWt = $(this).val();
        if (newWt <= 0 || newWt > 999) {
            log("TODO...weight is <= 0");
            $(this).val(null);
            setWeightValInput(0);
        } else {
              setWeightValInput(newWt);
              newWt =  getWeightInKg(newWt);
              personalDetailsLocal.weight =  newWt;
              log("New weight value is: " + personalDetailsLocal.weight);
        }
    });

    //--------------------------------------
    //2. Height input
    $("#heightId").on("input", function() {
        var newHt = $(this).val();
        if (newHt <= 0 || newHt > 999) {
            log("TODO...Height cannot be 0");
            $(this).val(null);
            setHeightValInput(0);
        } else {
            setHeightValInput(newHt);
            newHt = getHeightInCm(newHt);
            personalDetailsLocal.height = newHt;
            log("New height value is: " + personalDetailsLocal.height);
        }
    });

    //--------------------------------------
    //3. DOB input
    $("#dobId").on("change", function() {
        var TAG = "DOB onchange: ";
        var newDateString = $(this).val();
        log(TAG + "New date is " + newDateString);

        if (newDateString == "") {
            log(TAG + "Invalid date so return...");
            return;
        }

        //Conver date to UTC fomat
        var localDate = new Date(newDateString);
        log(TAG + "localDate is " + localDate);

        //Get UTC date
        var tzDifference = localDate.getTimezoneOffset();
        //offset is negative eg for GMT + 5:30 its -330
        var utcDate = new Date(localDate.getTime() + tzDifference * 60 * 1000);
        log(TAG + "utcDate is " + utcDate);

        personalDetailsLocal.dob = utcDate;

        //Compute age
        personalDetailsLocal.age = getAge(utcDate);
        //got as string from getAge(..)

        savePersonalDetails();
    }); 

var monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];

$("#dobId").on("input", function() {
                var newDOB = $(this).val();

                var TAG = "DOB input: ";
                log(TAG + "New date is " + newDOB);

                 if(newDOB == ""){
                                 log(TAG + "Invalid date so return...");
                                 return;
                 }

               setDOBVal(newDOB);
         });

//4. Sex select list
$("#select-list-sex").change(function() {
                             personalDetailsLocal.sex = $(this).val();
                             log("New sex value is: " + personalDetailsLocal.sex);
                             savePersonalDetails();
                             });

$("#select-list-sex").on("input", function() {
                         var newSex = $(this).val();
                         setSexVal(newSex);
                         });

//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//---------------------------------------Functions--------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
function setWeightVal(val) {
    log("***" + val);
    if(window.metricInputEnabled){
        $("#pdWeightVal").html(val);
    }else{
        var pounds = Math.round(parseFloat(val) * 2.20462);
        $("#pdWeightVal").html(pounds); 
    }
}

function setHeightVal(val) {
    if(window.metricInputEnabled){
        $("#pdHeightVal").html(val);
    }else{
        val = parseInt(val);
        var inches = (val*0.393700787).toFixed(0);
        var feet = Math.floor(inches / 12);
        inches %= 12;
        var feetInches = feet + "' " + inches + '"';
        $("#pdHeightVal").html(feetInches);
    }
}

function setWeightValInput(val) {
     $("#pdWeightVal").html(val);
}

function setHeightValInput(val) {
    if(window.metricInputEnabled){
         $("#pdHeightVal").html(val);
    }
    else{
        var height = val;
        log("Input height numbers: " + height);
        var digits = (""+height).split("");
        var feetInches = digits[0] + "' "+ digits[1] + digits[2] + '"';
        var feet = parseInt(digits[0]);
        log("****** d0 = " + digits[0]);
        log("****** d1 = " + digits[1]);
        log("****** d2 = " + digits[2]);
        var in1 = typeof digits[1] == 'undefined' ? 0 :  digits[1];
        log(in1);
        var in2 = typeof digits[2] == 'undefined' ? "" :  digits[2];
        var inches;
        if(in2 == ""){
            inches = in1;
        }else{
            inches = parseInt(in1 + "" + in2);
        }
        log("inches = " + inches);
        if(inches > 11){
                var i = inches % 12;
                var f = Math.floor(inches/12);
                feet = feet + f;
                inches = i;
        }
        
        var s = feet + "' " + inches + "\"";
        log("FeetInches string:" + s);
        $("#pdHeightVal").html(s);
    }
}



function setDOBVal(val) {
    var d = new Date(val);
    var month = monthNames[d.getMonth()];
    var year = d.getFullYear();
    var date = d.getDate();
//    $("#pdDOBVal").html(month + " " + date + ", " + year);
    $("#pdDOBVal").html(month + ", " + year);
}

function setSexVal(val) {
    if(val == "Male"){
        $("#pdSexVal").html(maleText);
    }else if(val=="Female"){
        $("#pdSexVal").html(femaleText);
    }
}

//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//Validate Personal Details
//Check if personal details are available and valid
function validatePersonalDetails() {
    var TAG = arguments.callee.name + "(): ";
    log(TAG + "Validating personal details....");
    //return false;
    var valid = true;
    
    if (personalDetailsLocal.weight == -1) {
        log(TAG + "Invalid Weight");
        valid = false;
    }
    if (personalDetailsLocal.height == -1) {
        log(TAG + "Invalid Height");
        valid = false;
    }
    if (personalDetailsLocal.dob == -1) {
        log(TAG + "Invalid DOB");
        valid = false;
    }
    if (personalDetailsLocal.sex == -1) {
        log(TAG + "Invalid Sex");
        valid = false;
    }
    
    if (valid) {
        log(TAG + "Personal details are valid!");
         //Show computed BMR
         showComputedBMR();
    }else{
         log(TAG + "Invalid personal details!");
         $("#computedBMRValue").html("-- Cal/day*");
    }
    
    return valid;
}

//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
var personalDetailsLocal = personalDetailsLocalDefault;

function updatePersonalDetailsUI(personalDetailsLocal) {
    
    var TAG = arguments.callee.name + "(): ";
    log(TAG);
    
    if (personalDetailsLocal.weight != -1) {
        var wt = Math.round(personalDetailsLocal.weight * 100) / 100;
        $("#weightId").val(wt);
        setWeightVal(wt);
    } else {
        $("#weightId").val(0);
        setWeightVal(0);
    }
    
    if (personalDetailsLocal.height != -1) {
        var ht = Math.round(personalDetailsLocal.height * 100) / 100;
        $("#heightId").val(ht);
        setHeightVal(ht);
    } else {
        $("#heightId").val(0);
        setHeightVal(0);
    }
    
    if (personalDetailsLocal.dob != -1 && personalDetailsLocal.dob != undefined) {
        //$("#dobId").val();
        var s = personalDetailsLocal.dob;
        var a = s.split(/[^0-9]/);
        //Gets date in local timezone format
        var targetTime = new Date(a[0], a[1] - 1, a[2], a[3], a[4], a[5], a[6]);
        var tzDifference = targetTime.getTimezoneOffset();
        //offset is negative eg for GMT + 5:30 its -330
        var localDate = new Date(targetTime.getTime() - tzDifference * 60 * 1000);
        //alert(localDate);
        
        var day = localDate.getDate();
        var month = localDate.getMonth() + 1;
        var year = localDate.getFullYear();
        
        if (month < 10) {
            month = "0" + month;
        }
        if (day < 10) {
            day = "0" + day;
        }
        
        var dval = year + "-" + month + "-" + day;
        log(TAG + "Birth date is: " + dval);
        $('#dobId').val(dval);
        $('#dobId').attr("value", dval);
        setDOBVal(dval);
    } else {
        var dval = "1990" + "-" + "01" + "-" + "01";
        $("#dobId").val(null);
        $("#pdDOBVal").html("---");
    }
    
    if (personalDetailsLocal.sex != -1) {
        $("#select-list-sex").val(personalDetailsLocal.sex);
        setSexVal(personalDetailsLocal.sex);
    } else {
        $("#select-list-sex").val(null);
        setSexVal("---");
    }
    
    
    validatePersonalDetails();    
}

function populatePersonalDetailsData() {
    
    var TAG = arguments.callee.name + "(): ";
    
    // log(TAG + "Calorie count feature not being implemented right now....so return...");
    // return;
    log(TAG + "Getting personal details data...");
    if (window.enableGoogleFit) {

//        alert(TAG + "TODO: Get data from Fit..returning..");return;


        log(TAG + "Getting personal details data from HealthKit...");
        if (!devicereadyStatus) {
            log(TAG + "(**Native Code**) Read the personal details data...");
            updatePersonalDetailsUI(personalDetailsLocal);
            return;
        }


        window.connectToFitnessClient(function(json){

                                                    var weight =  json.weight;
                                                    var height = json.height;

                                                    log("*-------------Data from Google Fit-----------------*");
                                                    log("Weight: " + weight);
                                                    log("Height: " + height);
//                                                    log("DOB   : " + dob);
//                                                    log("Age   : " + age);
//                                                    log("Sex   : " + sex);
                                                    log("*-------------------------------------*");

                                                    log("Validating the data from Google Fit...");
                                                    if (weight != -1) {
                                                        personalDetailsLocal.weight = weight;
                                                         // //Disable input field
                                                        // disableInput("#weightId", true);
                                                    }else{
                                                        disableInput("#weightId", false);
                                                    }

                                                    if (height != -1) {
                                                        //Note: We get height in m, save it as cm (V. Important)
                                                        var ht = height * 100;
                                                        personalDetailsLocal.height = ht.toString(); //also store it as string
                                                        // //Disable input field
                                                        // disableInput("#heightId", true);
                                                    }else{
                                                        disableInput("#heightId", false);
                                                    }

//                                                    if (dob != -1) {
//                                                         personalDetailsLocal.dob = dob;
//                                                         personalDetailsLocal.age = getAge(dob);
//                                                         //Disable input field
//                                                        disableInput("#dobId", true);
//                                                    }else{
//                                                        disableInput("#dobId", false);
//                                                    }
//
//                                                    if (age != -1) {
//                                                    personalDetailsLocal.age = age; //got as string from HealthKit plugin
//                                                    }
//
//                                                    if (sex != -1) {
//                                                    personalDetailsLocal.sex = sex;
//                                                    //Disable input field
//                                                    disableInput("#select-list-sex", true);
//                                                    }else{
//                                                    disableInput("#select-list-sex", false);
//                                                    }
//
                                                    //Save the personalDetailsLocal
                                                    log(TAG + "Saving the personal details as personalDetailsLocal");
                                                    log("*-------------------------------------*");
                                                    savePersonalDetails();
                                                    log(personalDetailsLocal);
                                                    log("Weight: " + personalDetailsLocal.weight);
                                                    log("Height: " + personalDetailsLocal.height);
                                                    log("DOB   : " + personalDetailsLocal.dob);
                                                    log("Age   : " + personalDetailsLocal.age);
                                                    log("Sex   : " + personalDetailsLocal.sex);
                                                    log("*-------------------------------------*");

                                                    updatePersonalDetailsUI(personalDetailsLocal);

        });

    } else {
        //If HealthKit is not enabled
        log(TAG + "Reading personal details data from localStorage (if available)...");
        
        //Enable all input fields
        disableInput("#weightId", false);
        disableInput("#heightId", false);
        disableInput("#dobId", false);
        disableInput("#select-list-sex", false);
        
        //Read PersonalDetails from local storage
        window.personalDetailsLocal = window.localStorage.getItem("personalDetailsLocal");
        window.personalDetailsLocal = window.personalDetailsLocal == null ? personalDetailsLocalDefault : JSON.parse(window.personalDetailsLocal);
        
        log(personalDetailsLocal);
        log("*-------------------------------------*");
        log("Weight: " + personalDetailsLocal.weight);
        log("Height: " + personalDetailsLocal.height);
        log("DOB   : " + personalDetailsLocal.dob);
        log("Age   : " + personalDetailsLocal.age);
        log("Sex   : " + personalDetailsLocal.sex);
        log("*-------------------------------------*");
        updatePersonalDetailsUI(personalDetailsLocal);
    }
}

function savePersonalDetails() {
    var TAG = arguments.callee.name + "(): ";
    log(TAG);
    log(personalDetailsLocal);
    window.localStorage.setItem("personalDetailsLocal", JSON.stringify(personalDetailsLocal));
    //Update presets UI on Watch
    if(enableActiveCalories){
        saveValues();
        updateNativeDB();
    }
    
    //Calculate BMR if valid personal details
    validatePersonalDetails();
}

function setActiveCaloriesStatusInPrefs() {
    var TAG = arguments.callee.name + "(): ";
    log(TAG);
    
    if (enableActiveCalories) {
        $("#activeCaloriesStatus").html(onToggleLabel);
    } else {
        $("#activeCaloriesStatus").html(offToggleLabel);
    }
}

//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//Returns estimated calories from workout details
//workout - JSON containing workout data, like preset JSON
function getEstimatedCalories(workout) {
    var TAG = arguments.callee.name + "(): ";
    if (!devicereadyStatus) {
        log(TAG + "TODO: get estimated calories from native code");
        return;
    }
    
    if (!enableActiveCalories) {
        log(TAG + "Calorie Estimate is disabled in Prefrerences...Do nothing");
        return;
    }



//    Get calorie estimate
//    window.plugins.workout.getEstimatedCalories(workout, personalDetailsLocal, function(data) {
//                                                log(TAG + "*** Estimated calories = " + data + " kcal");
//                                                $("#activeCaloriesEstimateValueSpan").html(data + " " + "Cal");
//                                                }, function(err) {
//                                                log(TAG + "Error: " + err);
//                                           });

    window.getEstimatedCaloriesPlugin(workout, personalDetailsLocal, function(data) {
                                                                log(TAG + "*** Estimated calories = " + data + " kcal");
                                                                $("#activeCaloriesEstimateValueSpan").html(data + " " + "Cal");
                                                            }, function(err) {
                                                                log(TAG + "Error: " + err);
                                                            });
}

//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
function setActiveCaloriesDisplayState(enableActiveCalories) {
    var TAG = arguments.callee.name + "(): ";
    
    if (enableActiveCalories) {
        log(TAG + "Active Calories Display: ON");
        //Show relative intensity
        $("#relativeIntensityWrapper").css("display", "block");
        $("#activeCaloriesEstimateDiv").css("display", "block");
    } else {
        log(TAG + "Active Calories Display: OFF");
        //Set relatiuve intensity to default
        //Hide relative intensity
        $("#relativeIntensityWrapper").css("display", "none");
        $("#activeCaloriesEstimateDiv").css("display", "none");
    }
}

function getAge(dateString) {
    var today = new Date();
    var birthDate = new Date(dateString);
    var age = today.getFullYear() - birthDate.getFullYear();
    var m = today.getMonth() - birthDate.getMonth();
    if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
        age--;
    }
    return age.toString();
}

function calculate_age(birth_month, birth_day, birth_year) {
    today_date = new Date();
    today_year = today_date.getFullYear();
    today_month = today_date.getMonth();
    today_day = today_date.getDate();
    age = today_year - birth_year;
    
    if (today_month < (birth_month - 1)) {
        age--;
    }
    if (((birth_month - 1) == today_month) && (today_day < birth_day)) {
        age--;
    }
    return age;
}

function disableInput(id, status) {
    
    switch(id) {
            
        case '#weightId':
            $(id).prop('disabled', status);
            if(status){
                $("#pdWeightVal").addClass("inputDisabled");
            }else{
                $("#pdWeightVal").removeClass("inputDisabled");
            }
            
            break;
            
        case '#heightId':
            $(id).prop('disabled', status);
            if(status){
                $("#pdHeightVal").addClass("inputDisabled");
            }else{
                $("#pdHeightVal").removeClass("inputDisabled");
            }
            break;
            
        case '#dobId':
            $(id).prop('disabled', status);
            if(status){
                $("#pdDOBVal").addClass("inputDisabled");
            }else{
                $("#pdDOBVal").removeClass("inputDisabled");
            }
            break;
            
        case '#select-list-sex':
            $(id).prop('disabled', status);
            if(status){
                $("#pdSexVal").addClass("inputDisabled");
            }else{
                $("#pdSexVal").removeClass("inputDisabled");
            }
            break;
    }
}

//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//Weight
function clearInput6() {
    setWeightValInput(0);
    $("#weightId").val(null);
    
    keypadInput = true;
    $("#weightId").addClass("inputNumber1Px");
}

//on blur
function f6() {
    if (personalDetailsLocal.weight != -1) {
        setWeightVal(personalDetailsLocal.weight);
        savePersonalDetails();
        writePersonalDetailsToGoogleFit();
    }
    keypadInput = false;
    $("#weightId").removeClass("inputNumber1Px");
}

// Height
function clearInput7() {
    setHeightValInput(0);
    $("#heightId").val(null);
    
    keypadInput = true;
    $("#heightId").addClass("inputNumber1Px");
}

//on blur
function f7() {
    if (personalDetailsLocal.height != -1) {
        setHeightVal(personalDetailsLocal.height);
        savePersonalDetails();
        writePersonalDetailsToGoogleFit();
    }
    keypadInput = false;
    $("#heightId").removeClass("inputNumber1Px");
}

//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
function showComputedBMR(){
    var TAG = arguments.callee.name + "(): ";
    log(TAG);
    if(devicereadyStatus){
        window.getBMRPlugin(personalDetailsLocal,function(bmr){
           var bmrString = bmr + " Cal/day*";
           log(TAG + bmrString); 
           $("#computedBMRValue").html(bmrString);
        });
    }
}


function writePersonalDetailsToGoogleFit(){
    var TAG = arguments.callee.name + "(): ";
    log(TAG);
    if(validatePersonalDetails()){
           if (window.enableGoogleFit) {
              log(TAG + "Writing data(weight/height/bmr) to Google Fit..");
              if(devicereadyStatus){
                  window.writePersonalDetailsToGoogleFitPlugin(personalDetailsLocal,function(){
                      log(TAG + "writePersonalDetailsToGoogleFit success");
                  },
                  function(){
                       log(TAG + "writePersonalDetailsToGoogleFit error");
                  });
              }
         }
    }
}

//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
$("#toggleMetricInput").on("tap",function(){
        toggleMetricInput();
});

function toggleMetricInput(){
    var TAG = arguments.callee.name + "(): ";
    log(TAG);
    window.metricInputEnabled = !window.metricInputEnabled;
    if (window.metricInputEnabled) {
        $("#pdWeightLabel").html(pdWeight);
        $("#pdHeightLabel").html(pdHeight);
    } else {
        $("#pdWeightLabel").html(pdWeightLbs);
        $("#pdHeightLabel").html(pdHeightFeets);
    }    
    updatePersonalDetailsUI(personalDetailsLocal);
    window.localStorage.setItem("metricInputEnabled", window.metricInputEnabled);
}
   
   
function getWeightInKg(weight){
    if (window.metricInputEnabled) {
        return weight;
    }else{
        //Convert Pounds in Kg
        log("Pounds = " + weight);
        var kgs = weight/2.20462;
        log("Kgs = " + kgs);
        
        return kgs;
    }
}   

function getHeightInCm(height){
    if (window.metricInputEnabled) {
        return height;
    }else{
        //Convert Height in cm
        log("Input height numbers: " + height);
        var digits = (""+height).split("");
        var feetInches = digits[0] + "' "+ digits[1] + digits[2] + '"';
        var feet = parseInt(digits[0]);
        var in1 = typeof digits[1] == 'undefined' ? 0 :  digits[1];
        var in2 = typeof digits[2] == 'undefined' ? "" :  digits[2];
        var inches;
        if(in2 == ""){
            inches = in1;
        }else{
            inches = parseInt(in1 + in2);
        }
        
        var hInCm = (feet * 12 * 2.54) + (inches * 2.54);
        
        log("Height in Feet & Inches is: " + feet + "' " +  in1 + in2 + '"');
        log("Height in cm: " + hInCm);
        return hInCm;
    }
}   
