//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------
function showPresets() {
    // Disable display counter
    $("#counterB").removeClass('buttonOn');
    $("#counterB").addClass('buttonOff');
    // Disable display timer
    $("#timerB").removeClass('buttonOn');
    $("#timerB").addClass('buttonOff');

    // Enable display presets
    $("#presetsB").addClass('buttonOn');
    $("#presetsB").removeClass('buttonOff');

    // Hide the main wrapper and show presets div
    $('#wrapperMain').css('display', 'none');
    $('#wrapperPresets').css('display', 'block');

    // Save counterMode value
    window.showPresetsView = true;
    saveValues();

    loadPresets();
    if (!( typeof gaPlugin === null)) {
        // gaPlugin is undefined --> true ... null --> false
        $.when(gaStartedDeferred).done(function() {
            gaPlugin.trackView('Presets');
        });
    }
}

// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------

// process the promp dialog results
var p = 1;
function onSaveButtonClick(pname, ptype) {
    log("onSaveButtonClick()");
    if (testingMode == 'chrome') {
        // alert("You selected button number " + results.buttonIndex + " and
        // entered " + results.input1);
        savePreset(pname + ' ' + p++, ptype);
    }
}

// Show a custom prompt dialog
//
function showSavePrompt() {

    var TAG = arguments.callee.name + "(): ";

    var title;
    var presetName = '';
    var activityType = '';
    var positiveButton = window.saveText;
    var negativeButton = window.cancelText;
    if (counterMode == 1) {
        title = window.enterCounterName;
    } else {
        title = window.enterTimerName;
    }

    if (window.editMode) {
        presetName = editModePreset.name;

        //save edit preset
        log(TAG + "save edit preset");

        window.showSavePresetDialog(title, presetName, positiveButton, negativeButton, function(new_name) {

            var id = editModePreset.id;
            //First delete the preset...then insert as new preset
              if (!window.db) {
                    log("window.db is undefined");
                    return;
              }
            db.transaction(function(tx) {
                tx.executeSql("DELETE FROM presets WHERE ID=?", [id], function() {
                    log(TAG + 'Deleted row with id: ' + id);

                    //Insert new preset
                    savePreset(new_name, window.currentActivityType);
                }, errorCB);
            }, errorCB, function() {
                // Refresh the data
                log(TAG + 'Tx complete');
                loadPresets();
            });

        });
    } else {

        //save new preset
        log(TAG + "save new preset");
        window.showSavePresetDialog(title, presetName, positiveButton, negativeButton, function(new_name) {
            savePreset(new_name, window.currentActivityType);
        });
    }
}

// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
function errorCB(tx, err) {
    if (window.loggingON)
        console.log("Error processing SQL: " + err.message);
}

function savePreset(name, activityType) {

    var TAG = arguments.callee.name + "(): ";

    if (loggingON && devicereadyStatus){
        toast(TAG + "name = " + name + " " + "activityType = " + activityType, "short");
    }
    
    //log(TAG + "name:" + name + " " + "activityType:" + activityType);
    // Maximum preset limit
    if (window.totalPresets >= window.maxPresetLimit  && !editMode) {
        
         if(LITE){
             showGoProMaxPresetLimit();
             return;
          }
        
        
        alert(maxPresetLimitReached + "(" + maxPresetLimit + ")");
        return;
    }

    if (counterMode == 1) {
        var preset = {
            'name' : name,
            'type' : 'counter',
            'counts' : window.countValue,
            'interval' : window.intervalTime,
            'work' : -1,
            'rest' : window.restTime,
            'rounds' : window.noOfRounds,
            'activityType' : activityType,
            'intensity' : window.currentRelativeIntensity,
            'includeRest' : 0
        };

    } else {
        var preset = {
            'name' : name,
            'type' : 'timer',
            'counts' : -1,
            'interval' : -1,
            'work' : window.workTime,
            'rest' : window.restTimeTimer,
            'rounds' : window.noOfRoundsTimer,
            'activityType' : activityType,
            'intensity' : window.currentRelativeIntensity,
            'includeRest' : window.includeRest
        };
    }

    // Save to DB
   if (!window.db) {
           log("window.db is undefined");
           return;
   }

    db.transaction(function(tx) {
        tx.executeSql("INSERT INTO presets(name,type,counts,interval,work,rest,rounds,activityType,intensity,includeRest)  VALUES (?,?,?,?,?,?,?,?,?,?)", [preset.name, preset.type, preset.counts, preset.interval, preset.work, preset.rest, preset.rounds, preset.activityType, preset.intensity, preset.includeRest], function() {
            log(TAG + 'Inserted');

            setCurrentActivityType(getCurrentActivityType());

            log("Remembered lastSavedPresetActivityTypeId: " + activityType);

            if (devicereadyStatus) {
                var savedPresetMessage = window.savedPresetMessage;
                toast(savedPresetMessage, "short");

                editMode = false;
                //Change label icon to save icon
                $("#saveButton").css("background-image", "url(icons/label.png)");
            }

             //Save changes to native db
             updateNativeDB();


        }, function(tx, e) {
            log(TAG + 'Inser stmt error:' + e.message);
        });

//       Load the totalNumberOfPresetsCount
        loadTotalPresetsCount();
    });

    // for GA
    if (gaPlugin != null)
        gaPlugin.trackEvent('Save Preset', 'save ' + preset.type);
}



function loadTotalPresetsCount(){
    var TAG = arguments.callee.name + "(): ";
    log(TAG);
      if (!window.db) {
           log("window.db is undefined");
           return;
      }
    db.transaction(function(tx) {
//                 Get total no of presets
                tx.executeSql("SELECT * FROM presets", [], function(tx, results) {
                        window.totalPresets = results.rows.length;
                        log(TAG + 'Total presets: ' + totalPresets);
                }, errorCB);
    });
}

// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
window.deletePresetConfirm = false;
//-----------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
function confirmDeletePreset(preset, event) {

     //Prevent click on edit preset
        event.preventDefault();
        event.stopPropagation();
        event.stopImmediatePropagation();

    // Strings
    var message;
    if (preset.name != '') {
        message = window.deleteText + " " + preset.name + "?";
    } else {
        message = window.deleteText + " " + window.presetText + "?";
    }

    var cancel = window.cancelText;
    var ok = window.lowDeviceVolOK;
    var title = '';

    window.deleteLi = $(event.target).parent();
    window.deleteLiId = preset.id;

    // TODO
    if (devicereadyStatus) {
        // $(event.target).parent().remove();
        // $('#presetsList').listview('refresh');
        // deletePresetWithId(preset.id);

        window.showConfirmDialog(title, message, ok, cancel, function() {
            deleteLi.remove();
            $('#presetsList').listview('refresh');
            deletePresetWithId(deleteLiId);

        });

    } else {
        $(event.target).parent().remove();
        deletePresetWithId(preset.id);
    }

}

// Delete preset based on id
function deletePresetWithId(id) {
    var TAG = arguments.callee.name + "(): ";

     if (!window.db) {
          log("window.db is undefined");
          return;
     }

    db.transaction(function(tx) {
        tx.executeSql("DELETE FROM presets WHERE ID=?", [id], function() {
            log(TAG + 'Deleted row with id: ' + id);

             //Update the nativeDB
             updateNativeDB();

            // for GA
            if (gaPlugin != null)
                gaPlugin.trackEvent('Preset', 'delete preset');

        }, errorCB);
    }, errorCB, function() {
        // Refresh the data
        log(TAG + 'Tx complete');
        loadPresets();
    });
}

// --------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------
function getTotalTime(preset) {
    if (preset.type == 'counter') {
        // Calculate the total time for counter
        var wtime = preset.counts * preset.rounds * preset.interval;

        if (window.enableLastRest)
            var rtime = (preset.rounds) * preset.rest;
        else
            var rtime = (preset.rounds - 1) * preset.rest;

        var tTime = wtime + rtime;
        return tTime;

    } else {
        // Calculate the total time for timer
        var wtime = (preset.work * preset.rounds);
        if (window.enableLastRest)
            var rtime = (preset.rounds) * preset.rest;
        else
            var rtime = (preset.rounds - 1) * preset.rest;
        var tTime = wtime + rtime;
        return tTime;
    }
}

// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
window.totalPresets = -1;
function createDB() {

    var TAG = arguments.callee.name + "(): ";

//    Open the db
       if (localStorage.getItem("dbCreated2") != "true") {
           dbCreated2 = false;
       } else {
           dbCreated2 = true;
       }

//    Open the database
    log(TAG + "Opening the database...");
    try{
        window.db = window.sqlitePlugin.openDatabase({
        name: 'my.db',
        location: 'default',
        androidDatabaseProvider: 'system'
    })

        log(TAG + "Successfully opened database..")
    } catch (dbError) {
        console.error("Error opening database: html5sql.openDatabase - ", dbError);
        return; // Exit early on error
    }

    if (!dbCreated2) {
//    Database not yet created
            log("*** Creating v2 database....***");

            var sqlFileName = 'v2presets.sql';
            if(LITE){
                sqlFileName = 'v2presets_lite.sql';
            }

            // Create Tables and Populate the DB
            log(TAG + "Creating Table and Populating the DB...");

            // Run the sql statements
            $.get(sqlFileName, function(sqlStatements) {

                console.log(sqlStatements);

                // Run the SQL statements
                // Clean up comments if needed
                let cleaned = sqlStatements
                  .replace(/\/\*[\s\S]*?\*\//g, '')   // remove /* ... */ comments
                  .replace(/--.*$/gm, '');            // remove -- comments

                  // Split into statements
                  const stmts = cleaned.split(/;\s*$/m)
                    .map(s => s.trim())
                    .filter(Boolean);

                db.transaction(function (tx) {
                      stmts.forEach(stmt => {
                        tx.executeSql(stmt);
                      });
                    }, function (err) {
                      console.error('SQL error', err);
                    }, function () {
                      console.log('Presets.sql applied ✅');
                });



                 //Log the data created for verification
                db.transaction(function(tx) {
                    // Query
                    var query = "Select * from PRESETS";
                    tx.executeSql(query, [], function(tx, results) {
                        window.totalPresets = results.rows.length;
                        log(TAG + 'Total presets = ' + totalPresets);
                    }, errorCB);

                    //Update native DB
                    updateNativeDB();

                });
            });

            log(TAG + "DONE");
            localStorage.setItem("dbCreated2", true);

        }
        else{
            log(TAG + "DB already created!")
        }
}

// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// -----------------------------------------------------------------
// -----------------------------------------------------------------
// -----------------------------------------------------------------
window.intensity_Temp = 0;
window.includeRest_Temp = 0;
function startPreset(preset,event) {
    var TAG = arguments.callee.name + "(): ";

    //Prevent click on edit preset
    if(event!=null){
        event.preventDefault();
        event.stopPropagation();
        event.stopImmediatePropagation();
    }
  

    //set the currentActivityType
    window.currentActivityType = preset.activityType;

    // for GA
    if (gaPlugin != null)
        gaPlugin.trackEvent('Start Workout', 'start preset', preset.type);

    // Check the type of object and set counterMode based on it
    if (preset.type == 'counter') {
        // window.counterMode = 1;
        // window.countValue= preset.counts;
        // window.intervalTime= preset.interval;
        // window.noOfRounds= preset.rounds;
        // window.restTime= preset.rest;

        // Set dummy variables
        window.counterModeDummy = 1;
        window.countValueDummy = preset.counts;
        window.intervalTimeDummy = preset.interval;
        window.noOfRoundsDummy = preset.rounds;
        window.restTimeDummy = preset.rest;

        setPreferences();
    } else {
        window.counterModeDummy = 0;
        window.workTimeDummy = preset.work;
        window.noOfRoundsTimerDummy = preset.rounds;
        window.restTimeTimerDummy = preset.rest;

        setPreferences();
    }

//    ------------------------------------
//        ------------------------------------
//        Set the intensity and includeRest (Dummy's)
//        This prevents originals from getting overriden when preset is started. So when setMode(..) is called,
//        the counter/timer state is preserved
        window.intensity_Temp = preset.intensity;
        window.includeRest_Temp = preset.includeRest;
//        ------------------------------------
//        ------------------------------------


    // Before starting the workout
    window.warmupON = true;
    window.currDisplayState = 'none';

    // Start the workout
    goToCountPage();

}

// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------
window.editMode = false;
var editModePreset;
function editPreset(preset, event) {

    //Prevent the second click on slider..if touch area contains slider on timer/counter page
    if(event!=null){
        event.preventDefault();
    }
        
    var TAG = arguments.callee.name + "(): ";

    window.editMode = true;
    window.editModePreset = preset;

    //Change label icon to save icon
    $("#saveButton").css("background-image", "url(icons/ic_action_edit.png)");

    log(TAG + "Edit Mode Enabled!");

    if (gaPlugin != null)
        gaPlugin.trackEvent('Preset', 'edit preset');

    var editPresetId = preset.id;
    if (preset.type == 'timer') {
        log(TAG + "Edit timer preset...");
        //Show the timer screen
        noOfRoundsTimer = preset.rounds;
        restTimeTimer = preset.rest;
        workTime = preset.work;
//         includeRest (only for Timer)
        window.includeRest = preset.includeRest;
        setMode(0);

    } else {
        log(TAG + "Edit counter preset...");
//        Show the counter screen
        countValue = preset.counts;
        intervalTime = preset.interval;
        noOfRounds = preset.rounds;
        restTime = preset.rest;
        setMode(1);
    }

//    Set the currentActivityType from preset
    setCurrentActivityType(preset.activityType);

//    Set the preset intensity
     setCurrentRelativeIntensity(preset.intensity);

    // for GA
    if (gaPlugin != null)
        gaPlugin.trackEvent('Preset', 'edit preset');
}

function getActivityTypeId(activityTypeName) {
    var TAG = arguments.callee.name + "(): ";
    var activityTypes = getActivityTypes();
    for ( i = 0; i < activityTypes.length; i++) {
        if (activityTypes[i].name == activityTypeName) {
            var id = activityTypes[i].id;
            log(TAG + "activityTypeId is: " + id);
            return id;
        }
    }
    if (loggingON)
        log("****activityTypeName not found: " + activityTypeName);
    return fa_other;
}

function getActivityTypeName(activityTypeId) {
    var TAG = arguments.callee.name + "(): ";

    var activityTypes = getActivityTypes();
    for ( i = 0; i < activityTypes.length; i++) {

        if (activityTypes[i].id == activityTypeId) {
            var name = activityTypes[i].name;
            log(TAG + "activityTypeId is: " + name);
            return name;
        }
    }
    if (loggingON)
        log("****activityTypeId Not found: " + activityTypeId);
    return window.defaultActivityType;
}

//----------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------
var loadPresetsByActivityType = true;
function loadPresets() {

//    setTimeout(function() {
//        $("#mainPage").removeClass("forcedGPU");
//    }, 0);

    var presetLiId = 0;
    var TAG = arguments.callee.name + "(): ";

   if (!window.db) {
         log("window.db is undefined");
         return;
   }

    // Hid no poresets div
    $('#noPresetsMsgBox').css('display', 'none');

    // Get the quote
    db.transaction(function(tx) {

        // Query
        var query;
        if (loadPresetsByActivityType) {
            //query = "Select * from PRESETS order by activityType, lower(name)";
            query = "Select * from PRESETS";
        } else {
            query = "Select * from PRESETS order by lower(name)";
        }

        // Set the styles
        var wStyle = "style='color:" + window.workColor + ";opacity:.5'";
        var rStyle = "style='color:" + window.restColor + ";opacity:.5'";
        var roundStyle = "style='color:" + window.roundColor + ";opacity:.45'";

        tx.executeSql(query, [], function(tx, results) {
            var len = results.rows.length;
            window.totalPresets = len;
            log(TAG + "" + len + " rows found.");

            log(results.rows);

            //Copy rows to presets Array
            var presetsWithLocalizedActivityName = [];
            for (var i = 0; i < len; i++) {
                var row = results.rows.item(i);
                var preset = {
                    'id' : row.id,
                    'name' : row.name,
                    'type' : row.type,
                    'counts' : row.counts,
                    'interval' : row.interval,
                    'work' : row.work,
                    'rest' : row.rest,
                    'rounds' : row.rounds,
                    'activityType' : row.activityType,
                    'intensity' : row.intensity,
                    'includeRest' : row.includeRest,
                    //Add localized name
                    'activityName' : getActivityTypeDisplayName(row.activityType)
                };
                presetsWithLocalizedActivityName.push(preset);
            }

            if (loadPresetsByActivityType) {
                // first by name, then activityName
                var s = firstBy(function(v1, v2) {
                    return v1.activityName < v2.activityName ? -1 : (v1.activityName > v2.activityName ? 1 : 0);
                }).thenBy(function(v1, v2) {
                    return v1.name < v2.name ? -1 : (v1.name > v2.name ? 1 : 0);
                });
                presetsWithLocalizedActivityName.sort(s);
            } else {
                //Already sorted by name via WebSQL
                //presetsWithLocalizedActivityName.sort(s);
            }

            var innerHtml = '';
            // Check for 0 rows
            if (len == 0) {
                $('#noPresetsMsgBox').css('display', 'block');
            } else {
                $('#noPresetsMsgBox').css('display', 'none');
            }

            var prevActivityType = "";
            var length = presetsWithLocalizedActivityName.length;
            for (var i = 0; i < length; i++) {
                var preset = presetsWithLocalizedActivityName[i];
                log("Row = " + i + " ID = " + preset.id + " Name =  " + preset.name + " Type =  " + preset.type + " ActivityName = " + preset.activityName + " ActivityType = " + preset.activityType);

                var tTime = getTotalTime(preset);

                // Get the pLiDetails string

                var includeRestIcon = "";
                if (preset.type == 'counter') {
                    // var pLiWork = preset.counts + "/"
                    // +
                    // preset.interval.toString().toHHMMSS();
                    // var pLiWork = "<span style =
                    // 'font-weight:normal'>" +
                    // preset.counts + "</span>/" +
                    // preset.interval +"s";
                    var pLiWork = "<span style = 'font-weight:normal'>" + preset.counts + "</span>/" + "<span style='font-size:80%'>" + preset.interval + "s" + "</span>";
                    // var pLiWork = "<span style =
                    // 'font-weight:normal'>" +
                    // preset.counts + "</span>/<span
                    // style='font-size:80%'>" +
                    // preset.interval.toString().toHHMMSS()
                    // + '</span>';
                    var pLiRest = preset.rest.toString().toHHMMSS();
                    var pLiRounds = preset.rounds + 'x';

                    pLiDetailsStr = "<span " + wStyle + ">" + pLiWork + "</span> " + "<span " + rStyle + ">" + pLiRest + "</span> " + "<span " + roundStyle + ">" + pLiRounds + "</span> ";

                } else {
                    if (preset.includeRest == 1) {
                        includeRestIcon = "<img src='icons/includeRest/includeRest1.png' class='includeRestPresetImage'>";
                    }

                    var pLiWork = preset.work.toString().toHHMMSS();
                    var pLiRest = preset.rest.toString().toHHMMSS();
                    var pLiRounds = preset.rounds + 'x';
                    pLiDetailsStr = "<span " + wStyle + ">" + pLiWork + "</span> " + "<span " + rStyle + ">" + pLiRest + "</span> " + "<span " + roundStyle + ">" + pLiRounds + "</span> ";
                    pLiDetailsStr = pLiDetailsStr + includeRestIcon;
                }

                var stringifiedPreset = JSON.stringify(preset);
                var activityIconSpan;

                ///set the icon
                var icon = "ic_" + preset.activityType.toLowerCase().replace(".","_") + ".png";
                
                // if(testingMode != "chrome"){
                     // var src = "file:///android_res/drawable/";
                // }
                // else{
                    var src = "icons/fitness/";
                // }
                

                var path1 = "url(" + src + icon + ")";

                var id_pLi = "preset_" + (++presetLiId);
                var id_deleteB = id_pLi + "deleteB";
                var id_playIcon = id_pLi + "playIcon";
                var id_pTotalTime = id_pLi + "totalTime";

                if (loadPresetsByActivityType) {
                    activityIconSpan = "";
                    //Check for activityType
                    if (preset.activityType == prevActivityType) {
                        //do nothing
                        //since the header li is already added
                    } else {
                        //Add the header li
                        var img = "<img src='" + src + icon + "'/>";
                        innerHtml = innerHtml + "<li class='presetHeaderLi'><span>" + img + " " + getActivityTypeDisplayName(preset.activityType) + "</span></li>";
                        prevActivityType = preset.activityType;
                    }
                } else {
                    activityIconSpan = "<span style=\" background-image:" + path1 + "\"" + "class='pActivityTypeIcon' onclick=\'startPreset(" + stringifiedPreset + ");\'></span>";
                }

                innerHtml = innerHtml + "<li class='pLi' id='" + id_pLi + "'>" + "<span class='pName'>" + preset.name + "</span>" + "<span  class='deleteB' id='" + id_deleteB + "'></span>" + "<span class='playIcon' id='" + id_playIcon + "'></span>" + activityIconSpan + "<span class='pTotalTime' id='" + id_pTotalTime + "'>" + tTime.toString().toHHMMSS() + "</span>" + "<div class='pLiDetails'>" + pLiDetailsStr + "</div>" + "</li>";

                //Replace onclick with on tap script
                //onclick=\'editPreset(" + stringifiedPreset + ",event);\'>
                //onclick=\'confirmDeletePreset(" + stringifiedPreset + ",event);\'
                //onclick=\'startPreset(" + stringifiedPreset + ");\'>
                //onclick=\'startPreset(" + stringifiedPreset + ");\'>

                innerHtml = innerHtml + "<script>$('#" + id_pLi + "').on('tap',function(event){ editPreset(" + stringifiedPreset + ",event)});</script>" + "<script>$('#" + id_deleteB + "').on('tap',function(event){ confirmDeletePreset(" + stringifiedPreset + ",event)});</script>" + "<script>$('#" + id_playIcon + "').on('tap',function(event){ startPreset(" + stringifiedPreset + ",event)});</script>" + "<script>$('#" + id_pTotalTime + "').on('tap',function(event){ startPreset(" + stringifiedPreset + ",event)});</script>";

            }

            $('#presetsList').empty().append(innerHtml);
            $('#presetsList').listview('refresh');

            if (enableGoogleFit) {
                $(".pActivityTypeIcon").css("display", "block");
            }

            // Tap effect for play preset icon
            $('.playIcon').on('touchstart', function(e) {
                e.target.style.backgroundSize = "12px 12px";
                $(this).next().css('color', '#777');
                //$(this).parent().addClass('highlightLi');
            });
            $('.playIcon').on('touchend touchcancel touchmove', function(e) {
                e.target.style.backgroundSize = "14px 14px";
                $(this).next().css('color', 'rgba(255,255,255,.55)');
                // $(this).parent().removeClass('highlightLi');
            });

            $('.pTotalTime').on('touchstart', function(e) {
                $(this).css('color', '#777');
                //$(this).prev().css('backgroundSize', '12px 12px');
            });
            $('.pTotalTime').on('touchend touchcancel touchmove', function(e) {
                $(this).css('color', 'rgba(255,255,255,.55)');
                //$(this).prev().css('backgroundSize', '14px 14px');
            });

            //Highlight the pLi
            $('.pLi').on('touchstart', function(e) {
                liTouched = $(this);
                liTouchedTimeoutTimer = setTimeout(function() {
                    liTouched.addClass('highlightLi');
                }, liTouchThreshold); 

            });
            

            $('.pLi').on('tap', function(e) {
                liTouched = $(this);
                liTouched.addClass('highlightLi');
                setTimeout(function() {
                    liTouched.removeClass('highlightLi');
                }, 100);
            }); 


            $('.pLi').on('touchend touchcancel touchmove', function(e) {
                clearTimeout(liTouchedTimeoutTimer);
                $(this).removeClass('highlightLi');
            });


            // Tap effect for delete preset icon
            $('.deleteB').on('touchstart', function(e) {
                $(this).addClass('enlargeB');
            });
            $('.deleteB').on('touchend touchcancel touchmove', function(e) {
                $(this).removeClass('enlargeB');
            });

        }, errorCB);

    });

}


//------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------

function updateNativeDB() {
    var TAG = arguments.callee.name + "(): ";
    log(TAG);

//    log(TAG + "TODO for watch presets..returning for now..."); return;

    if (!devicereadyStatus) {
        return;
    }

    setTimeout(function() {
        window.updateNativeDBPlugin(function() {
            log(TAG + "Successfully updated native DB");
        }, function() {
            log(TAG + "Error updating native DB!");
        });
    }, 500);

}

//------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------

//function startPresetFromWatch(presetJSON) {
//
//    var TAG = arguments.callee.name + "(): ";
//
//    var preset = presetJSON;
//
//    //set the currentActivityType
//    window.currentActivityType = preset.activityType;
//
//    // for GA
//    if (gaPlugin != null)
//        gaPlugin.trackEvent('Start Workout', 'start preset', preset.type);
//
//    // Check the type of object and set counterMode based on it
//    if (preset.type == 'counter') {
//        // window.counterMode = 1;
//        // window.countValue= preset.counts;
//        // window.intervalTime= preset.interval;
//        // window.noOfRounds= preset.rounds;
//        // window.restTime= preset.rest;
//
//        // Set dummy variables
//        window.counterModeDummy = 1;
//        window.countValueDummy = preset.counts;
//        window.intervalTimeDummy = preset.interval;
//        window.noOfRoundsDummy = preset.rounds;
//        window.restTimeDummy = preset.rest;
//
//        setPreferences();
//    } else {
//        window.counterModeDummy = 0;
//        window.workTimeDummy = preset.work;
//        window.noOfRoundsTimerDummy = preset.rounds;
//        window.restTimeTimerDummy = preset.rest;
//
//        setPreferences();
//    }
//
//    //------------------------------------
//    //------------------------------------
//    //Set the intensity and includeRest
//    window.intensity_Temp = preset.intensity;
//    window.includeRest_Temp = preset.includeRest;
//    //------------------------------------
//    //------------------------------------
//
//    // Before starting the workout
//    window.warmupON = true;
//    window.currDisplayState = 'none';
//
//    // Start the workout
//    goToCountPage();
//
//    //Load preset details and start preset
//    return "success";
//}
//
////----------------------------------------
////----------------------------------------
////----------------------------------------
////Function to sort the presets by (localized) activityName
//function sortByActivityName(a, b) {
//    var sortStatus = 0;
//
//    if (a.activityName < b.activityName) {
//        sortStatus = -1;
//    } else if (a.activityName > b.activityName) {
//        sortStatus = 1;
//    }
//    return sortStatus;
//}

function addNewActivitiesAsPreferredActivityTypes(){
    var TAG = arguments.callee.name + "(): ";

      var preferredActivityTypes = window.localStorage.getItem("preferredActivityTypes");
      log(TAG + "preferredActivityTypes are:  " + preferredActivityTypes);

        if(preferredActivityTypes== null){
                preferredActivityTypes = []; //empty array
                for(i=0;i<activityTypesDefaultJSON.length;i++){
                    if(activityTypesDefaultJSON[i].checked == true)
                        preferredActivityTypes.push(activityTypesDefaultJSON[i].id);
                }
        }
        else{
            //Already saved preferredActivityTypes
            log(TAG + "Already saved preferredActivityTypes...so add new activities as preferred activityTypes...");
            var preferredActivityTypesArray = preferredActivityTypes.split(",");

            //add new activity activityTypes
            log(TAG + "Adding new activities to preferredActivityTypes...");
             for(i=0;i<activityTypesDefaultJSON.length;i++){
                        if(activityTypesDefaultJSON[i].checked == true){
                                    //Check for new activity (Note: new activity has capital first letter of id)
                                    var id = activityTypesDefaultJSON[i].id;
                                    if(id[0] == id[0].toUpperCase()){
                                        log(TAG + "New activity is: " + id);
                                        preferredActivityTypesArray.push(activityTypesDefaultJSON[i].id);
                                    }

                        }
             }

             //Save the preferredActivityTypes
             preferredActivityTypes = preferredActivityTypesArray.toString();
             log(TAG + "Saving preferredActivityTypes as string in localStorage..");
             window.localStorage.setItem("preferredActivityTypes", preferredActivityTypes);
              log(TAG + "Saved preferredActivityTypes: " + preferredActivityTypes);
        }
}