//window.supportedTranslations in headlAll.js
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
function localizeApp(){
    if(testingMode!="chrome")
            checkLanguage();
    else{
            //Set default strings
            window.currLanguage = window.testingLanguage;//'de_US';
            getStrings(currLanguage.toLowerCase().replace("-","_"));
            showTranslationDivs();  
    }
}
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------

function getCurrentLanguage(){
 	if(window.enableDTrans){
		return "en";
	}else if(currLanguage.toLowerCase().replace("-","_").indexOf('en')>=0){
		return "en";
	}else{
		
		for(i=0;i<supportedTranslations.length;i++){
			if(currLanguage.toLowerCase().replace("-","_").indexOf(supportedTranslations[i]) >= 0){
				return supportedTranslations[i];
			}
		} 
		return "en";
	}
}
 
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------ 
function toggleTranslation(){
	if(!window.enableDTrans){
		 window.enableDTrans = true;
		 window.localStorage.setItem("enableDTrans",window.enableDTrans);
		 getStrings('en');
		 $('#toggleTranslation').html(enableTranslationTo + " " + currLanguage);
		 
		 //Enable translation to en_US
		 if (gaPlugin != null)
				gaPlugin.trackEvent('Reset Translation', 'reset to en_US', 'currLanguage: ' + currLanguage);
	}
	else{
		 window.enableDTrans = false;
		 window.localStorage.setItem("enableDTrans",window.enableDTrans);
		 getStrings(currLanguage.toLowerCase().replace("-","_"));
		 $('#toggleTranslation').html(translateToEnglish);
	}
}
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
translationSupported = false;
function showTranslationDivs(){
    var index = -1;
    for(i=0;i<supportedTranslations.length;i++){
        index = currLanguage.toLowerCase().replace("-","_").indexOf(supportedTranslations[i].toLowerCase());
        if(index == 0){
            //Language supported
            translationSupported = true;
            break;
        }
    }
	
	
	if(translationSupported){
		document.getElementById('volunteerToTranslate').style.display="none";	
	}
	else if(currLanguage.toLowerCase().indexOf('en') >= 0){ //Default english language
		//Hide all T divs
		document.getElementById('reportTranslationError').style.display="none";
		document.getElementById('toggleTranslation').style.display="none";
		document.getElementById('volunteerToTranslate').style.display="none";
		document.getElementById('translationsLabel').style.display="none";
	}
	else{ //yet to be supported
		document.getElementById('reportTranslationError').style.display="none";
		document.getElementById('toggleTranslation').style.display="none";
	}
	

    if (showEnableDTransDiv) {
        document.getElementById('toggleTranslation').style.display="block";
        if (!window.enableDTrans) {

        } else {
            getStrings('en');
            $('#toggleTranslation').html(enableTranslationTo + " " + currLanguage);
        }
    }else{
        //Disable toggle translation feature
        document.getElementById('toggleTranslation').style.display="none";
    }
}
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
function checkLanguage() {
      //navigator.globalization.getPreferredLanguage(getLangSuccess,getLangError);
      navigator.globalization.getLocaleName(getLangSuccess,getLangError);
}

window.currLanguage = 'en';
function getLangSuccess(language){
	if(loggingON)console.log('language: ' + language.value + '\n');
	window.currLanguage = language.value;
	getStrings(currLanguage.toLowerCase().replace("-","_"));
	//Show translation divs based on currLanguage	
	showTranslationDivs();
}
function getLangError(){
	if(loggingON)console.log('Error getting language\n');
	showTranslationDivs();	
	//getStrings('fr');	
}
//------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------
// JavaScript Document
function playStartAlert(){
	if(counterMode==1){
		if(startBeepId==0 || startBeepId==1){
			var text = startBeep[startBeepId];
			if(preCount){
				if(descCount)
					text = text + "  " + window.countValue; 
				else
					text = text + "  " + "1";				
			}
			speakTTS(text);		
		}
		else
		{
			if(devicereadyStatus){	
				playMedia(beepRoundStartS);
				if(preCount){
					if(descCount)
						speakTTS(window.countValue); 
					else
						speakTTS(1);					
				}
			}
			else
				if(loggingON)console.log('Beep: ' + beepRoundStartS);
		}
		
	}
	else{//Timer mode
		
		if(startTimerBeepId==0 || startTimerBeepId==1)
				speakTTS(startBeep[startTimerBeepId]);
		else
		{
			if(devicereadyStatus){	
				playMedia(beepRoundStartS);
			}
			else
				if(loggingON)console.log('Beep: ' + beepRoundStartS);
		}

	}
	
}

//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
function playRestAlert(){
	 
	if(counterMode==1){
		if(restBeepId==0 || restBeepId==1)
			speakTTS(restBeep[restBeepId]);
		else
		{
			if(devicereadyStatus){	
				playMedia(beepRestStartS);
			}
			else
				if(loggingON)console.log('Beep: ' + beepRestStartS);
		}
		
	}
	else{
		
		if(restTimerBeepId==0 || restTimerBeepId==1)
				speakTTS(restBeep[restTimerBeepId]);
		else
		{
			if(devicereadyStatus){	
				playMedia(beepRestStartS);
			}
			else
				if(loggingON)console.log('Beep: ' + beepRestStartS);
		}

	}
}


//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
function play321Alert(s){
	if(counterMode==1){
		if(a321BeepId==0)
				speakTTS(s);
		else
		{
	
				if(loggingON)console.log('Beep: ' + beepNotifyS);
		}
		
	}
	else{
		
		if(a321TimerBeepId==0)
				speakTTS(s);
		else
		{
		
				if(loggingON)console.log('Beep: ' + beepNotifyS);
		}

	}
	
}


function playWorkoutEndAlert(){
	
	/*if(endBeepId==0 || endBeepId==1){
		speakTTS(endBeep[endtBeepId]);
	}else{*/
			
		if(devicereadyStatus)
			playMedia(beepEndOfWorkoutS);
		else
		  if(loggingON)console.log('Beep: ' + beepEndOfWorkoutS);
}


function playHalfwayAlert(){ 
    if(halfwayTimerBeepId==0 || halfwayTimerBeepId==1){
        speakTTS(halfwayBeep[halfwayTimerBeepId]);
    }else{ 
        if(devicereadyStatus)
            playMedia(beepHalfwayS);
        else
          if(loggingON)console.log('Beep: ' + beepHalfwayS);
    }
}
//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
function speakTTS(msg){
	if(devicereadyStatus){
		if(window.enableAF){
					window.getAudioFocus(
										function(){window.plugins.tts.speak(msg,ttsSpeakSuccess,ttsSpeakError);},
										function(){window.plugins.tts.speak(msg,ttsSpeakSuccess,ttsSpeakError);});
		}
		else
					window.plugins.tts.speak(msg);
	}
	else
		if(loggingON)console.log("Speak: " + msg);
}

function speakTTSNoAF(i){
	if(devicereadyStatus)
		window.plugins.tts.speak(i);
	else
		if(loggingON)console.log("Speak: " + i);
}

//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
function setWorkoutDoneState(){
	if(soundStatus==1){							
		playWorkoutEndAlert();						
	}
	
	if(vibrateStatus==1)
		vibrate(tvLong);	
	
	setDisplayState('done');
	
	if(counterMode==1){
		if(enableLastRest)
			document.getElementById('no').innerHTML="<img style=\"height:100%; vertical-align:middle\" />0:00";
		else{
			if(descCount){
				if(preCount)
					document.getElementById('no').innerHTML="<img style=\"height:100%; vertical-align:middle\" />0";
				else
					document.getElementById('no').innerHTML="<img style=\"height:100%; vertical-align:middle\" />1";
			}
			else{
				if(preCount)
					document.getElementById('no').innerHTML="<img style=\"height:100%; vertical-align:middle\" />" + countValue;
				else
					document.getElementById('no').innerHTML="<img style=\"height:100%; vertical-align:middle\" />" + countValue;
			}
		}
	}
	else{
		document.getElementById('no').innerHTML="<img style=\"height:100%; vertical-align:middle\" />0:00";
	}

	//history.back();
	setTimeout(function(){
	   $("body").pagecontainer( "change", "#mainPage", { transition: "fade", changeHash:false }); 
	   },400); 
}


//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
function onWorkoutDone(){
	if(window.noOfWorkOutsDone!=-1)
	{
									window.noOfWorkOutsDone++;
									saveValues();
									if(window.noOfWorkOutsDone==window.rateUsAfterWorkout){
										//ask for rate us
										showRateUs();
									}
									else{
										setWorkoutDoneState();										
									}
	}
	else{
								
			setWorkoutDoneState();									
	}
}

//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------

