//Rest as part of Google Fit Activity
window.gFit_includeRestAsActivity = false;
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
window.wHeight = getWindowHeight();
window.wWidth = window.innerWidth;

window.firstHt = window.wHeight;
function getWindowHeight(){
    if(LITE){
        return (window.innerHeight);
    }
    return window.innerHeight;
}


// For backbutton overriding
window.touchDisableDivON = false;
window.mainPageON = false;
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
window.dpiType = "mdpi";
if (window.devicePixelRatio <= 1.5 && window.devicePixelRatio > 1) {
    dpiType = "hdpi";
} else if (window.devicePixelRatio > 1.5) {
    dpiType = "xhdpi";
} else if (window.devicePixelRatio <= 1) {
    dpiType = "mdpi";
}

// -------------------------------------------------------------------------------------------------------
window.countStarted = false;

// playColor="rgba(255,160,33,1)";
// workColor="rgba(255,160,33,1)";
// restColor ="rgba(0,188,153,.9)";
// intervalColor =workColor; //"rgba(213,111,13,1)";
// roundColor="rgba(51,204,255,1)";
// countColor="rgba(255,175,58,1)";

// workColor="rgba(235,94,0,1)";
workColor = "rgba(255,118,38,1)";
playColor = workColor;

restColor = "rgba(47,212,124,.9)";
intervalColor = workColor;
roundColor = "rgba(51,204,255,1)";
// countColor="rgba(255,175,58,1)";
doneColor = restColor;
pauseColor = "rgba(237,28,36,.45)";

startCircleColor = "rgb(41,41,41)";
startCircleBgColor = "#101010";

tvSmall = 200;
tvMedium = 500;
tvLong = 800;
tvHapticFeedBack = 50;

// -------------------------------------------------------------------------------------------------------
// Prevent page scroll 1px up on transition
$(function() {
    $.mobile.defaultHomeScroll = 0;
});
// -------------------------------------------------------------------------------------------------------

window.media = null;

window.deviceReadyDeferred = $.Deferred();
window.jqmReadyDeferred = $.Deferred();
window.splashHidden = $.Deferred();
window.mainPageShown = $.Deferred();
window.l10nDeferred = $.Deferred();

$.when(deviceReadyDeferred, jqmReadyDeferred).done(doWhenBothFrameworksLoaded);
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
//Deferred L10N
$.when(deviceReadyDeferred, jqmReadyDeferred, l10nDeferred).done(deferredL10N);
function deferredL10N() {
    var TAG = arguments.callee.name + "(): ";
    //Load the presets once more with localized values if presets screen is on
    if (showPresetsView) {
        log(TAG + "Now show presets...");
        showPresets();
    }

    //Call setIncludeRest once more (called before from setMode(0))
    if (counterMode == 0) {
        log(TAG + "Timer Mode: Calling setIncludeRest since its timer mode...");
        setIncludeRest(window.includeRest);
    }
}

// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------


window.devicereadyStatus = false;
$('document').ready(function(e) {
    log('Document ready!');
    enableScreenShotAutomation();
//    enableScreenShotAutomation4And6();

    //alert($("#invisibleSpan").width());
    setLandscapeViewFontSize();
    
    document.addEventListener("deviceready", onDeviceReady, false);

    // Driver
    if (testingMode == 'chrome')
        setTimeout(function() {
            onDeviceReady();
        }, 1000);
});


window.statusTTS = 0;
window.TTSDataAvailable = 0;

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// FUNCTIONS------------------------FUNCTIONS--------------FUNCTIONS----------FUNCTIONS-------FUNCTIONS
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// PhoneGap is ready
function onDeviceReady() {
    var TAG = arguments.callee.name + "(): ";

    log(TAG + "Device ready!");
    if (!window.localStorageSupported) {
        getSavedValues();
    } else {

    }

    // Add other listeners
    document.addEventListener("pause", onAppPause, false);
    document.addEventListener("resume", onAppResume, false);
    document.addEventListener("online", onOnline, false);
    document.addEventListener("offline", onOffline, false);

    // Back button behaviour
    document.addEventListener("backbutton", onBackKeyDown, false);

    // Localize the app
    localizeApp();

    if (testingMode != 'chrome') {
        window.devicereadyStatus = true;
        log(TAG + 'Registering the BR...');
        window.registerBR(BRSuccessCallback, function(){
                    log(TAG + "ERROR: BroadcastReceiver NOT Registered");
        });
    }

    deviceReadyDeferred.resolve();

    //Keep the screen always On
    keepScreenOn(1);

    if (devicereadyStatus) {
        //Set up the applicationId
        window.plugins.version.getApplicationId(function(application_Id) {
            window.applicationId = application_Id;
        }, function(errorMessage) {
            // do something with errorMessage
            if (loggingOn)
                console.log(errorMessage);
        });


        //Get the Android API level
        window.plugins.version.getAndroidAPINumber(function(apiNumber) {
                    window.API_NUMBER = apiNumber;
                    if(API_NUMBER<=17){
                        //Disable Android Wear prefs since it won't work
                        log(TAG + "API level is less than 18: " + API_NUMBER);
                        $("#androidWearDiv").css("display","none");
                    }else{
                        log(TAG +"API level is: " + API_NUMBER);
                        log(TAG + "Android wear supported!");
                    }
                }, function(errorMessage) {
                    // do something with errorMessage
                    if (loggingOn)
                        console.log(errorMessage);
        });


//        isCanvasDisabled
       window.isCanvasDisabled(function(msg){
                if(msg == "true"){
                    window.disableCanvas = true;
                    log(TAG + "disableCanvas = true");
                }else{
                    window.disableCanvas = false;
                    log(TAG + "disableCanvas = false");
                }
       });
    }


//    AdMob for LITE
    if(LITE && !screenShots){
        log(TAG + "Enabling AdMob..");

        initAds();
//        display a banner at startup
        if(admob){
             admob.createBannerView();
        }
    }
}

function successHandler() {
    log('Goggle analytics initialised');
}

function errorHandler() {
    log('Goggle analytics init ERROR');
}

function onOnline() {
    log("OnLine");
    window.noInternet = false;
}

function onOffline() {
    log("Offline");
    window.noInternet = true;
}

// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
function doWhenBothFrameworksLoaded() {

    var TAG = arguments.callee.name + "(): ";

    log(TAG);

    //Load the presets once more with localized values if presets screen is on
    if (showPresetsView) {
        log(TAG + "Now show presets...");
        showPresets();
    }

    // Hide the splashscreen
    log(TAG + "Calling hide splash screen");
    window.setTimeout(function() {
        if (window.devicereadyStatus)
            navigator.splashscreen.hide();
        // splashHidden.resolve();
    }, 500);

    setPreferences();

    // Google Analytics integration
    if (devicereadyStatus) {
        if (window.enableGA) {
            log(TAG + "Enabling Google Analytics..");
            startGAPlugin();
        } else {
            log(TAG + "Google Analytics off");
            // exitGAPlugin();
        }
    } else
        log(TAG + "Google Analytics: " + window.enableGA);

    // Get the master volume
    if (devicereadyStatus) {
        setTimeout(function() {
            VolumeControl.getVolume(getVolSuccess, getVolError);
        }, 1000);
    }

    // Call create the DB for presets
    createDB();

    if (devicereadyStatus) {
        // Check if service is running
        myService = cordova.plugins.myService;
        // **********************************************
        // Resume workout if service is running already
        checkIfServiceIsRunning();
        // **********************************************
    }

    //Is Google Fit enabled
    if (window.enableGoogleFit) {
            log(TAG + 'Google Fit enabled..');
            callBuildFitnessClient();
    }


    //Save prefs as SharedPrefs
    saveAllLocalStorageItemsAsSharedPrefs();

    //Call getCalorieEstimate on App Start (since setMode gets called before deviceready in this case)
    log(TAG + "Calling getEstimateCalories(..) from doWhenBothFrameworksLoaded on App Start)");
    getCalorieEstimateDetails();
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
function saveValues() {
     var TAG = arguments.callee.name + "(): ";
     
    log(TAG + 'SAVE VALUES');
    
    if (!isNaN(window.countValue))
        window.localStorage.setItem("countValue", window.countValue);

    if (!isNaN(window.intervalTime))
        window.localStorage.setItem("intervalTime", window.intervalTime);

    if (!isNaN(window.noOfRounds))
        window.localStorage.setItem("noOfRounds", window.noOfRounds);

    if (!isNaN(window.restTime))
        window.localStorage.setItem("restTime", window.restTime);

    // ---------------------------------------------------------
    if (!isNaN(window.noOfRoundsTimer))
        window.localStorage.setItem("noOfRoundsTimer", window.noOfRoundsTimer);

    if (!isNaN(window.restTimeTimer))
        window.localStorage.setItem("restTimeTimer", window.restTimeTimer);
    // ---------------------------------------------------------

    if (!isNaN(window.counterMode))// changed
        window.localStorage.setItem("counterMode", window.counterMode);

    if (!isNaN(window.workTime))
        window.localStorage.setItem("workTime", window.workTime);

    if (!isNaN(window.startDelay))// changed
        window.localStorage.setItem("startDelay", window.startDelay);

    if (!isNaN(window.vibrateStatus))// changed
        window.localStorage.setItem("vibrateStatus", window.vibrateStatus);

    if (!isNaN(window.welcomeToneStatus))// changed
        window.localStorage.setItem("welcomeToneStatus", window.welcomeToneStatus);

    if (!isNaN(window.nextRoundAlert))// changed
        window.localStorage.setItem("nextRoundAlert", window.nextRoundAlert);

    if (!isNaN(window.halfwayTimerAlert))// changed
        window.localStorage.setItem("halfwayTimerAlert", window.halfwayTimerAlert);

    if (!isNaN(window.bgImageId))// changed
        window.localStorage.setItem("bgImageId", window.bgImageId);
    if (!isNaN(window.soundStatus))// changed
        window.localStorage.setItem("soundStatus", window.soundStatus);
    if (!isNaN(window.beep321Status))// changed
        window.localStorage.setItem("beep321Status", window.beep321Status);
    if (!isNaN(window.dontShowAgain))// changed
        window.localStorage.setItem("dontShowAgain", window.dontShowAgain);
    if (!isNaN(window.appLicensedFlag))// changed
        window.localStorage.setItem("appLicensedFlag", window.appLicensedFlag);

    if (!isNaN(window.noOfWorkOutsDone))// changed
        window.localStorage.setItem("noOfWorkOutsDone", window.noOfWorkOutsDone);

    // Set counter settings
    window.localStorage.setItem("preCount", window.preCount);
    window.localStorage.setItem("descCount", window.descCount);
    window.localStorage.setItem("autoCount", window.autoCount);

    // Set beep settings
    if (!isNaN(window.startBeepId))// changed
        window.localStorage.setItem("startBeepId", window.startBeepId);
    if (!isNaN(window.restBeepId))// changed
        window.localStorage.setItem("restBeepId", window.restBeepId);
    if (!isNaN(window.a321BeepId))// changed
        window.localStorage.setItem("a321BeepId", window.a321BeepId);
    // Timer beeps
    if (!isNaN(window.startTimerBeepId))// changed
        window.localStorage.setItem("startTimerBeepId", window.startTimerBeepId);
    if (!isNaN(window.halfwayTimerBeepId))// changed
        window.localStorage.setItem("halfwayTimerBeepId", window.halfwayTimerBeepId);
    if (!isNaN(window.restTimerBeepId))// changed
        window.localStorage.setItem("restTimerBeepId", window.restTimerBeepId);
    if (!isNaN(window.a321TimerBeepId))// changed
        window.localStorage.setItem("a321TimerBeepId", window.a321TimerBeepId);

    if (!isNaN(window.endBeepId))// changed
        window.localStorage.setItem("endBeepId", window.endBeepId);
    if (!isNaN(window.countBeepId))// changed
        window.localStorage.setItem("countBeepId", window.countBeepId);

    // Set volume setting
    if (!isNaN(window.beepAppVolume))// changed
        window.localStorage.setItem("beepAppVolume", window.beepAppVolume);

    // Audio focus
    window.localStorage.setItem("enableAF", window.enableAF);
    // Last rest interval
    window.localStorage.setItem("enableLastRest", window.enableLastRest);

    window.localStorage.setItem("enableGA", window.enableGA);

    // Master vol help to be shown once
    window.localStorage.setItem("masterVolVeryLowHelpShown", window.masterVolVeryLowHelpShown);

    // Save the showPresetsView flag
    window.localStorage.setItem("showPresetsView", window.showPresetsView);

    //Google Fit
    window.localStorage.setItem("enableGoogleFit", window.enableGoogleFit);

    window.localStorage.setItem("gFit_includeRest", window.gFit_includeRest);
    
    //Android Wear
    window.localStorage.setItem("enableAndroidWear", window.enableAndroidWear);
    window.localStorage.setItem("vibrateAndroidWear", window.vibrateAndroidWear);
     window.localStorage.setItem("androidWearKeepScreenON", window.androidWearKeepScreenON);

//     Relative Intensity
        window.localStorage.setItem("currentRelativeIntensity", window.currentRelativeIntensity);

        log("************" + currentActivityType);
//        Save Current Activity Type
        window.localStorage.setItem("currentActivityType", currentActivityType);

//        PersonalDetails
//        window.localStorage.setItem("personalDetailsLocal", window.personalDetailsLocal);
//
//        Include Rest Option
        window.localStorage.setItem("includeRest", window.includeRest);

//   Active Calories
    window.localStorage.setItem("enableActiveCalories", window.enableActiveCalories);
    
    
    //Metric input
    window.localStorage.setItem("metricInputEnabled", window.metricInputEnabled);

    if(devicereadyStatus){
        saveAllLocalStorageItemsAsSharedPrefs();
        }
     else{
        if(loggingON)log(TAG + "Device not ready...not calling saveAllLocalStorageItemsAsSharedPrefs()");
      }

    //Get calorie estimate on saveValues() if enabled
    getCalorieEstimateDetails();
}
function getCalorieEstimateDetails(){
    if(enableActiveCalories && !showPresetsView) {
        if (counterMode == 1) {
            //Get estimated calories
            setActiveCaloriesDisplayState(true);
            currentWorkout = {
                'name' : name,
                'type' : 'counter',
                'counts' : window.countValue,
                'interval' : window.intervalTime,
                'work' : -1,
                'rest' : window.restTime,
                'rounds' : window.noOfRounds,
                'activityType' : window.currentActivityType,
                'intensity' : window.currentRelativeIntensity,
                'includeRest' : window.includeRest,
                //Also pass enableLastRest
                'enableLastRest' : window.enableLastRest
            };
            getEstimatedCalories(currentWorkout);
        } else {

            setActiveCaloriesDisplayState(true);
            currentWorkout = {
                'name' : name,
                'type' : 'timer',
                'counts' : -1,
                'interval' : -1,
                'work' : window.workTime,
                'rest' : window.restTimeTimer,
                'rounds' : window.noOfRoundsTimer,
                'activityType' : window.currentActivityType,
                'intensity' : window.currentRelativeIntensity,
                'includeRest' : window.includeRest,
                //Also pass enableLastRest
                'enableLastRest' : window.enableLastRest
            };
            getEstimatedCalories(currentWorkout);
        }
    }
}
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
function getSavedValues() {

    var TAG = arguments.callee.name + "(): ";
    log(TAG + "Getting saved values...else default");

    var t = null;

    // Get values
    window.countValue = window.localStorage.getItem("countValue");
    t = parseInt(countValue, 10);
    window.countValue = isNaN(t) ? 15 : t;

    window.intervalTime = window.localStorage.getItem("intervalTime");
    t = parseInt(intervalTime, 10);
    window.intervalTime = isNaN(t) ? 2 : t;

    window.noOfRounds = window.localStorage.getItem("noOfRounds");
    t = parseInt(noOfRounds, 10);
    window.noOfRounds = isNaN(t) ? 3 : t;

    window.restTime = window.localStorage.getItem("restTime");
    t = parseInt(restTime, 10);
    window.restTime = isNaN(t) ? 30 : t;

    // ----------------------------------------------------------------
    window.noOfRoundsTimer = window.localStorage.getItem("noOfRoundsTimer");
    t = parseInt(noOfRoundsTimer, 10);
    window.noOfRoundsTimer = isNaN(t) ? 5 : t;

    window.restTimeTimer = window.localStorage.getItem("restTimeTimer");
    t = parseInt(restTimeTimer, 10);
    window.restTimeTimer = isNaN(t) ? 15 : t;
    // ----------------------------------------------------------------

    window.counterMode = window.localStorage.getItem("counterMode");
    t = parseInt(counterMode, 10);
    window.counterMode = isNaN(t) ? 1 : t;

    window.workTime = window.localStorage.getItem("workTime");
    t = parseInt(workTime, 10);
    window.workTime = isNaN(t) ? 45 : t;

    window.startDelay = window.localStorage.getItem("startDelay");
    t = parseInt(startDelay, 10);
    window.startDelay = isNaN(t) ? 10 : t;

    window.vibrateStatus = window.localStorage.getItem("vibrateStatus");
    t = parseInt(vibrateStatus, 10);
    window.vibrateStatus = isNaN(t) ? 0 : t;

    // Next round Alert
    window.nextRoundAlert = window.localStorage.getItem("nextRoundAlert");
    t = parseInt(nextRoundAlert, 10);
    window.nextRoundAlert = isNaN(t) ? 1 : t;

    // Halfway Timer Alert
    window.halfwayTimerAlert = window.localStorage.getItem("halfwayTimerAlert");
    t = parseInt(halfwayTimerAlert, 10);
    window.halfwayTimerAlert = isNaN(t) ? window.halfwayTimerAlertDefault : t;

    window.bgImageId = window.localStorage.getItem("bgImageId");
    t = parseInt(bgImageId, 10);
    window.bgImageId = isNaN(t) ? 1 : t;

    window.soundStatus = window.localStorage.getItem("soundStatus");
    t = parseInt(soundStatus, 10);
    window.soundStatus = isNaN(t) ? 1 : t;

    window.beep321Status = window.localStorage.getItem("beep321Status");
    t = parseInt(beep321Status, 10);
    window.beep321Status = isNaN(t) ? 1 : t;

    window.dontShowAgain = window.localStorage.getItem("dontShowAgain");
    t = parseInt(dontShowAgain, 10);
    window.dontShowAgain = isNaN(t) ? -1 : t;

    window.appLicensedFlag = window.localStorage.getItem("appLicensedFlag");
    t = parseInt(appLicensedFlag, 10);
    window.appLicensedFlag = isNaN(t) ? 1 : t;

    window.noOfWorkOutsDone = window.localStorage.getItem("noOfWorkOutsDone");
    t = parseInt(noOfWorkOutsDone, 10);
    window.noOfWorkOutsDone = isNaN(t) ? 0 : t;

    // Get counter settings
    window.preCount = window.localStorage.getItem("preCount");
    window.preCount = preCount == null ? true : preCount == "true";

    window.descCount = window.localStorage.getItem("descCount");
    window.descCount = descCount == null ? false : descCount == "true";

    window.autoCount = window.localStorage.getItem("autoCount");
    window.autoCount = autoCount == null ? false : autoCount == "true";

    // Get beep settings
    window.startBeepId = window.localStorage.getItem("startBeepId");
    t = parseInt(startBeepId, 10);
    window.startBeepId = isNaN(t) ? startBeepIdDefault : t;

    window.restBeepId = window.localStorage.getItem("restBeepId");
    t = parseInt(restBeepId, 10);
    window.restBeepId = isNaN(t) ? restBeepIdDefault : t;

    window.a321BeepId = window.localStorage.getItem("a321BeepId");
    t = parseInt(a321BeepId, 10);
    window.a321BeepId = isNaN(t) ? a321BeepIdDefault : t;

    // Timer beeps
    window.startTimerBeepId = window.localStorage.getItem("startTimerBeepId");
    t = parseInt(startTimerBeepId, 10);
    window.startTimerBeepId = isNaN(t) ? startTimerBeepIdDefault : t;

    window.halfwayTimerBeepId = window.localStorage.getItem("halfwayTimerBeepId");
    t = parseInt(halfwayTimerBeepId, 10);
    window.halfwayTimerBeepId = isNaN(t) ? halfwayTimerBeepIdDefault : t;

    window.restTimerBeepId = window.localStorage.getItem("restTimerBeepId");
    t = parseInt(restTimerBeepId, 10);
    window.restTimerBeepId = isNaN(t) ? restTimerBeepIdDefault : t;

    window.a321TimerBeepId = window.localStorage.getItem("a321TimerBeepId");
    t = parseInt(a321TimerBeepId, 10);
    window.a321TimerBeepId = isNaN(t) ? a321TimerBeepIdDefault : t;

    window.endBeepId = window.localStorage.getItem("endBeepId");
    t = parseInt(endBeepId, 10);
    window.endBeepId = isNaN(t) ? endBeepIdDefault : t;

    window.countBeepId = window.localStorage.getItem("countBeepId");
    t = parseInt(countBeepId, 10);
    window.countBeepId = isNaN(t) ? 0 : t;

    // Get volume setting
    window.beepAppVolume = window.localStorage.getItem("beepAppVolume");
    t = parseInt(beepAppVolume, 10);
    window.beepAppVolume = isNaN(t) ? 8 : t;

    window.enableAF = window.localStorage.getItem("enableAF");
    window.enableAF = window.enableAF == null ? false : window.enableAF == "true";

    window.mediaVolume = window.beepAppVolume / 10;
    log(TAG + "Volume set to: " + window.mediaVolume);

    // Other prefs
    window.enableLastRest = window.localStorage.getItem("enableLastRest");
    window.enableLastRest = enableLastRest == null ? false : enableLastRest == "true";

    window.enableGA = window.localStorage.getItem("enableGA");
    window.enableGA = enableGA == null ? true : enableGA == "true";

    // Help to be shown once(initial value is false)
    window.masterVolVeryLowHelpShown = window.localStorage.getItem("masterVolVeryLowHelpShown");
    window.masterVolVeryLowHelpShown = window.masterVolVeryLowHelpShown == null ? false : window.masterVolVeryLowHelpShown == "true";

    // Translation
    window.showEnableDTransDiv = window.localStorage.getItem("showEnableDTransDiv");
    window.showEnableDTransDiv = showEnableDTransDiv == null ? false : showEnableDTransDiv == "true";
    if(!showEnableDTransDiv){
        //If translation div is hidden, disable enableDTrans
         window.enableDTrans = false;
         window.localStorage.setItem("enableDTrans",window.enableDTrans);
    }
    else{
         window.enableDTrans = window.localStorage.getItem("enableDTrans");
         window.enableDTrans = enableDTrans == null ? false : enableDTrans == "true";    
    }
    
    
    // Show the Presets View on start
    window.showPresetsView = window.localStorage.getItem("showPresetsView");
    window.showPresetsView = showPresetsView == null ? false : showPresetsView == "true";

    // Define and set the dummy variables
    // Set the dummy variables which hold values
    window.counterModeDummy = window.counterMode;
    window.countValueDummy = window.countValue;
    window.intervalTimeDummy = window.intervalTime;
    window.noOfRoundsDummy = window.noOfRounds;
    window.restTimeDummy = window.restTime;
    // Timer
    window.workTimeDummy = window.workTime;
    window.noOfRoundsTimerDummy = window.noOfRoundsTimer;
    window.restTimeTimerDummy = window.restTimeTimer;

    //Google Fit Preferences
    window.enableGoogleFit = window.localStorage.getItem("enableGoogleFit");
    window.enableGoogleFit = window.enableGoogleFit == null ? false : window.enableGoogleFit == "true";

    window.gFit_includeRest = window.localStorage.getItem("gFit_includeRest");
    window.gFit_includeRest = window.gFit_includeRest == null ? false : window.gFit_includeRest == "true";


    //Android Wear Preferences
    window.enableAndroidWear = window.localStorage.getItem("enableAndroidWear");
    window.enableAndroidWear = window.enableAndroidWear == null ? true : window.enableAndroidWear == "true";
    
    window.vibrateAndroidWear = window.localStorage.getItem("vibrateAndroidWear");
    window.vibrateAndroidWear = window.vibrateAndroidWear == null ? true : window.vibrateAndroidWear == "true";

    window.androidWearKeepScreenON = window.localStorage.getItem("androidWearKeepScreenON");
    window.androidWearKeepScreenON = window.androidWearKeepScreenON == null ? androidWearKeepScreenONDefault : window.androidWearKeepScreenON == "true";

        //Relative Intensity
        window.currentRelativeIntensity = window.localStorage.getItem("currentRelativeIntensity");
        window.currentRelativeIntensity = currentRelativeIntensity == null ? defaultRelativeIntensity : currentRelativeIntensity;

        //Get current Activity
        window.currentActivityType = window.localStorage.getItem("currentActivityType");
        window.currentActivityType = currentActivityType == null ? window.defaultActivityType : currentActivityType;


        //PersonalDetails
        window.personalDetailsLocal = window.localStorage.getItem("personalDetailsLocal");
        window.personalDetailsLocal = window.personalDetailsLocal == null ? personalDetailsLocalDefault : JSON.parse(window.personalDetailsLocal);

        //Include Rest Option
        window.includeRest = window.localStorage.getItem("includeRest");
        window.includeRest = window.includeRest == null ? 0 : window.includeRest;

        //Enable Active Calories
        window.enableActiveCalories = window.localStorage.getItem("enableActiveCalories");
        window.enableActiveCalories = window.enableActiveCalories == null ? false : window.enableActiveCalories == "true";
        
        
        //Metric input
        window.metricInputEnabled = window.localStorage.getItem("metricInputEnabled");
        window.metricInputEnabled = window.metricInputEnabled == null ? true : window.metricInputEnabled == "true";
        
         if(LITE){
            log(TAG + "LITE so setting lite defaults..");
            setFreeVerDefaults();
         }
    
//        Set Active Calories Display State
        setActiveCaloriesDisplayState(enableActiveCalories);
}

// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
function setAppLicensedFlag(appNotLicensed) {
    if (appNotLicensed) {
        // Save to preferences
        window.appLicensedFlag = 0;
        // saveValues();
        if (window.localStorage)
            window.localStorage.setItem("appLicensedFlag", 0);
        if (loggingON)
            console.log("******SET APP LICENSED FLAG****: " + appNotLicensed);

    } else {
        // Do nothing
        window.appLicensedFlag = 1;
        // saveValues();
        if (window.localStorage)
            window.localStorage.setItem("appLicensedFlag", 1);
        if (loggingON)
            console.log("******SET APP LICENSED FLAG****: " + appNotLicensed);

    }
}

// -------------------------------------------------------------------------------------------------------
// process the confirmation dialog result
function onConfirm(buttonIndex) {
    switch (buttonIndex) {
    case 0:
    case 1:
        navigator.app.exitApp();
        break;

    case 2:
        openPlayStore();
        break;
    }
}

// -------------------------------------------------------------------------------------------------------
// Show a custom confirmation dialog
//
function showConfirm() {
    navigator.notification.confirm(appNotLicensedMsg, // message
    onConfirm, // callback to invoke with index of button pressed
    appNotLicensedTitle, // title
    [appNotLicensedExit, appNotLicensedBuyApp] // buttonLabels
    );
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
function afGetSuccess(msg) {
    if (loggingON)
        console.log("afGet success");
    window.media.play();
    media.setVolume(window.mediaVolume);
}

function afGetError(msg) {
    if (loggingON)
        console.log("afGet error");
    window.media.play();
    media.setVolume(window.mediaVolume);
}

function releaseAFSuccess() {

    if (loggingON)
        console.log("releaseAFSuccess: AF released");
}

function releaseAFError() {

    if (loggingON)
        console.log("releaseAFError: AF release error!");
}

function playMedia(src) {
    if (device.platform == 'Android') {
        src = '/android_asset/www/' + src;
    }

    // Clean up old file
    if (window.media != null) {
        media.release();
        media = null;
    }

    window.media = new Media(src, mediaSuccess, mediaError);

    // Get audio focus
    if (window.enableAF) {
        if (loggingON)
            console.log('AF enabled');
        window.getAudioFocus(afGetSuccess, afGetError);
    } else {
        media.play();
        // Set the volume
        media.setVolume(window.mediaVolume);
    }
}

function mediaSuccess() {
    if (loggingON)
        console.log("Media success!");
    if (window.enableAF) {
        if (loggingON)
            console.log('Releaseing AF..');
        window.releaseAudioFocus(releaseAFSuccess, releaseAFError);
    }
}

function mediaError(e) {
    alert('Cannot play audio:' + e.message);
    // alert(e.message);
}

/*
* function getMedia(src) { if (device.platform == 'Android') { src =
* '/android_asset/www/' + src; } // Clean up old file if (window.media != null) {
* media.release(); media = null; }
*
* window.media = new Media(src, success, error_error); return media; }
*
* function success() { // ignore if(loggingON)console.log("Media success!"); }
*
* function error_error(e) { alert('Cannot play audio:' + e.message);
* //alert(e.message); }
*/

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
function hideOnStartFadeDiv() {

    document.getElementById('onStartFadeDiv').style.opacity = "0";
    var td = $('#onStartFadeDiv').css("transition-duration");
    td = td.split('s');
    td = td[0] * 1000;
    // in ms
    window.setTimeout(function() {
        document.getElementById('onStartFadeDiv').style.display = "none";
    }, td);

}

// -------------------------------------------------------------------------------------------

// Get random beeps
function getBeepGetReady() {
    var s = new Array("1", "2", "3");
    return "sounds/getReady" + s[Math.floor(Math.random() * s.length)] + ".ogg";

}

// ------------------------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------------------------------------------------------

// Get random getReady messages
/*
* function getMessageGetReady(){ var ttsMessage = "Get Ready!"; var index
* =Math.floor(Math.random()*7); var roundNo; //var totalRounds;
* //counterMode==1 ? totalRounds = window.noOfRounds : totalRounds =
* window.noOfRoundsTimer; if(window.counterMode==1){ roundNo = window.r +1; }
* else{ roundNo = window.repeat +1; }
*
*
* switch(index){ case 0: ttsMessage = "Round " + roundNo + " in few seconds";
* break;
*
* case 1: ttsMessage = "Get ready for round " + roundNo; break;
*
* case 2: ttsMessage = "Are you ready?"; break;
*
* case 3: ttsMessage = "Round " + roundNo+ " will begin in few seconds"; break;
*
* case 4: ttsMessage = "Get ready for next round"; break;
*
* case 5: var diff =totalRounds-roundNo; if(diff!=0) ttsMessage = (diff+1) + "
* more rounds to go. Prepare"; else ttsMessage = (diff+1) + " more round to go.
* Prepare"; break;
*
* case 6: ttsMessage = "Keep going. " + ((totalRounds-roundNo)+1) + " more to
* go."; break; }
*
* //if(roundNo = window.noOfRounds/2){}
*
* return ttsMessage; //return s[Math.floor(Math.random()*s.length)]; }
*/
// --------------------------------------------------------------------------------------------------------------
// Startup ready messages
/*
* function getMessageGetReadyWarmup(){ var s = new Array("Few seconds to begin.
* Get set!","Get ready!","Are you ready?"); return
* s[Math.floor(Math.random()*s.length)]; }
*/
// --------------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------------
// Beep three times
//
function beep(n) {
    if (devicereadyStatus)
        navigator.notification.beep(n);
}

// Vibrate for 2 seconds
//
function vibrate(n) {
    if (devicereadyStatus)
        navigator.notification.vibrate(n);
}

// -----------------------------
// Toast message plugin
function toast(text, duration) {
    if (duration == "short") {
        toasts.showShort(text, function() {
            // console.log("PhoneGap Plugin: Toast short: callback success");
        }, function() {
            // console.log("PhoneGap Plugin: Toast short: callback error");
        });
    } else if (duration == "long") {
        toasts.showLong(text, function() {
            // console.log("PhoneGap Plugin: Toast long: callback success");
        }, function() {
            // console.log("PhoneGap Plugin: Toast long: callback error");
        });
    } else {
        toasts.cancel(function() {
            // console.log("PhoneGap Plugin: Toast cancel: callback success");
        }, function() {
            // console.log("PhoneGap Plugin: Toast cancel: callback error");
        });
    }
}

// --------------------------------------------------------------------------------------------------------------
// --------------------------------------------------------------------------------------------------------------

function calTotalTime() {
    var wtime;
    var rtime;
    if (counterMode == 1) {

        // Calculate tTime
        wtime = countValue * noOfRounds * intervalTime;
        if (window.enableLastRest)
            rtime = (noOfRounds) * restTime;
        else
            rtime = (noOfRounds - 1) * restTime;
        tTime = wtime + rtime;
        document.getElementById('tTime').innerHTML = "<img style=\"vertical-align:bottom\" height=\"100%\"/>" + tTime.toString().toHHMMSS();
        if (tTime > 3599)
            document.getElementById('tTime').style.fontSize = window.wHeight / 20 + "px";
        else
            document.getElementById('tTime').style.fontSize = window.wHeight / 17 + "px";

        // drawCir(wtime,rtime);
    } else {

        // Calculate tTime
        wtime = (workTime * noOfRoundsTimer);
        if (window.enableLastRest)
            rtime = (noOfRoundsTimer) * restTimeTimer;
        else
            rtime = (noOfRoundsTimer - 1) * restTimeTimer;
        tTime = wtime + rtime;
        document.getElementById('tTime').innerHTML = "<img style=\"vertical-align:bottom\" height=\"100%\"/>" + tTime.toString().toHHMMSS();
        if (tTime > 3599)
            document.getElementById('tTime').style.fontSize = window.wHeight / 15 + "px";
        else
            document.getElementById('tTime').style.fontSize = window.wHeight / 12 + "px";

        // Adjust sCir
        document.getElementById('canvasStart').style.top = "60%";
        // drawCir(wtime,rtime);
    }
    saveValues();

}

// --------------------------------------------------------------------------------------------------------------------------------------------
function calTotalTimeDontSaveValues() {
    if (noOfRoundsVar != 0 && restTimeVar != 0) {
        var wtime;
        if (window.enableLastRest)
            var rtime = (noOfRoundsVar) * restTimeVar;
        else
            var rtime = (noOfRoundsVar - 1) * restTimeVar;
        if (counterMode == 1) {

            if (intervalTimeVar != 0 && countValueVar != 0) {
                // Calculate tTime
                wtime = countValueVar * noOfRoundsVar * intervalTimeVar;
                tTime = wtime + rtime;
                document.getElementById('tTime').innerHTML = "<img style=\"vertical-align:bottom\" height=\"100%\"/>" + tTime.toString().toHHMMSS();
                if (tTime > 3599)
                    document.getElementById('tTime').style.fontSize = window.firstHt / 20 + "px";
                else
                    document.getElementById('tTime').style.fontSize = window.firstHt / 17 + "px";
            }
            // drawCir(wtime,rtime);
        } else {

            // Calculate tTime
            wtime = (workTimeVar * noOfRoundsVar);
            tTime = wtime + rtime;
            document.getElementById('tTime').innerHTML = "<img style=\"vertical-align:bottom\" height=\"100%\"/>" + tTime.toString().toHHMMSS();
            if (tTime > 3599)
                document.getElementById('tTime').style.fontSize = window.firstHt / 15 + "px";
            else
                document.getElementById('tTime').style.fontSize = window.firstHt / 12 + "px";

            // Adjust sCir
            document.getElementById('canvasStart').style.top = "60%";
            // drawCir(wtime,rtime);
        }
        // saveValues();
    }
}

// --------------------------------------------------------------------------------------------------------------------------------------------

// Set the theme based on bgImgId
function setTheme(bgImageId, smooth) {
    var opacity = $('#bgImgDiv').css('opacity');
    window.bgImg = "url(icons/backgrounds/" + window.dpiType + "/bg" + bgImageId + ".jpg)";
    if (smooth) {
        $('#bgImgDiv').fadeTo('fast', 0, function() {
            $(this).css('background-image', bgImg);
            $('#bgDiv').css("background-image", bgImg);
            // $('#quickPrefsDiv').css("background-image",bgImg);
        }).fadeTo('fast', opacity);
    } else {
        $('#bgImgDiv').css("background-image", bgImg);
        // .7
        $('#bgDiv').css("background-image", bgImg);
        // 1
        // $('#quickPrefsDiv').css("background-image",bgImg);
        // $('#hidInner').css("background-image",bgImg);
    }
    saveValues();
}

// ---------------------------------------------------------------------------------------------------------------------------------

function adjustStartCir() {
    // alert(document.getElementById('canvasStart').style.height);
    var per = document.getElementById('canvasStart').style.height;
    per = per.substr(0, 2);
    var hx;
    if(LITE){
        hx = Math.round(per * (wHeight * (1 - .1)) / 100) + "px";
    }else{
        hx = Math.round(per * (wHeight * (1 - .1)) / 100) + "px";
    }
    // var hx=document.getElementById('canvasStart').offsetHeight + "px";
    var css = {
        height : hx,
        width : hx,
        borderRadius : hx,
        borderColor : startCircleColor,
        backgroundColor : startCircleBgColor
    };
    $('#startCircle').css(css);
    document.getElementById('canvasStart').style.visibility = "visible";

    saveValues();
}

// ---------------------------------------------------------------------------------------------------------------------------------

function highlight(a, b) {

    // document.getElementById(a).style.height="20%";
    // document.getElementById(b).style.height = bbHighlightHeight;
    // document.getElementById(b).style.opacity = "1";
    $("#" + b).addClass("innerbottomHighlight");
    document.getElementById('h21').style.visibility = "hidden";
//    document.getElementById('prefs').style.visibility = "hidden";

    //Hide setting image
//    $("#settingsImg").css("display","none");
$("#prefs").css("display","none");
}

function dehighlight(a, b) {

    // document.getElementById(a).style.height="16%";
    // document.getElementById(b).style.height = bbNormalHeight;
    // document.getElementById(b).style.opacity = ".3";
    $("#" + b).removeClass("innerbottomHighlight");
    document.getElementById('h21').style.visibility = "visible";
//    document.getElementById('prefs').style.visibility = "visible";
    calTotalTime();

    //Show setting image
//    $("#settingsImg").css("display","block");
$("#prefs").css("display","block");

    if (gaPlugin != null)
        gaPlugin.trackEvent('Input values', 'slider input');
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------

function sendBackNoInputs() {
    document.getElementById('n0').style.zIndex = "0";
    document.getElementById('n1').style.zIndex = "0";
    document.getElementById('n2').style.zIndex = "0";
    document.getElementById('n3').style.zIndex = "0";
    document.getElementById('n4').style.zIndex = "0";
}

function bringFrontNumberInputs() {

    document.getElementById('n0').style.zIndex = "3";
    document.getElementById('n1').style.zIndex = "3";
    document.getElementById('n2').style.zIndex = "3";
    document.getElementById('n3').style.zIndex = "3";
    document.getElementById('n4').style.zIndex = "3";

}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// Bind number inputs
function f0() {
    var v = window.workTimeVar;
    if (v >= 1 && v <= 5959) {
        // Set new worktime
        window.workTime = window.workTimeVar;
        document.getElementById('workVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + v.toString().toHHMMSS();
    } else {// no change
        // console.log("In on change f0(: NO CHANGE)");
        document.getElementById('workVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + window.workTime.toString().toHHMMSS();
    }
    // Save values
    calTotalTime();
    
     keypadInput = false;
}

function f1() {
    var v = window.countValueVar;
    if (v >= 1 && v < 10000) {
        document.getElementById('countVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + v;
        window.countValue = v;
    } else
        document.getElementById('countVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + window.countValue;

    // Save values
    calTotalTime();
    
     keypadInput = false;
}

function f2() {
    var v = window.intervalTimeVar;
    if (v >= 1 && v <= 5959) {
        document.getElementById('intSecInput').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + v.toString().toHHMMSS();
        window.intervalTime = v;
    } else
        document.getElementById('intSecInput').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + window.intervalTime.toString().toHHMMSS();

    // Save values
    calTotalTime();
    
     keypadInput = false;
}

function f3() {
     log("f3...************" + window.noOfRoundsVar);
     
    var v = window.noOfRoundsVar;
    if (v >= 1 && v < 10000) {
        document.getElementById('roundVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + v + "x";
        counterMode == 1 ? window.noOfRounds = v : window.noOfRoundsTimer = v;
    } else {
        if (counterMode == 1)
            document.getElementById('roundVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + window.noOfRounds + "x";
        else
            document.getElementById('roundVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + window.noOfRoundsTimer + "x";
    }
    // Save values
    calTotalTime();
    
     keypadInput = false;

}

function f4() {
    log("f4...************" + window.restTimeVar);
    var v = window.restTimeVar;
    if (v >= 0 && v <= 5959) {
        document.getElementById('restVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + v.toString().toHHMMSS();
        counterMode == 1 ? window.restTime = v : window.restTimeTimer = v;
        ;
    } else {
        if (counterMode == 1)
            document.getElementById('restVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + window.restTime.toString().toHHMMSS();
        else
            document.getElementById('restVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + window.restTimeTimer.toString().toHHMMSS();
    }
    // Save values
    calTotalTime();
    
     keypadInput = false;

}

function f5() {
    var v = window.startDelayVar;
    if (v >= 0 && v <= 5959) {
        // Set new start delay
        document.getElementById('sdVal').innerHTML = "<img style=\"height:100%; vertical-align:middle\" />" + v.toString().toHHMMSS();
        window.startDelay = v;
    } else {
        document.getElementById('sdVal').innerHTML = "<img style=\"height:100%; vertical-align:middle\" />" + window.startDelay.toString().toHHMMSS();
        // no change
    }
    // console.log(startDelay);
     keypadInput = false;
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
window.serviceRunning = false;
function onStart() {

    // Set the dummy variables which hold values
    window.counterModeDummy = window.counterMode;
    window.countValueDummy = window.countValue;
    window.intervalTimeDummy = window.intervalTime;
    window.noOfRoundsDummy = window.noOfRounds;
    window.restTimeDummy = window.restTime;
    // Timer
    window.workTimeDummy = window.workTime;
    window.noOfRoundsTimerDummy = window.noOfRoundsTimer;
    window.restTimeTimerDummy = window.restTimeTimer;

    // Before starting the workut

    window.warmupON = true;
    window.currDisplayState = 'none';

    // for GA
    if (gaPlugin != null) {
        if (counterMode == 1)
            gaPlugin.trackEvent('Start Workout', 'start counter', 'counter');
        else
            gaPlugin.trackEvent('Start Workout', 'start timer', 'timer');
    }
    goToCountPage();
}

// ---------------------------------------------------------------------------------------------------------------------------------

function goToCountPage() {

    if (serviceRunning) {
        if (loggingON)
            console.log("Service not yet stopped..Please wait!");
        return;
    }

    //Set the currentActivivityType if edit mode is enabled
    if(editMode){
         //Set the currentActivityType
            currentActivityType = editModePreset.activityType;
    }

    // $.mobile.changePage( "#countPage", { transition: "flip", changeHash:
    // true}); //deprecated in jquery mobile 1.4.2
    $("body").pagecontainer("change", "#countPage", {
        transition : "none",
        changeHash : false
    });
}

function setMode(counterMode) {

    var TAG = arguments.callee.name + "(): ";
    
    
    //Making it true enables us to ignore slider onchange event to be called
    keypadInput = true;
    
    
    //Get the getLastSavedPresetActivity


    // Make the showPresetsView false
    window.showPresetsView = false;

    log(TAG + "Setting app mode");
    
    var wtime;
    var rtime;
    if (counterMode == 1) {

        $("#wrapperMain").removeClass("timerDisplay");

        // Set the counter display
        document.getElementById('countVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + countValue;
        document.getElementById('intSecInput').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + intervalTime.toString().toHHMMSS();
        document.getElementById('roundVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + noOfRounds + "x";
        document.getElementById('restVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + restTime.toString().toHHMMSS();
        document.getElementById('sdVal').innerHTML = "<img style=\"height:100%; vertical-align:middle\" />" + startDelay.toString().toHHMMSS();
        $("#v1").val(countValue).slider('refresh');
        $("#v2").val(intervalTime).slider('refresh');
        $("#v3").val(noOfRounds).slider('refresh');
        $("#v4").val(restTime).slider('refresh');
        // $("#v0").val(workTime);

        $('#n1').val(countValue);
        $('#n2').val(intervalTime);
        $('#n3').val(noOfRounds);
        $('#n4').val(restTime);
        // $('#n0').val(workTime);

        // Calculate tTime
        wtime = countValue * noOfRounds * intervalTime;
        if (window.enableLastRest)
            rtime = noOfRounds * restTime;
        else
            rtime = (noOfRounds - 1) * restTime;
        tTime = wtime + rtime;
        document.getElementById('tTime').innerHTML = "<img style=\"vertical-align:bottom\" height=\"100%\"/>" + tTime.toString().toHHMMSS();
        if (tTime > 3599)
            document.getElementById('tTime').style.fontSize = window.wHeight / 20 + "px";
        else
            document.getElementById('tTime').style.fontSize = window.wHeight / 17 + "px";

        // Adjust sCir
        document.getElementById('canvasStart').style.height = "23%";
        document.getElementById('canvasStart').style.top = "74%";
        document.getElementById('startLabel').style.fontSize = ".7em";

        window.counterMode = 1;
        // Disable display timer
        $("#timerB").removeClass('buttonOn');
        $("#timerB").addClass('buttonOff');
        // Disable display timer
        $("#presetsB").removeClass('buttonOn');
        $("#presetsB").addClass('buttonOff');

        // Enable display counter
        $("#counterB").addClass('buttonOn');
        $("#counterB").removeClass('buttonOff');

        // Show the wrapper Div and hide the presets
        // TODO
        $('#wrapperMain').css('display', 'block');
        $('#wrapperPresets').css('display', 'none');

        // Show n2 of intTime
        document.getElementById('n2').style.visibility = "visible";
        document.getElementById('wrapper2').style.visibility = "visible";
        document.getElementById('slider2').style.visibility = "visible";
        document.getElementById('counterDiv2').style.visibility = "visible";

        // Hide works div
        document.getElementById('wrapper1').style.visibility = "visible";
        document.getElementById('n1').style.visibility = "visible";
        document.getElementById('counterDiv1').style.visibility = "visible";
        document.getElementById('slider1').style.visibility = "visible";
        
        document.getElementById('wrapper0').style.visibility = "hidden";
        document.getElementById('n0').style.visibility = "hidden";
        document.getElementById('counterDiv0').style.visibility = "hidden";
        document.getElementById('slider0').style.visibility = "hidden";

        // Shift other divs
        document.getElementById('wrapper3').style.top = "56%";
        document.getElementById('n3').style.top = "56%";
        document.getElementById('counterDiv3').style.top = "56%";
        document.getElementById('wrapper3').style.bottom = "28%";
        document.getElementById('slider3').style.bottom = "26%";

        document.getElementById('wrapper4').style.top = "38%";
        document.getElementById('n4').style.top = "38%";
        document.getElementById('counterDiv4').style.top = "38%";
        document.getElementById('wrapper4').style.bottom = "46%";
         document.getElementById('slider4').style.bottom = "44%";

        // drawCir(wtime,rtime);
        // Dummy variables
        window.restTimeVar = window.restTime;
        window.workTimeVar = window.workTime;
        window.countValueVar = window.countValue;
        window.intervalTimeVar = window.intervalTime;
        window.noOfRoundsVar = window.noOfRounds;
        window.startDelayVar = window.startDelay;

                //Hide the include rest for counter (since its NA for counter)
                $("#includeRestDiv").css("visibility", "hidden");

                //Make the restText to "Rest"
                if ( typeof restLabel != 'undefined') {
                    $('#restlabel').html("<img style=\"height: 100%; vertical-align:baseline\"/>" + restLabel);
                }


    } else/** ****Timer Mode ****** */
    {

        $("#wrapperMain").addClass("timerDisplay");

        // Set the timer display
        document.getElementById('roundVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + noOfRoundsTimer + "x";
        document.getElementById('restVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + restTimeTimer.toString().toHHMMSS();
        document.getElementById('workVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + workTime.toString().toHHMMSS();
        document.getElementById('sdVal').innerHTML = "<img style=\"height:100%; vertical-align:middle\" />" + startDelay.toString().toHHMMSS();

        // $("#v1").val(countValue);
        // $("#v2").val(intervalTime);
        $("#v3").val(noOfRoundsTimer).slider('refresh');
        $("#v4").val(restTimeTimer).slider('refresh');
        $("#v0").val(workTime).slider('refresh');

        // $('#n1').val(countValue);
        // $('#n2').val(intervalTime);
        $('#n3').val(noOfRoundsTimer);
        $('#n4').val(restTimeTimer);
        $('#n0').val(workTime);

        // Calculate tTime
        wtime = (workTime * noOfRoundsTimer);
        if (window.enableLastRest)
            rtime = (noOfRoundsTimer) * restTimeTimer;
        else
            rtime = (noOfRoundsTimer - 1) * restTimeTimer;
        tTime = wtime + rtime;
        document.getElementById('tTime').innerHTML = "<img style=\"vertical-align:bottom\" height=\"100%\"/>" + tTime.toString().toHHMMSS();
        if (tTime > 3599)
            document.getElementById('tTime').style.fontSize = window.wHeight / 15 + "px";
        else
            document.getElementById('tTime').style.fontSize = window.wHeight / 12 + "px";

        // Adjust sCir
        document.getElementById('canvasStart').style.top = "60%";
        document.getElementById('canvasStart').style.height = "30%";
        document.getElementById('startLabel').style.fontSize = "1em";

        window.counterMode = 0;
        // Disable display counter
        $("#counterB").removeClass('buttonOn');
        $("#counterB").addClass('buttonOff');
        // Disable display presets
        $("#presetsB").removeClass('buttonOn');
        $("#presetsB").addClass('buttonOff');

        // Enable display timer
        $("#timerB").addClass('buttonOn');
        $("#timerB").removeClass('buttonOff');

        // Show the wrapper Div and hide the presets
        // TODO
        $('#wrapperMain').css('display', 'block');
        $('#wrapperPresets').css('display', 'none');

        /*
        * $("#wrapperMain").removeClass('counterDisplay');
        * $("#wrapperMain").addClass('timerDisplay');
        */

        // Hide n2 of intTime
        document.getElementById('n2').style.visibility = "hidden";
        document.getElementById('wrapper2').style.visibility = "hidden";
        document.getElementById('counterDiv2').style.visibility = "hidden";
        document.getElementById('slider2').style.visibility = "hidden";

        // Show works div
        document.getElementById('wrapper0').style.visibility = "visible";
        document.getElementById('n0').style.visibility = "visible";
        document.getElementById('counterDiv0').style.visibility = "visible";
        document.getElementById('slider0').style.visibility = "visible";
        
        document.getElementById('wrapper1').style.visibility = "hidden";
        document.getElementById('n1').style.visibility = "hidden";
        document.getElementById('counterDiv1').style.visibility = "hidden";
        document.getElementById('slider1').style.visibility = "hidden";

        // Shift other divs
        document.getElementById('wrapper4').style.top = "20%";
        document.getElementById('n4').style.top = "20%";
        document.getElementById('counterDiv4').style.top = "20%";
        document.getElementById('wrapper4').style.bottom = "64%";
         document.getElementById('slider4').style.bottom = "62%";
         
        document.getElementById('wrapper3').style.top = "38%";
        document.getElementById('n3').style.top = "38%";
        document.getElementById('counterDiv3').style.top = "38%";
        document.getElementById('wrapper3').style.bottom = "46%";
        document.getElementById('slider3').style.bottom = "44%";

        // drawCir(wtime,rtime);
        // Dummy variables
        window.restTimeVar = window.restTimeTimer;
        window.workTimeVar = window.workTime;
        window.countValueVar = window.countValue;
        window.intervalTimeVar = window.intervalTime;
        window.noOfRoundsVar = window.noOfRoundsTimer;
        window.startDelayVar = window.startDelay;

        //Show the include rest for timer
        $("#includeRestDiv").css("visibility", "visible");

        //Set the includeRest option
        setIncludeRest(window.includeRest);


    }
    adjustStartCir();

    //Make the keypadInput again false after setMode(..)
    keypadInput = false;

    // Set the preferences if on device ready
    if (testingMode != 'chrome') {
        if (devicereadyStatus)
            setPreferences();
    } else {
        setPreferences();
    }


//     ------------------------------------
//         Intensity and include rest dummys which are passed to setConfig(...)
//        This prevents originals from getting overriden when preset is started. So when setMode(..) is called,
//        the counter/timer state is preserved
        window.intensity_Temp = window.currentRelativeIntensity;
        window.includeRest_Temp = window.includeRest;
//        ------------------------------------


    if(window.totalPresets == -1){
        log(TAG + "totalPresets = -1, so loading presets count...");
        loadTotalPresetsCount();
    }

    // for GA
    var screenName = counterMode == 1 ? 'Counter' : 'Timer';
    if (!( typeof gaPlugin === null))//(gaPlugin === null) ---> false when gaPlugin is undefined
        // gaPlugin is undefined --> true ... null --> false
        $.when(gaStartedDeferred).done(function() {
            gaPlugin.trackView(screenName);
        });
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ------------------------------------------------------
// ------------------------------------------------------
// TTS functions
// -------------------------------------------------------
// --------------------------------------------------------

function winGetLanguage(result) {

    // console.log(result);
    // Get the language substr
    result = result.substring(0, 2);

    // console.log(result);

    // Currently supported language translations
    switch (result) {
    /*
     * case 'en': //alert('us'); setMessages_en(); break;
     *
     * case 'fr': //alert('Fr'); setMessages_fr(); break;
     *
     * case 'de': //alert('Ger'); setMessages_de(); break;
     *
     * case 'it': //alert('Italian'); setMessages_it(); break;
     *
     * case 'es': //alert('Spanish'); setMessages_es(); break;
     *
     * case 'ru': //alert('Russian'); setMessages_ru(); break;
     */

    default:
        setMessages_en();

    /*
     * case 'ja': alert('Japanese'); break;
     *
     * case 'ko': alert('Korean'); break;
     *
     * case 'zh': alert('Chinese'); break;
     */

    }

}

function failGetLanguage(result) {

    // Cannot get current language
    setMessages('en');

}

// ------------------------------------------------------
function startupWin(result) {
    // When result is equal to STARTED we are ready to play
    if (result == window.plugins.tts.STARTED) {
        if (loggingON)
            console.log('TTS.STARTED');
        window.statusTTS = 1;

        // Check for TTS language and set strings based on that
        // window.plugins.tts.getLanguage(winGetLanguage, failGetLanguage);

        // alert('Checking language');
        /*
        * window.plugins.tts.isLanguageAvailable("en_GB", function() {
        * //alert('Language available');
        * window.plugins.tts.setLanguage("en_GB");
        * window.plugins.tts.speak("The text to speech service is ready."); },
        * failLanguageAvailable);
        */
        // Ready to go
        // window.plugins.tts.speak("The text to speech service is ready.");
        // window.plugins.tts.speak("Let me think.");
        // window.plugins.tts.silence(2000);
        // window.plugins.tts.speak("I do not know. May be its 2. Or 3. Or 11.
        // Or 7!");
    } else if (result == window.plugins.tts.INITIALIZING) {
        if (loggingON)
            console.log("TTS.INITIALIZING: " + result);
        window.statusTTS = 1;
    } else {
        if (loggingON)
            console.log("In startupwin: " + result);
        // window.statusTTS = 0;
    }

}

function stopWin() {
    if (loggingON)
        console.log('Stopped TTS');
    window.statusTTS = 0;
    if (window.enableAF) {
        // Release the AF in case playing audio
        if (loggingON)
            console.log('Releaseing AF..');
        window.releaseAudioFocus(releaseAFSuccess, releaseAFError);
    }
}

function failStartup() {
    window.statusTTS = 0;
    if (loggingON)
        console.log('Text to Speech is not working for your phone!');
    toast(tmTTSNotWorking, "short");

    // Disable beep for voice
    // window.timerAlerts='beeps';
    // window.counterAlerts='beeps';
    // window.nextRoundAlert =0;
    saveValues();
}

function failShutDown() {
    window.statusTTS = 1;
    if (loggingON)
        console.log('FAIL-SHUTDOWN-TTS: Could not stop TTS');
}

function failLanguageAvailable() {
    // console.log('failLanguageAvailable: Could check for languuage');
}

function getEnginesWin(result) {
    // alert("getEnginesWin: " + result)
}

function failGetEngines(result) {

    // alert("failGetEngines: " + result);
}

// ---------------------------------------------------------
function shutdownTTS() {
    window.plugins.tts.shutdown(stopWin, failShutDown);
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
function setPreferences() {

    var TAG = arguments.callee.name + "(): ";
    log(TAG + "Setting preferences");
    window.beepEndOfWorkoutS = 'sounds/end/' + endBeep[endBeepId] + ext;

    window.beepNotifyS = null;
    // Set the beeps
    if (counterMode == 1) {
        window.beepNotifyS = 'sounds/a321/' + a321Beep[a321BeepId] + ext;
        window.beepRestStartS = 'sounds/start/' + restBeep[restBeepId] + ext;
        window.beepRoundStartS = 'sounds/start/' + startBeep[startBeepId] + ext;
    } else {
        window.beepNotifyS = 'sounds/a321/' + a321Beep[a321TimerBeepId] + ext;
        window.beepRestStartS = 'sounds/start/' + restBeep[restTimerBeepId] + ext;
        window.beepRoundStartS = 'sounds/start/' + startBeep[startTimerBeepId] + ext;
        window.beepHalfwayS = 'sounds/start/' + halfwayBeep[halfwayTimerBeepId] + ext;
    }

    window.beepEndOfWorkoutS = 'sounds/end/' + endBeep[endBeepId] + ext;

    // Start the TTS service
    if (devicereadyStatus)
        window.plugins.tts.startup(startupWin, failStartup);
}

// --------------------------------------------------------------------------------------------------
function setDummyValueVariables() {
    if (counterMode == 1) {
        window.restTimeVar = window.restTime;log("**********restTime*************" + restTime);
        window.workTimeVar = window.workTime;
        window.countValueVar = window.countValue;
        window.intervalTimeVar = window.intervalTime;
        window.noOfRoundsVar = window.noOfRounds;
        window.startDelayVar = window.startDelay;
    } else {
        window.restTimeVar = window.restTimeTimer;
        //
        window.workTimeVar = window.workTime;
        window.countValueVar = window.countValue;
        window.intervalTimeVar = window.intervalTime;
        window.noOfRoundsVar = window.noOfRoundsTimer;
        //
        window.startDelayVar = window.startDelay;
    }
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
function clearInput0() {
    document.getElementById('workVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + "0:00";
    $("#n0").val(null);
    setDummyValueVariables();

    if (gaPlugin != null)
        gaPlugin.trackEvent('Input values', 'numpad input');
        
         keypadInput = true;
}

function clearInput1() {
    document.getElementById('countVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + "0";
    $("#n1").val(null);
    setDummyValueVariables();

    if (gaPlugin != null)
        gaPlugin.trackEvent('Input values', 'numpad input');
        
         keypadInput = true;

}

function clearInput2() {
    document.getElementById('intSecInput').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + "0:00";
    $("#n2").val(null);
    setDummyValueVariables();

    if (gaPlugin != null)
        gaPlugin.trackEvent('Input values', 'numpad input');
        
         keypadInput = true;
}

function clearInput3() {
    document.getElementById('roundVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + "0x";
    $("#n3").val(null);
    setDummyValueVariables();

    if (gaPlugin != null)
        gaPlugin.trackEvent('Input values', 'numpad input');
        
         keypadInput = true;
}

function clearInput4() {
    document.getElementById('restVal').innerHTML = "<img style=\"height:100%; vertical-align:baseline\" />" + "0:00";
    $("#n4").val(null);
    setDummyValueVariables();

    if (gaPlugin != null)
        gaPlugin.trackEvent('Input values', 'numpad input');
        
         keypadInput = true;
}

function clearInput5() {
    document.getElementById('sdVal').innerHTML = "<img style=\"height:100%; vertical-align:middle\" />" + "0:00";
    $("#n5").val(null);
    setDummyValueVariables();

    if (gaPlugin != null)
        gaPlugin.trackEvent('Input values', 'numpad input');
        
         keypadInput = true;
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------

function calcDeg1(deg) {
    return (Math.PI / 180) * (deg - 90);
}

function calcDeg(deg) {
    return (Math.PI / 180) * (deg - 90);
}

function drawCir(a, b) {
    var TAG = arguments.callee.name + "(): ";
    log(TAG);
    if(disableCanvas){
            log(TAG + "Canvas is disabled...do nothing..");
            return;
    }

    var canvas = document.getElementById('canvasCircle');
    var ctx;
    if (canvas.getContext) {
        ctx = canvas.getContext('2d');
    }
    canvas.width = canvas.offsetWidth;
    canvas.height = canvas.offsetHeight;
    var x = Math.round(canvas.offsetWidth / 2);
    var y = Math.round(canvas.offsetHeight / 2);
    var radius = canvas.offsetHeight / 2.2;
    var totalTime = a + b;
    var timeAngleA = (360 / (totalTime)) * a;
    // var timeAngleB = (360/(totalTime)) * b;

    ctx.arc(x, y, radius, 0, 2 * Math.PI, false);
    ctx.fillStyle = "rgb(20,20,20)";
    ctx.fill();
    ctx.beginPath();
    ctx.lineWidth = 3;
    // Draw arcA
    ctx.strokeStyle = "rgba(255,175,58,.9)";
    ctx.arc(x, y, radius, calcDeg1(0), calcDeg(timeAngleA), false);
    ctx.stroke();

    // Draw arcB
    ctx.beginPath();
    ctx.strokeStyle = restColor;
    ctx.arc(x, y, radius, calcDeg(timeAngleA), 1.5 * Math.PI, false);
    ctx.stroke();

}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------

function onMenuKeyDown() {
    // Handle the back button
}

function onSearchKeyDown() {
    // Handle the search button
}

function onStartCallKeyDown() {
    // Handle the start call button
}

function onEndCallKeyDown() {
    // Handle the end call button
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------

function showTouchDisableDiv() {

    window.touchDisableDivON = true;
    var tdDiv = document.getElementById('touchDisableDiv');
    var ictTextDiv = document.getElementById('ictCountPage');
//    if (swipeNo > 1) {
//        swipeNo = 0;
//    }

    swipeNo = 0;
    // Change opacity based on swipe no
    switch (swipeNo) {
    case 0:
        // tdDiv.style.opacity=".1";
        tdDiv.style.backgroundColor = "rgba(0,0,0,.1)";
        swipeNo++;

        // Show toast notification
        if (devicereadyStatus)
            toast(tmSmartLock, "long");

        // Disable back key press
        // document.addEventListener("backbutton", onBackKeyDown, false);

        // Disable menu
        document.addEventListener("menubutton", onMenuKeyDown, false);
        document.addEventListener("searchbutton", onSearchKeyDown, false);
        document.addEventListener("startcallbutton", onStartCallKeyDown, false);
        document.addEventListener("endcallbutton", onEndCallKeyDown, false);
        break;

    case 1:
        // tdDiv.style.opacity=".8";
        tdDiv.style.backgroundColor = "rgba(0,0,0,.9)";
        swipeNo++;
        break;

    case 2:
        tdDiv.style.opacity = "0";
        swipeNo++;
        break;

    case 3:
        tdDiv.style.opacity = ".1";
        swipeNo++;
        break;
    }

    tdDiv.style.visibility = "visible";
    ictTextDiv.style.color = "white";
    $('#ictCountPage').css('opacity', '.7');
    document.getElementById('lockImg').style.visibility = "visible";

    //GA event
     if(gaPlugin!=null)
            gaPlugin.trackEvent('Smart Lock', 'smart lock enabled');
}

function hideTouchDisableDiv() {
    window.touchDisableDivON = false;
    document.getElementById('touchDisableDiv').style.visibility = "hidden";
    document.getElementById('ictCountPage').style.color = "rgb(102,102,102)";
    document.getElementById('lockImg').style.visibility = "hidden";
    window.swipeNo = 0;
    // Enable disable buttons
    // document.removeEventListener("backbutton", onBackKeyDown, false);

    // Enable menu
    document.removeEventListener("menubutton", onMenuKeyDown, false);
    document.removeEventListener("searchbutton", onSearchKeyDown, false);
    document.removeEventListener("startcallbutton", onStartCallKeyDown, false);
    document.removeEventListener("endcallbutton", onEndCallKeyDown, false);
    $('#ictCountPage').css('opacity', '1');
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
function blinkLeftTime() {
    var vis = true;
    document.getElementById('pauseButtonDiv1').style.opacity = "0";
    vis = false;
    blinkInt = accurateInterval(function() {
        if (paused) {
            if (!vis) {
                document.getElementById('pauseButtonDiv1').style.opacity = "1";
                vis = true;
            } else {
                document.getElementById('pauseButtonDiv1').style.opacity = "0";
                vis = false;
            }
        } else {

            blinkInt.cancel();
            document.getElementById('pauseButtonDiv1').style.opacity = "1";
        }
    }, 500);
}

function pause() {
    if (!paused) {
        paused = true;
        document.getElementById('pauseButtonText').innerHTML = "<img height=\"100%\" style=\"vertical-align:middle\"/>" + pauseButtonTextStart;
        // Change display state
        document.getElementById('h2').style.backgroundColor = pauseColor;
        
        //For landscapeView
        document.getElementById('landscapeRoundNumberView').style.backgroundColor = pauseColor;
        document.getElementById('landscapeTimeLeftView').style.backgroundColor = pauseColor;
        document.getElementById('landscapePercentProgressView').style.backgroundColor = pauseColor;
        
    } else {
        paused = false;
        document.getElementById('pauseButtonDiv1').style.opacity = 1;
        document.getElementById('pauseButtonText').innerHTML = "<img height=\"100%\" style=\"vertical-align:middle\"/>" + pauseButtonTextStop;

        // Change display state
        document.getElementById('h2').style.backgroundColor = 'rgba(49,81,83,.3)';
        
         //For landscapeView
        document.getElementById('landscapeRoundNumberView').style.backgroundColor = "#101010";
        document.getElementById('landscapeTimeLeftView').style.backgroundColor = "#101010";
        document.getElementById('landscapePercentProgressView').style.backgroundColor = "#101010";
    }

    //Obviously count started is true
    setConfig();

    // Stop the TTS if playing
    if (statusTTS == 1)
        window.plugins.tts.stop();

}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
function saveState(per) {
    var sVar = new Array(5);
    sVar[0] = window.r;
    sVar[1] = window.autoClicks;
    sVar[2] = window.elapsedTime;
    sVar[3] = tLeft;
    if (restTimeON)
        sVar[4] = 1;
    else
        sVar[4] = 0;
    state[per] = sVar;
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
function checkForAutoCount() {

    window.autoCountMode = Math.floor(Math.random() * 2);
    if (autoCount) {
        if (window.autoCountMode == 0) {
            descCount = false;
            i = 1;
        } else {
            descCount = true;
            i = n;
        }
        if (loggingON)
            console.log('Auto Count Mode: ' + autoCountMode);
    }
    if (preCount) {
        if (descCount) {
            i = n;
            no.innerHTML = "<img style=\"height:100%; vertical-align:middle\" />" + n;
        } else {
            i = 1;
            no.innerHTML = "<img style=\"height:100%; vertical-align:middle\" />" + "1";
        }
    } else {
        if (descCount) {
            i = n;
            no.innerHTML = "<img style=\"height:100%; vertical-align:middle\" />" + "-";
        } else {
            i = 1;
            no.innerHTML = "<img style=\"height:100%; vertical-align:middle\" />" + "0";
        }
    }

}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
function ttsSpeakSuccess(s) {
    if (loggingON)
        console.log('ttsSpeakSuccess: ' + s);
    if (window.enableAF)
        window.releaseAudioFocus(releaseAFSuccess, releaseAFError);
}

function ttsSpeakError(e) {
    if (loggingON)
        console.log('ttsSpeakError: ' + e);
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------

function setupCanvas() {

    var TAG = arguments.callee.name + "(): ";
    log(TAG);
    if(disableCanvas){
        log(TAG + "Canvas is disabled...do nothing..");
        return;
    }
    canvas = document.getElementById('myCanvas');
    if (canvas.getContext) {
        ctx = canvas.getContext('2d');
    }

    canvas.width = canvas.offsetWidth;
    canvas.height = canvas.offsetHeight;
    x = canvas.offsetWidth / 2;
    y = canvas.offsetHeight / 2;
    radius = canvas.offsetHeight / 2.2;

    ctx.strokeStyle = "rgb(41,41,41)";

    // Draw a circle
    ctx.lineWidth = 4;
    ctx.arc(x, y, radius, 0, 2 * Math.PI, false);  //Angle should be in radians
    ctx.stroke();

    // ctx.fillStyle=startCircleBgColor;
    // ctx.fill();

    ctx.strokeStyle = playColor;

    if (loggingON)
        console.log('Canvas set up!');
}

// process the confirmation dialog result
function onShowRateUs(buttonIndex) {
    switch (buttonIndex) {

    case 0:
    case 2:
        // Later or alert close
        window.noOfWorkOutsDone = 0;
        saveValues();

        if (gaPlugin != null)
            gaPlugin.trackEvent('Rate Us', 'rate us dialog', 'later');

        goToMainPage("fade", 500);

        // Stop service
        stopService();

        break;
    case 1:
        // already done
        window.noOfWorkOutsDone = -1;
        saveValues();

        if (gaPlugin != null)
            gaPlugin.trackEvent('Rate Us', 'rate us dialog', 'done');

        goToMainPage("fade", 500);
        // Stop service
        stopService();
        break;

    case 3:
        // Proceed
        window.noOfWorkOutsDone = -1;
        saveValues();

        to = window.setTimeout(function() {
            openPlayStore();
        }, 300);

        if (gaPlugin != null)
            gaPlugin.trackEvent('Rate Us', 'rate us dialog', 'proceed', 1);

        goToMainPage("fade", 500);
        // Stop service
        stopService();

        break;
    }
}

// Show a custom confirmation dialog
//
function showRateUs() {
    var r = Math.floor(Math.random() * 3);
    var message = "";
    if (r == 1) {
        message = rateUsMsg1;
    } else if (r == 2) {
        message = rateUsMsg2;
    } else{
        message = rateUsMsg3;
    }
    
    //Check for Amazon app
    if(AMZN_APP){
        message = message.replace("Google Play", "App Store");
    }

    if (devicereadyStatus)
        navigator.notification.confirm(message, // message
        onShowRateUs, // callback to invoke with index of button pressed
        rateUsTitle, // title
        [rateUsDone, rateUsLater, rateUsProceed]);
    else {
        if (loggingON)
            console.log('Rates us alert!');
    }

    // if (soundStatus == 1) {
    // if (vibrateStatus == 1)
    // vibrate(tvLong);
    //
    // if (window.statusTTS == 0) {
    // // var m = getMedia(beepEndOfWorkoutS);
    // // m.play();
    // // m.setVolume(window.mediaVolume);
    // playWorkoutEndAlert();
    // } else {
    // window.plugins.tts.speak(message);
    // }
    // }
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------

function drawSeconds() {
    var TAG = arguments.callee.name + "(): ";
    log(TAG);
    if(disableCanvas){
            log(TAG + "Canvas is disabled...do nothing..");
            return;
    }

    timeAngle = (360 / (ttms)) * etms;
    ctx.lineWidth = 4;
    ctx.beginPath();
    if (prevTA < timeAngle &&(timeAngle - prevTA > 1.5)) {
//      log("********************************************");
//            log(TAG + "prevTA = " + prevTA);
//            log(TAG + "timeAngle = " + timeAngle);
        ctx.arc(x, y, radius, calcDeg(prevTA), calcDeg(timeAngle), false);
        ctx.stroke();
        prevTA = timeAngle;
    }
}

// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------------------
String.prototype.toHHMMSS = function() {
    sec_numb = parseInt(this, 10);
    if (!isNaN(sec_numb)) {
        var hours = Math.floor(sec_numb / 3600);
        var minutes = Math.floor((sec_numb - (hours * 3600)) / 60);
        var seconds = sec_numb - (hours * 3600) - (minutes * 60);

        if (hours < 10) {
            hours = hours;
        }
        if (minutes < 10 && hours > 0) {
            minutes = "0" + minutes;
        }
        if (seconds < 10) {
            seconds = "0" + seconds;
        }
        if (hours == 0)
            time = minutes + ':' + seconds;
        else
            time = hours + ':' + minutes + ':' + seconds;
    }
    return time;
};

String.prototype.toMMSS = function() {
    sec_numb = parseInt(this, 10);
    if (!isNaN(sec_numb)) {
        var hours = Math.floor(sec_numb / 3600);
        var minutes = Math.floor((sec_numb - (hours * 3600)) / 60);
        var seconds = sec_numb - (hours * 3600) - (minutes * 60);

        if (minutes < 10) {
            minutes = minutes;
        }
        if (seconds < 10) {
            seconds = "0" + seconds;
        }
        time1 = minutes + ':' + seconds;
        return time1;
    } else
        return time1;
};
// --------------------------------------------------------------------------------
// --------------------------------------------------------------------------------
function share(subject, text) {
    var share = cordova.require("cordova/plugin/share");
    share.show({
        subject : subject,
        text : text
    }, function() {
        // console.log("PhoneGap Plugin: Share: callback success");
    }, function() {
        // console.log("PhoneGap Plugin: Share: callback error");
    });
}

function showAbout() {
    $.mobile.changePage("#aboutPage", {
        transition : "fade",
        changeHash : true
    });
}


function getHelpPagesPath(){

    // var s = window.applicationIdFromConfig;
        // var path = '';
// 
        // if(s.indexOf("amzn") > -1){
            // //Amzn app
            // path = 'helpdocs/';
        // }else if(s.indexOf("free") > -1){
            // //Free app
            // path = 'ict_free/helpdocs_free/';
        // }
        // else{
            // path = 'helpdocs/';
        // }
    return 'helpdocs/';
}


function showHelp() {



    var lan = getCurrentLanguage();
    //var helpPageURL = "helpdocs/" + "help_" + lan + ".html";
    var helpPageURL = getHelpPagesPath() + "help_" + lan + ".html";
    $.mobile.navigate(helpPageURL, {
        transition : 'none',
        changeHash : true
    });
}

function showFeedback() {
    $.mobile.changePage("#feedbackPage", {
        transition : "fade",
        changeHash : true
    });
}

// ------------------------------------------------------------------------------------------------------------------------------
// ************* Note: function is called from java code ***************
function setTTSDataAvailable(r) {
    if (r == 1) {
        window.TTSDataAvailable = 1;
        // console.log("Message from java...TTS data available");
    } else {
        window.TTSDataAvailable = 0;
        // console.log("Message from java...TTS data NOT available");
    }
}

// **************************************************************************************************************************
// **************************************************************************************************************************
// -----------------------------------------------------------------------------------COUNT
// PAGE functions-------------------
// ---------------COUNT PAGE
// functions---------------------------------------------------------------------------------------
// --------------------------------------------------------COUNT PAGE
// functions----------------------------------------------
// --------------------------------------------------------------------------------------------------------------------------
// ----------------------------COUNT PAGE
// functions--------------------------------------------------------------------------
// **************************************************************************************************************************
// **************************************************************************************************************************
function hidePrefs2() {
    
    // Setting icon transfor
    $('#settingsImg2').css("-webkit-transition-duration", ".25s");
    $('#settingsImg2').removeClass('rotateImg');



    $('#quickPrefsDiv2').css("-webkit-transition-duration", ".25s");
    document.getElementById('quickPrefsDiv2').style.webkitTransform = "rotateY(90deg)";
    prefOn2 = false;
    // Hide the div from DOM:the prefDiv1
    document.getElementById('prefDiv2').style.display = "none";
    document.getElementById('prefLabel2').style.visibility = "hidden";
    // set the preferences i.e. sounds
    setPreferences();
    // Save the values
    saveValues();

    // Enable the smart lock button
//    $("#ictCountPage").on('taphold',{delay: 2000},smartLock);

    // Set the configuration (only the changes will be set)
    setConfig();

    // for GA
    if (gaPlugin != null) {
        gaPlugin.trackView('CountTimer Page');
    }
}

function showPref2() {
    var TAG = arguments.callee.name + "(): ";
    if (!prefOn2) {
        
        // Setting icon transfor
        $('#settingsImg2').css("-webkit-transition-duration", ".7s");
        $('#settingsImg2').addClass('rotateImg');
        
        
        $('#quickPrefsDiv2').css("-webkit-transition-duration", ".40s");
        // Display:block the prefDiv2
        document.getElementById('prefDiv2').style.display = "block";
        document.getElementById('prefLabel2').style.visibility = "visible";
        ;

        // Get and set previous value
        $('#321AlertCB2').prop('checked', window.beep321Status == 1);
        $('#nextRoundCB2').prop('checked', window.nextRoundAlert == 1);
        $('#vibrationCB2').prop('checked', window.vibrateStatus == 1);
        $('#soundCB2').prop('checked', window.soundStatus == 1);
        // Audio focus
        $('#audioFocusCB2').prop('checked', window.enableAF);

        if (window.soundStatus == 1) {
            // setSoundOnState
            $('#321AlertCB2').prop("disabled", false);
            $('#321AlertDiv2').css("opacity", "1");
            $('#nextRoundCB2').prop("disabled", false);
            $('#nextRoundDiv2').css("opacity", "1");
            $('#audioFocusCB2').prop("disabled", false);
            $('#audioFocusDiv2').css("opacity", "1");
            $('#beepVolSlider2').slider('enable');
            $('#beepVolDiv2').css("opacity", "1");
        } else {
            // setSoundOnState
            $('#321AlertCB2').prop("disabled", true);
            $('#321AlertDiv2').css("opacity", ".35");
            $('#nextRoundCB2').prop("disabled", true);
            $('#nextRoundDiv2').css("opacity", ".35");
            $('#audioFocusCB2').prop("disabled", true);
            $('#audioFocusDiv2').css("opacity", ".35");
            $('#beepVolSlider2').slider('disable');
            $('#beepVolDiv2').css("opacity", ".35");
        }

        // window.counterAlerts=='voice' ? $('#voiceCA2').prop('checked', true)
        // : $('#beepsCA2').prop('checked', true);
        // Timer
        // window.timerAlerts=='voice' ? $('#voiceTA2').prop('checked', true) :
        // $('#beepsTA2').prop('checked', true);

        prefOn2 = true;

        // Set slider values
        $('#beepVolSlider2').val(beepAppVolume);
        $('#beepVolSlider2').slider("refresh");
        // setVolImage(window.beepAppVolume,2);

        document.getElementById('quickPrefsDiv2').style.webkitTransform = "rotateY(0deg)";

        // for GA
        if (gaPlugin != null) {
            gaPlugin.trackView('Preferences-2');
        }
        
        
        if(LITE){
                log(TAG + "Disabling prefs2 for FREE version");
                $('#nextRoundCB2').prop("disabled", true);
                $('#audioFocusCB2').prop("disabled", true);
                $('#beepVolSlider2').prop("disabled", true);
                $('#beepVolSlider2').slider('disable');
        }   
    } else {
        hidePrefs2();
    }
}

// Callback function references the event target and adds the 'tap' class to it
function tapholdHandler2(event) {
    event.stopImmediatePropagation();
    if (loggingON)
        console.log('Tap');
    if (!tapHold2) {
        showPref2();
    } else
        tapHold2 = false;
    // done with taphold
}

var smartLockOn = false;
function smartLock(event) {
    event.stopImmediatePropagation();
    if (loggingON)
        console.log('Taphold');

    if(!smartLockOn){
        showTouchDisableDiv();
        smartLockOn = true;
    }
    else{
        hideTouchDisableDiv();
        smartLockOn = false;
    }

        vibrate(tvHapticFeedBack);


        if (loggingON)
            console.log('disabling tap on iCountTimer..');

}

function toggle321Alert2() {

    if ($('#321AlertCB2').is(':checked')) {
        // the checkbox was checked
        window.beep321Status = 1;
    } else {
        // the checkbox was unchecked
        window.beep321Status = 0;
    }

}

function toggleNextRoundAlert2() {

    if ($('#nextRoundCB2').is(':checked')) {
        // the checkbox was checked
        window.nextRoundAlert = 1;
    } else {
        // the checkbox was unchecked
        window.nextRoundAlert = 0;
    }

}

function toggleVibration2() {

    if ($('#vibrationCB2').is(':checked')) {
        // the checkbox was checked
        window.vibrateStatus = 1;
    } else {
        // the checkbox was unchecked
        window.vibrateStatus = 0;
    }

}

function toggleSoundStatus2() {

    if ($('#soundCB2').is(':checked')) {
        // the checkbox was checked
        window.soundStatus = 1;
        $('#321AlertCB2').prop("disabled", false);
        $('#321AlertDiv2').css("opacity", "1");
        $('#nextRoundCB2').prop("disabled", false);
        $('#nextRoundDiv2').css("opacity", "1");
        $('#audioFocusCB2').prop("disabled", false);
        $('#audioFocusDiv2').css("opacity", "1");
        $('#beepVolSlider2').slider('enable');
        $('#beepVolDiv2').css("opacity", "1");
        // Check for low device volume
        if (devicereadyStatus) {
            deviceVolume = -1;
            VolumeControl.getVolume(getVolSuccess, getVolError);
        } else if (loggingON)
            console.log('check for low device volume');

    } else {
        // the checkbox was unchecked
        window.soundStatus = 0;
        $('#321AlertCB2').prop("disabled", true);
        $('#321AlertDiv2').css("opacity", ".35");
        $('#nextRoundCB2').prop("disabled", true);
        $('#nextRoundDiv2').css("opacity", ".35");
        $('#audioFocusCB2').prop("disabled", true);
        $('#audioFocusDiv2').css("opacity", ".35");
        $('#beepVolSlider2').slider('disable');
        $('#beepVolDiv2').css("opacity", ".35");
    }

}

// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------

// This jQuery Plugin will disable text selection for Android and iOS devices.
// Stackoverflow Answer: http://stackoverflow.com/a/2723677/1195891
$.fn.extend({
    disableSelection : function() {
        this.each(function() {
            this.onselectstart = function() {
                return false;
            };
            this.unselectable = "on";
            $(this).css('-moz-user-select', 'none');
            $(this).css('-webkit-user-select', 'none');
        });
    }
});

(function($) {
    $.fn.disableSelection2 = function() {
        return this.prop('unselectable', 'on').css('user-select', 'none').on('selectstart', false);
    };
})(jQuery);

// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------

// Sets rgba without specifying the rgb?
HTMLElement.prototype.alpha = function(a) {
    current_color = getComputedStyle(this).getPropertyValue("background-color");
    match = /rgba?\((\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*\d+[\.\d+]*)*\)/g.exec(current_color);
    a = a > 1 ? (a / 100) : a;
    this.style.backgroundColor = "rgba(" + [match[1], match[2], match[3], a].join(',') + ")";
};


// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
window.appPaused = false;
window.msgTouchToResume = "Touch to resume";
function onAppPause() {

    var TAG = arguments.callee.name + "(): ";
    log(TAG);

    window.appPaused = true;

    // Unregister the BR
    if (devicereadyStatus) {
        log(TAG + "Unregistering the BroadcastReceiver...");
        window.unregisterBR(function(){
            log(TAG + "Success: BroadcastReceiver Unregistered successfully!");
        },
        function(){
            log(TAG + "ERROR: BroadcastReceiver NOT unregistered");
        });

        if (window.enableAF) {
            // Release the AF in case playing audio
            if (loggingON)
                console.log('Releaseing AF..');
            window.releaseAudioFocus(releaseAFSuccess, releaseAFError);
        }
    }

    //Deregister for updates if service if running
    if(devicereadyStatus){
                	myService.getStatus(function(r) {
                	    if(r.RegisteredForUpdates){
                	            log(TAG + "Registered for updates...so DEREGISTER updates...");
                                myService
                                			.deregisterForUpdates(
                                					function(r) {
                                						    log(TAG + "Deregistered for updates successfully!");
                                						    //updateView(r);
                                						},
                                				    function(e) {
                                						    log(TAG + "***** Deregister updates error! *****");
                                						    handleError(e);
                                                        }
                                               );
                          }
                          else{
                            log(TAG + "Not registered for updates");
                          }

                	    }
                	 , function(e) {
                		handleError(e);
                	});

      }


    //For AdMob
    if(LITE){
        if (isAppForeground) {
                log(TAG + "admob.destroyBannerView()");
                admob.destroyBannerView();
                isAppForeground = false;
         }
    }
}
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
function onAppResume() {

    var TAG = arguments.callee.name +"(): ";
    log("*************"+TAG + "**************");

    window.appPaused = false;

    if (devicereadyStatus) {
        // Check for vol change
        VolumeControl.getVolume(getVolSuccess, getVolError);

        // Register the BR
        log(TAG + 'Registering the BroadcastReceiver...');
        window.registerBR(BRSuccessCallback, function(){
            log(TAG + "ERROR: BroadcastReceiver NOT Registered");
        });

        // Start the TTS in case stopped due to TTS settings
        // window.plugins.tts.startup(startupWin, failStartup);
    }


    checkIfServiceIsRunning();

    if(LITE){
        if (!isAppForeground) {
                log(TAG + "admob.createBannerView()");
                setTimeout(admob.createBannerView, 1);

//                setTimeout(admob.requestInterstitialAd, 1);
                isAppForeground = true;
        }
    }
}



function BRSuccessCallback(msg){
    var TAG = arguments.callee.name + "(): ";
    log(TAG + "Message is: " + msg);
    if(msg == "msg_success"){
        log(TAG + "Succes: BroadcastReceiver registered successfully!");
    }
    else if(msg == "msg_volume_changed"){
        log(TAG + "Calling onDeviceVolChanged()");
        onDeviceVolChanged();
    }
    else if(msg == "msg_service_started"){
        log(TAG + "TODO: msg_service_started");
        log(TAG + "Calling checkIfServiceIsRunning()");
        checkIfServiceIsRunning();
    }
    else if(msg == "msg_service_ended"){
        log(TAG + "TODO: msg_service_started");
        log(TAG + "Going back to mainPage");
        stopService();
//        goToMainPage("none", 0);
    }
}
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
function onBackKeyDown() {
 //alert("onBackKeyDown");
    if (window.mainPageON) {

        if (prefOn)
            hidePrefs();

       else {
            navigator.app.exitApp();
            console.log("navigator.app.exitApp ");
            // if (gaPlugin != null)
            // gaPlugin.exit(function() {
            // if (loggingON)
            // console.log("exited GA..exiting app");
            // navigator.app.exitApp();Tracked screen ̰
            // }, function() {
            // if (loggingON)
            // console.log("GA exit error");
            // });
            // else {
            // navigator.app.exitApp();
            // }
        }

    } else {

        if (prefOn2)
            hidePrefs2();

        else if (touchDisableDivON) {
            // do nothing since back key is disabled
        } else if ($(":mobile-pagecontainer").pagecontainer("getActivePage")[0].id == 'countPage') {// CountPage
            // shown

            // Stop the service
            if (loggingON)
                console.log("Stopping service....");
            stopService();

        } else {
        console.log("navigator.app.backHistory");
            navigator.app.backHistory();
        }
    }
}
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------------------------------------
function vibrateTick(){
    if(devicereadyStatus){
        window.vibrateOnPickerInputChange();
    }
    else{
        console.log("vibrate!! => disabled");
    }
}