varying highp vec2 textureCoordinate;
precision mediump float;

uniform sampler2D inputImageTexture;

void main()
{
      vec4 color = texture2D(inputImageTexture, textureCoordinate);
      float colorR = (1.0 - color.r) / 1.0;
      float colorG = (1.0 - color.g) / 1.0;
      float colorB = (1.0 - color.b) / 1.0;
      gl_FragColor = vec4(colorR, colorG, colorB, color.a);;
}