varying highp vec2 textureCoordinate;
precision mediump float;

uniform sampler2D inputImageTexture;

const float PI = 3.1415926535;

void main()
{
      float aperture = 178.0;
      float apertureHalf = 0.5 * aperture * (PI / 180.0);
      float maxFactor = sin(apertureHalf);

      vec2 uv;
      vec2 xy = 2.0 * textureCoordinate - 1.0;
      float d1 = length(xy);
      if (d1 < (2.0-maxFactor))
      {
        d1 = length(xy * maxFactor);
        float z = sqrt(1.0 - d1 * d1);
        float r = atan(d1, z) / PI;
        float phi = atan(xy.y, xy.x);

        uv.x = r * cos(phi) + 0.5;
        uv.y = r * sin(phi) + 0.5;
      }
      else
      {
        uv = textureCoordinate;
      }
      vec4 c = texture2D(inputImageTexture, uv);

      gl_FragColor = c;;
}