var debug = window.Android == undefined;
var videoObserver = null;

function findVideo() {
    var video = document.querySelector('iframe').contentWindow.document.querySelector('video');
    if (video) {
        if (!extractVideoSourceUrl(video)) {
            observeVideoElement(video);
        };
    };
};

function observeVideoElement(video) {
    if (videoObserver == null) {
        videoObserver = new MutationObserver(mutationRecords => {
            mutationRecords.forEach(mutationRecord => {
                extractVideoSourceUrl(mutationRecord.target);
            });
        });
        videoObserver.observe(video, { attributes: true, childList: true, characterData: true });
    };
};

function extractVideoSourceUrl(videoElement) {
    var rv = false;
    if (videoElement.getAttribute('src') != null) {
        if (videoElement.getAttribute('src').startsWith('http') && videoElement.getAttribute('src').match(/banner/) == null) {
            postStreamInfo(videoElement.getAttribute('src'));
            rv = true;
        };
    };
    return rv;
};

function postStreamInfo(videoSourceUrl) {
    var streamInfo = createStreamInfo(videoSourceUrl);
    if (streamInfo.title == null || streamInfo.title == '') { streamInfo.title = location.hostName };
    !debug ? window.Android.getStreamInfo(JSON.stringify(streamInfo), false) : null;
};

function createStreamInfo(url) {
    var streamInfo = {
        title: null,
        thumbUrl: null,
        duration: null,
        contentId: window.location.href.match(/video\/(\w+)(\?.+)?$/) ? window.location.href.match(/video\/(\w+)(\?.+)?$/)[1] : null,
        hostName: window.location.hostname,
        locationUrl: window.window.location.href,
        streams: [
            {width: 0, height: 0, mimeType: 'video/mp4', quality: null, streamType: 'VIDEO', codecs: null, segments: [[url, 0]]}
        ]
    };
    document.querySelectorAll("meta[property^=og]").forEach(el => {
        if (el.getAttribute('property') == 'og:title') { streamInfo.title = el.getAttribute('content'); };
        if (el.getAttribute('property') == 'og:image') { streamInfo.thumbUrl = el.getAttribute('content'); };
    });
    return streamInfo;
};

findVideo();