var debug = window.Android == undefined;

function getButton() {
    var btn = document.createElement('button');
    btn.type = 'button';
    btn.name = 'dl';
    btn.innerHTML = 'Download';
    btn.style.cssText = 'position: absolute; bottom: 10px; right: 10px; width: 30%; height: 20%; z-index: 9999; background-color: #0ae; color: #fff; font-size: 1rem';
    return btn;
};

async function fetchJson(url) {
    var resp = await fetch(url);
    var json = await resp.json();
    return json;
};

function findVideo() {
    document.querySelectorAll('div.player[data-config-url]').forEach( el => {
        el.querySelectorAll('button[name=dl]').forEach(btn => btn.remove());
        var btn = getButton();
        btn.onclick = () => {
            (async () => {
                var streamInfo = {
                    title: "",
                    thumbUrl: null,
                    hostName: null,
                    contentId: null,
                    locationUrl: window.window.location.href,
                    streams: []
                };
                var configUrl = el.getAttribute('data-config-url');
                var configJson = await fetchJson(configUrl);
                streamInfo.title = configJson.video.title;
                streamInfo.thumbUrl = configJson.video.thumbs['640'] ? configJson.video.thumbs['640'] : null;
                streamInfo.hostName = window.location.hostname;
                streamInfo.contentId = el.getAttribute('data-clip-id');
                var defaultCdn = configJson.request.files.dash.default_cdn;
                var masterUrl = configJson.request.files.dash.cdns[defaultCdn].url;
                var masterJson = await fetchJson(masterUrl);
                for (var p of ['video', 'audio']) {
                    for (var i of masterJson[p]) {
                        var stream = {
                            width: i.width ? i.width : 0,
                            height: i.height ? i.height : 0,
                            duration: i.duration ? i.duration : 0,
                            mimeType: i.mime_type ? i.mime_type : 0,
                            segments: []
                        };
                        var baseUrl = masterUrl.split('/sep/video')[0] + '/sep/video/' + i.base_url;
                        for (var s of i.segments) {
                            stream.segments.push([baseUrl + s.url, s.size]);
                        };
                        streamInfo.streams.push(stream);
                    };
                };
                window.Android ? window.Android.getJavascriptString(JSON.stringify(streamInfo)) : null;
            })();
        };
        el.appendChild(btn);
    });
};

findVideo();

var observeNode = document.querySelector('head');
var observeConfig = { attributes: true, childList: true, subtree: true };
var observeCallback = function (mutationList, observer) {
    for (mut of mutationList) {
        findVideo();
    }
};
var observer = new MutationObserver(observeCallback);
observer.observe(observeNode, observeConfig);