if (MUTATION_OBSERVED == undefined) {
  var observerCallback = (mutationList, observer) => {
    for (const mutation of mutationList) {
      if (mutation.type === "childList" && mutation.addedNodes.length) {
        if (mutation.target.tagName == "MAIN") {
          document.querySelector("input#id_url").value = youtubeUrl;
          document.querySelector("input#id_url").dispatchEvent(new InputEvent("input", { isTrusted: true, bubbles: true, inputType: "insertFromPaste" }));
        }
      }
    }
  };
  var observer = new MutationObserver(observerCallback);
  observer.observe(document.querySelector("body"), { attributes: true, childList: true, subtree: true });
  var MUTATION_OBSERVED = true;
};


if (XHR_REPLACED == undefined) {
  (function () {
    var XHR = XMLHttpRequest.prototype;
    var open = XHR.open;
    var send = XHR.send;
    XHR.open = function (method, url) {
      this._method = method;
      this._url = url;
      return open.apply(this, arguments);
    };
    XHR.send = function (postData) {
      this.addEventListener("load", function () {
        if (this._url == "https://api.ssyoutube.com/api/convert" && this._method == "POST") {
          const parseStreamInfo = (data) => {
            let streamInfo = {
              title: data.meta.title,
              thumbUrl: data.thumb,
              contentId: null,
              hostName: null,
              locationUrl: data.meta.source,
              streams: []
            };
            if (data.hosting !== "101") {
              data.url.forEach(url => {
                if (url.type == "mp4") {
                  streamInfo.streams.push({
                    width: 0,
                    height: 0,
                    duration: data.timestamp,
                    mimeType: "video/mp4",
                    quality: null,
                    bandwidth: null,
                    streamType: "VIDEO",
                    segments: [[url.url, 0]]
                  })
                }
              });
            } else {
              data.url.forEach(url => {
                if (url.downloadable) {
                  streamInfo.streams.push({
                    width: parseInt({
                      "4320": "7680x4320" /*8k*/,
                      "2160": "3840x2160" /*4k*/,
                      "1440": "2560x1440" /*2k*/,
                      "1080": "1920x1080",
                      "720": "1280x720",
                      "480": "854x480",
                      "360": "640x360",
                      "240": "426x240"
                    }[url.quality].split('x')[0]
                    ),
                    height: parseInt(url.quality),
                    duration: 0,
                    mimeType: "video/mp4",
                    quality: url.quality,
                    codecs: url.type,
                    bandwidth: null,
                    streamType: "VIDEO", /* AUDIO_ONLY|VIDEO_ONLY|null */
                    segments: [[url.url, 0]]
                  })
                }
              });
            }
            return streamInfo
          };

          let jsonParsed = JSON.parse(this.responseText);
          let streamInfo = jsonParsed.hasOwnProperty('length') ? parseStreamInfo(jsonParsed[0]) : parseStreamInfo(jsonParsed);
          window.Android ? window.Android.getStreamInfo(JSON.stringify(streamInfo), true) : console.log(streamInfo);
        };
      });
      return send.apply(this, arguments);
    };
  })();
  var XHR_REPLACED = true;
}