var debug = window.Android == undefined;
var videoObserver = null;
var titleObserver = null;
var m3u8Detected = false;

function findVideo() {
    var video = document.querySelector('video');
    if (video) {
        if (!extractVideoSourceUrl(video)) {
            observeVideoElement(video);
        };
    }
};

function observeVideoElement(video) {
    if (videoObserver == null) {
        var videoObserver = new MutationObserver(mutationRecords => {
            if (!m3u8Detected) {
                mutationRecords.forEach(mutationRecord => {
                    extractVideoSourceUrl(mutationRecord.target);
                });
            }
        });
        videoObserver.observe(video, { attributes: true, childList: true, characterData: true });
    }
};

function extractVideoSourceUrl(videoElement) {
    var rv = false;
    if (videoElement.getAttribute('src') != null) {
        if (videoElement.getAttribute('src').startsWith('http') && videoElement.getAttribute('src').match(/banner/) == null) {
            postStreamInfo(videoElement.getAttribute('src'));
            rv = true;
        };
    };
    return rv;
};

function postStreamInfo(videoSourceUrl) {
    var streamInfo = createStreamInfo(videoSourceUrl);
    if (streamInfo.title == null || streamInfo.title == '') { streamInfo.title = location.hostName };
    !debug ? window.Android.getStreamInfo(JSON.stringify(streamInfo), false) : null;
};

function createStreamInfo(url) {
    var streamInfo = {
        title: null,
        thumbUrl: null,
        duration: null,
        contentId: window.location.href.match(/video\/(\w+)(\?.+)?$/) ? window.location.href.match(/video\/(\w+)(\?.+)?$/)[1] : null,
        hostName: window.location.hostname,
        locationUrl: window.window.location.href,
        streams: [
            {width: 0, height: 0, mimeType: 'video/mp4', quality: null, streamType: 'VIDEO', codecs: null, segments: [[url, 0]]}
        ]
    };
    document.querySelectorAll("meta[property^=og]").forEach(el => {
        if (el.getAttribute('property') == 'og:title') { streamInfo.title = el.getAttribute('content'); };
        if (el.getAttribute('property') == 'og:image') { streamInfo.thumbUrl = el.getAttribute('content'); };
    });
    return streamInfo;
};

if (titleObserver == null) {
    var titleCurrent = document.querySelector('title')?.textContent ?? null;
    titleObserver = new MutationObserver(mutationRecords => {
        if (!m3u8Detected) {
            mutationRecords.forEach(mutationRecord => {
                titleNew = mutationRecord.target.textContent;
                if (titleCurrent != titleNew) {
                    !debug ? window.Android.clearStreamInfoList() : null;
                    findVideo();
                };
            });
        }
    });
    var targetNode = document.querySelector('title');
    var config = { attributes: true, childList: true, characterData: true };
    if (targetNode) {
        titleObserver.observe(targetNode, config);
    }
}

window.addEventListener('DOMContentLoaded', (event) => {
    findVideo();
});

