var debug = window.Android == undefined;

function findVideo() {
    var video = null;
    try {
        var array = Array.from(document.querySelectorAll('video[src^=http]'))?.filter(el => el.src.match('banner') == null);
        if (array && array.length > 0) { video = array[0] };
    } catch(e) {};
    if (video) {
        if (!extractVideoSourceUrl(video)) {
            observeVideoElement(video);
        };
    }
};


function observeVideoElement(video) {
    new MutationObserver(mutationRecords => {
        mutationRecords.forEach(mutationRecord => {
            extractVideoSourceUrl(mutationRecord.target);
        });
    }).observe(video, { attributes: true, childList: true, characterData: true });
};

function extractVideoSourceUrl(videoElement) {
    var rv = false;
    if (videoElement.getAttribute('src') != null) {
        if (videoElement.getAttribute('src').startsWith('http')) {
            postStreamInfo(videoElement.getAttribute('src'));
            rv = true;
        };
    };
    return rv;
};

function postStreamInfo(videoSourceUrl) {
    var streamInfo = createStreamInfo(videoSourceUrl);
    if (window.location.href.match(/imdb\.com\/video\//) != null) {
        fetch(window.location.href)
            .then(response => response.text())
            .then(text => {
                const parser = new DOMParser();
                const htmlDocument = parser.parseFromString(text, "text/html");
                htmlDocument.documentElement.querySelectorAll("meta[property^=og]").forEach(el => {
                    if (el.getAttribute('property') == 'og:title') { streamInfo.title = el.getAttribute('content');};
                    if (el.getAttribute('property') == 'og:image') { streamInfo.thumbUrl = el.getAttribute('content');};
                });
                !debug ? window.Android.clearStreamInfoList() : null;
                if (streamInfo.title == null || streamInfo.title == '') { streamInfo.title = location.hostName };
                !debug ? window.Android.getStreamInfo(JSON.stringify(streamInfo), false) : null;
            });
    } else {
        if (streamInfo.title == null || streamInfo.title == '') { streamInfo.title = location.hostName };
        !debug ? window.Android.getStreamInfo(JSON.stringify(streamInfo), false) : null;
    }
};

function createStreamInfo(url) {
    var streamInfo = {
        title: null,
        thumbUrl: null,
        duration: null,
        contentId: window.location.href.match(/video\/(\w+)(\?.+)?$/) ? window.location.href.match(/video\/(\w+)(\?.+)?$/)[1] : null,
        hostName: window.location.hostname,
        locationUrl: window.window.location.href,
        streams: [
            {width: 0, height: 0, mimeType: 'video/mp4', quality: null, streamType: 'VIDEO', codecs: null, segments: [[url, 0]]}
        ]
    };
    document.querySelectorAll("meta[property^=og]").forEach(el => {
        if (el.getAttribute('property') == 'og:title') { streamInfo.title = el.getAttribute('content'); };
        if (el.getAttribute('property') == 'og:image') { streamInfo.thumbUrl = el.getAttribute('content'); };
    });
    return streamInfo;
};


if (observer == undefined) {
    var observer = new MutationObserver(mutationRecords => {
        !debug ? window.Android.clearStreamInfoList() : null;
        setTimeout(function() { findVideo() }, 500);
    });
    var targetNode = document.querySelector('h3#video-title');
    var configL = { attributes: true, childList: true, subtree: true, characterData: true };
    var configS = { attributes: true, childList: true, characterData: true };
    if (targetNode) {
        observer.observe(targetNode, configL);
    }
}

!debug ? window.Android.clearStreamInfoList() : null;
findVideo();