var debug = window.Android == undefined;
var videoObserver = null;
var m3u8Detected = false;

var findVideo = (title) => {
    var videoList = [];
    var videoEl = document.querySelector('video[src^=https][class=""]');
    if (videoEl) {
        var streamInfo = {
            title: title,
            thumbUrl: null,
            duration: null,
            contentId: window.location.href.match(/video\/(\w+)(\?.+)?$/) ? window.location.href.match(/video\/(\w+)(\?.+)?$/)[1] : null,
            hostName: window.location.hostname,
            locationUrl: window.window.location.href,
            streams: [
                {width: 0, height: 0, mimeType: 'video/mp4', quality: null, streamType: 'VIDEO', codecs: null, segments: [[videoEl.getAttribute('src'),0]]}
            ]
        };
        document.querySelectorAll("meta[property^=og]").forEach(el => {
            if (el.getAttribute('property') == 'og:title') {
                streamInfo.title = el.getAttribute('content');
            };
            if (el.getAttribute('property') == 'og:image') {
                streamInfo.thumbUrl = el.getAttribute('content');
            };
        });
        console.log(JSON.stringify(streamInfo));
        if (streamInfo.title == null || streamInfo.title == '') { streamInfo.title = location.hostName };
        if (!debug) { window.Android.getStreamInfo(JSON.stringify(streamInfo), false) };
    } else {
        console.log('not found video element');
    };
};


if (videoObserver == null) {
    var targetNode = document.querySelector('video');
    var config = { attributes: true, childList: true, characterData: true };
    if (targetNode) {
        videoObserver = new MutationObserver(mutationRecords => {
            if (!m3u8Detected) {
                mutationRecords.forEach(mutationRecord => {
                    debug ? console.log(mutationRecord) : null;
                    if (mutationRecord.target.classList == "") {
                        !debug ? window.Android.clearStreamInfoList() : null;
                        findVideo();
                    }
                });
            };
        });
        videoObserver.observe(targetNode, config);
    }
}

findVideo();

