var debug = window.Android == undefined;
var bodyObserver = null;

function xmlToJson(xml) {
    var obj = {};
    if (xml.nodeType == 1) { /* element */
        /* do attributes */
        if (xml.attributes.length > 0) {
            obj['@attributes'] = {};
            for (var j = 0; j < xml.attributes.length; j++) {
                var attribute = xml.attributes.item(j);
                obj['@attributes'][attribute.nodeName] = attribute.nodeValue;
            }
        }
    } else if (xml.nodeType == 3) { /* text */
        obj = xml.nodeValue;
    }
    /* do children */
    if (xml.hasChildNodes()) {
        for (var i = 0; i < xml.childNodes.length; i++) {
            var item = xml.childNodes.item(i);
            var nodeName = item.nodeName;
            if (typeof (obj[nodeName]) == 'undefined') {
                obj[nodeName] = xmlToJson(item);
            } else {
                if (typeof (obj[nodeName].push) == 'undefined') {
                    var old = obj[nodeName];
                    obj[nodeName] = [];
                    obj[nodeName].push(old);
                }
                obj[nodeName].push(xmlToJson(item));
            }
        }
    }
    return obj;
};

function fbMpdReprToStream(repr) {
    var stream = {width: 0, height: 0, mimeType: null, quality: null, codecs: null, bandwidth: null, streamType: null, segments: []};
    stream.width = repr['@attributes'].width || 0;
    stream.height = repr['@attributes'].height || 0;
    stream.mimeType = repr['@attributes'].mimeType || null;
    stream.quality = repr['@attributes'].FBQualityLabel || null;
    stream.codecs = repr['@attributes'].codecs || null;
    stream.bandwidth = repr['@attributes'].bandwidth || null;
    stream.streamType = stream.mimeType.startsWith('audio') ? 'AUDIO_ONLY' : 'VIDEO_ONLY';
    var baseUrl = repr.BaseURL['#text'];
    var regex = /(\d+)-(\d+)/;
    var replaced = '&bytestart=$1&byteend=$2';
    stream.segments.push([baseUrl + repr.SegmentBase.Initialization['@attributes'].range.replace(regex, replaced), 0]);
    var ordinalList = ['indexRange', 'FBFirstSegmentRange', 'FBSecondSegmentRange', 'FBThirdSegmentRange', , 'FBFourthSegmentRange'];
    for (var ordinal of ordinalList) {
        if (repr.SegmentBase['@attributes'].hasOwnProperty(ordinal)) {
            stream.segments.push([baseUrl + repr.SegmentBase['@attributes'][ordinal].replace(regex, replaced), 0]);
        }
    };
    return stream;
};

async function fetchJson(url) {
    var resp = await fetch(url);
    var json = await resp.json();
    return json;
};

function getButton() {
    var btn = document.createElement('button');
    btn.type = 'submit';
    btn.name = 'dl';
    btn.style.cssText = 'position: absolute; bottom: 10px; right: 10px; width: 56px; height: 56px; padding: 0; margin: 0; z-index: 9; background: url("data:image/png;base64,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"); background-size: cover; border-radius: 50%; border: none; border: none; outline: 0 none;';
    return btn;
};

function findImage() {
    document.querySelectorAll('article img[style^=object-fit]').forEach( el => {
        var isLink = false;
        if (el.closest('a') != null) {
            if (el.closest('a').href.match(/instagram.com\/p\//) != null) {
                isLink = true
            }
        }
        if (!isLink) {
            var btn = getButton();
            btn.onclick = () => {
                var imageUrl = el.src.split(',')[el.src.split(',').length-1].split(' ')[0];
                !debug ? window.Android.getImageUrl(imageUrl) : null;
            };
            if (el.parentElement.querySelector('button[name=dl]') == null) {
                el.parentElement.appendChild(btn);
            };
        }
    });
};

function findVideo() {
    document.querySelectorAll('video').forEach( el => {
        el.querySelectorAll('button[name=dl]').forEach(btn => btn.remove());
        var btn = getButton();
        var noDownload = false;
        btn.onclick = () => {
            (async () => {
                if (noDownload) { return false };
                var contentId = Array.from(el.closest('article').querySelectorAll('a')).filter(a => a.getAttribute('href').match(/^\/p\/.*/) !== null)[0].getAttribute('href').split('/')[2];
                var streamInfo = {
                    title: "",
                    thumbUrl: null,
                    duration: null,
                    contentId: contentId,
                    hostName: null,
                    locationUrl: window.window.location.href,
                    streams: []
                };
                var json = await fetchJson('https://www.instagram.com/p/' + contentId + '/?__a=1');
                if (json.graphql.shortcode_media) {
                    streamInfo.thumbUrl = json.graphql.shortcode_media.display_resources[0].src;
                    json.graphql.shortcode_media.title ? streamInfo.title = json.graphql.shortcode_media.title : null;
                };
                if (streamInfo.title == "") {
                    var m_ = document.title.match(/“(.*)”/); m_ && m_.length > 1 ? streamInfo.title = m_[1] : null;
                };
                streamInfo.hostName = document.location.hostname;
                if (el.getAttribute('src') && !el.getAttribute('src').startsWith('blob')) {
                    streamInfo.streams.push(
                        {width: null, height: null, mimeType: "video/mp4", quality: null, streamType: 'VIDEO', codecs: null, segments: [[el.getAttribute('src'), 0]]}
                    );
                };
                try {
                    var dashManifest = xmlToJson((new DOMParser()).parseFromString(json.graphql.shortcode_media.dash_info.video_dash_manifest, 'text/xml'));
                    if (Array.isArray(dashManifest.MPD.Period.AdaptationSet)) {
                        dashManifest.MPD.Period.AdaptationSet.forEach(adaptSet => {
                            if (adaptSet.Representation.length > 1) {
                                for (var repr of adaptSet.Representation) {
                                    streamInfo.streams.push(fbMpdReprToStream(repr));
                                };
                            } else {
                                streamInfo.streams.push(fbMpdReprToStream(adaptSet.Representation));
                            };
                        });
                    } else {
                        for (var repr of dashManifest.MPD.Period.AdaptationSet.Representation) {
                            streamInfo.streams.push(fbMpdReprToStream(repr));
                        };
                    };
                } catch (error) {
                }
                if (streamInfo.title == null || streamInfo.title == '') { streamInfo.title = location.hostName };
                window.Android ? window.Android.getStreamInfo(JSON.stringify(streamInfo), true) : console.log(streamInfo);
            })();
        };
        el.parentElement.appendChild(btn);
    });
}

findVideo();
findImage();

if (bodyObserver == null) {
    var observeNode = document.querySelector('body');
    var observeConfig = { attributes: false, childList: true, subtree: true };
    var observeCallback = function (mutationList, observer) {
        if (window.location.href.match(/instagram.com\/$/) != null ||
            window.location.href.match(/instagram.com\/p\/[\w\-]+\//) != null ||
            window.location.href.match(/instagram.com\/reel\/[\w\-]+\/$/) != null ||
            window.location.href.match(/instagram.com\/tv\/[\w\-]+\/$/) != null ||
            window.location.href.match(/instagram.com\/[\w\-]+\/feed\/$/) != null
            ) {
            var toFind = false;
            for (mut of mutationList) {
                for (node of mut.addedNodes) {
                    if (node.localName == 'article') {
                        toFind = true;
                    } else if (node.localName == 'section') {
                        toFind = true;
                    } else if (node.localName == 'li') {
                        if ( node.querySelector('img[style^=object]') != null || node.querySelector('video') != null) {
                            toFind = true;
                        };
                    };
                };
            };
            if (toFind) { findVideo(); findImage(); };
        };
    };
    var observer = new MutationObserver(observeCallback);
    observer.observe(observeNode, observeConfig);
}