(function(){
    if (window.fas_isInjectedPlugin) return;
    window.fas_isInjectedPlugin = true;

    class AjaxPlugin {
        constructor() {
            this.handleJSONResponse = null
            this.handleSend = null
        }
        setHandleSend(handler) {
            // console.debug("[AJAX] setHandleSend", handler)
            this.handleSend = function(xmlhttpRequest) {
                var r =  handler(xmlhttpRequest)
                // console.debug("[AJAX] send Handler",xmlhttpRequest, r )
                return r
            }
        }
        setHandleJSONResponse(handler) {
            // console.debug("[AJAX] setHandleJSONResponse", handler)
            this.handleJSONResponse = function(json,responseURL) {
                // console.debug("[AJAX] JSON Response handler",responseURL, json)
                return handler(json,responseURL)
            }
        }
        activate() {
            var self = this;
            (function(open) {
                XMLHttpRequest.prototype.open = function() {
                    // console.debug("XMLHTTPRequest.prototype.open", arguments)
                    this.fas_openArgs = arguments
                    open.apply(this, arguments)
                }
            }) (XMLHttpRequest.prototype.open);
            (function(send) {
                XMLHttpRequest.prototype.send = function (body) {
                    this["fas_body"] = body
                    // Object.defineProperty(this, 'responseText', {writable: true});
                    var callback = this.onreadystatechange
                    this.onreadystatechange = function() {
                        if (self.handleJSONResponse != null && this.readyState == 4) {
                            try {
                                // console.debug("ajax:",this.responseURL)
                                var responseType = this.getResponseHeader("Content-Type");
                                if (responseType && (responseType.indexOf("application/json")==0 || responseType.indexOf("application/x-javascript") == 0)){
                                    var json = this.response;
                                    var prefix = "for (;;);";
                                    if (json.indexOf(prefix) == 0){
                                        json = json.substring(prefix.length)
                                    }
                                    var newResponse = self.handleJSONResponse(JSON.parse(json), this.responseURL);

                                    if (newResponse) {
                                        Object.defineProperty(this, 'responseText', {
                                            writable: true
                                        });
                                        // console.debug("JSON Ajax",this.responseURL, JSON.parse(newResponse));
                                        // console.debug("overriding response text",newResponse);
                                        this.responseText = newResponse;
                                        // console.debug("toto",this.responseText)
                                    }
                                }
                            }catch(ex){
                                // console.error("error parsing response",ex);
                            }
                        }
                        if (callback) {
                            callback.apply(this, arguments)
                        }
                    }

                    if (self.handleSend != null) {
                        var shouldRunSend = self.handleSend(this)
                        // console.debug("[AJAX SEND] shouldRunSend", shouldRunSend)
                        if (!shouldRunSend) {
                            // console.debug("[AJAX] should not run send")
                            return
                        }
                    }


                    send.apply(this, arguments)
               }
            }(XMLHttpRequest.prototype.send));
            console.debug("[AJAX] activated")
        }
    }
    window._fas_ajaxplugin = new AjaxPlugin()
    _fas_ajaxplugin.activate()
  })();