(function() {
    try {

        function getUnreadMessagesCount() {
            try {
                var unreadCount = ow_jQuery('div[aria-label^="Messenger,"]').text();
                return  parseInt(unreadCount);
            } catch (ex) {
                console.error("[FB Modern]", ex)
                return 0;
            }
        }

        function getNotificationsCount() {
            try {
                var notificationsCount = ow_jQuery('div[aria-label^="Notifications,"]').text();
                return parseInt(notificationsCount);
            } catch (ex) {
                console.error("[FB Modern]", ex)
                return 0;
            }
        }

        function parseNotification() {
            // Check if div aria-label="Notifications" exists
            var notificationsDiv = ow_jQuery("div[aria-label='Notifications']")
            var notifications = [];
            if (notificationsDiv) {
                // Remove the first row header which contains a <a> tag
                notificationsDiv.find("div[role='rowheader']").remove()
                // Select each notification
                notificationsDiv.find('a').each(function() {
                    try {
                        if (ow_jQuery(this).find('.x179tack').length == 0)
                           return; // Skip if no unread div

                        // remove to avoid unwanted text
                        ow_jQuery(this).find('.x179tack').remove();

                        var data = ow_jQuery(this).find('span').first()//.text();
                        var title = data.text();
                        var url = ow_jQuery(this).attr('href');
                        var author = data.find('strong').first().text();
                        var pictureUrl = ow_jQuery(this).find('svg image').attr('xlink:href');

                        // If url is https://www.facebook.com, transform it to https://m.facebook.com with a regex
                        if (url && url.startsWith("https://www.facebook.com")) {
                            url = url.replace(/www.facebook.com/g, "m.facebook.com");
                        }

                        // If a title is found, add it to the titles array
                        if (title && url) {
                            notifications.push({
                                url: url,
                                title: title,
                                author: author,
                                pictureUrl: pictureUrl
                            });
                        }
                    } catch (ex) {
                        console.error("[NotificationHeadless]", ex)
                    }
                });
                console.log("------ NotificationHeadless JS -----");
                console.log("------ NotificationHeadless Before Slice", notifications);

                // Only take notification from notification badge
                var notificationsCount = getNotificationsCount();
                notifications = notifications.slice(0, notificationsCount);
                console.log("------ NotificationHeadless After Slice", notifications);

                if (notifications.length > 0) {
                    _fas_.sendNotification(JSON.stringify(notifications));
                }
            }
        }

        function parseMessage(badgeCount) {
            var messageDiv = ow_jQuery("div[aria-label='Messenger']")
            var messages = [];
            if (messageDiv) {
                // Select each notification
                messageDiv.find('a').each(function() {
                    try {
                        var author = ow_jQuery(this).find('span').first().text();
                        var url = ow_jQuery(this).attr('href');
                        var title = ow_jQuery(this).find('span.html-span span').first().text();
                        var pictureUrl = ow_jQuery(this).find('img').attr('src');

                        if (!pictureUrl) {
                            pictureUrl = ow_jQuery(this).find('svg image').attr('xlink:href');
                        }

                        // If url doesn't start with https://, add https://m.facebook.com to the url
                        if (url && !url.startsWith("https://")) {
                            url = "https://m.facebook.com" + url;
                        }

                        // If a title is found, add it to the titles array
                        if (title && url) {
                            messages.push({
                                url: url,
                                title: title,
                                author: author,
                                pictureUrl: pictureUrl
                            })
                        }
                    } catch (ex) {
                        console.error("[MessageHeadless]", ex)
                    }
                });
                console.log("------ MessageHeadless JS -----");
                console.log("------ MessageHeadless Before Slice ", messages.length, messages);

                // Only take message from Messenger badge
                var messagesCount = badgeCount !== undefined ? badgeCount : getUnreadMessagesCount();
                messages = messages.slice(0, messagesCount);
                console.log("------ MessageHeadless After Slice ", messages.length, messages);

                if (messages.length > 0) {
                    _fas_.sendNotificationMessage(JSON.stringify(messages));
                }
            }
        }

        parseNotification();

        // click on the message badge to load the message list before parsing the message after 2s
        var tmpBadgeCount = getUnreadMessagesCount();
        ow_jQuery("div[aria-label='Messenger']").click();
        setTimeout(parseMessage.bind(tmpBadgeCount), 2000);

    } catch (ex) {
        console.error("[NotificationHeadless]", ex)
    }

})();