(function() {

    console.debug("Instagram shim (in shims.js)");

    if (window.fas_isInjectedAds) return;
    window.fas_isInjectedAds = true;

    var _ = {
        defineQueue: []
    }

    _.defineAndRequire = function(moduleName, dependencies, fn, callback) {
        try {
            if (_.ow_define === undefined) {
                _.defineQueue.push([moduleName, dependencies, fn, callback])
            } else {
                _.ow_define(moduleName, dependencies, fn);
                requireLazy([moduleName], function() {
                    console.debug("[OW_DEFINED] defineAndRequire requireLazy", moduleName, arguments);
                    if (callback) {
                        callback();
                    }
                })
            }
        } catch (ex) {
            console.debug("[OW_DEFINED] defineAndRequire moduleName", moduleName);
            console.debug("[OW_DEFINED] defineAndRequire", ex);
        }
    }

    function feedTimelineConnectionAdFilter(json) {
        //console.debug("[RelayPrefetchedStreamCache] feedTimelineConnectionAdFilter", json)
        if (!(json && json.data && json.data.xdt_api__v1__feed__timeline__connection)) {
            return json
        }
        var { data: { xdt_api__v1__feed__timeline__connection: timelinejson }} = json
        var initialFeedTimelineConnection = json
        var initialTimelinejson = timelinejson
        console.debug("[ADFILTER] initial timelinejson", initialTimelinejson)
        // timelinejson has the format:
        // { edges: [ {node:{ ..., ad: { ... }, ...}, cursor: "..."}], page_info: { ... } }
        // we need to remove the elements from edges where the node's ad is defined
        if (timelinejson && timelinejson.edges) {
            var edges = timelinejson.edges
            var newEdges = []
            var removedEdges = []
            edges.forEach(function(edge){
                if (edge.node && edge.node.ad) {
                    console.debug("[ADFILTER] removing ad", edge)
                    removedEdges.push(edge)
                } else {
                    newEdges.push(edge)
                }
            })
            timelinejson.edges = newEdges
            timelinejson.removedEdges = removedEdges
        }
        json.data.xdt_api__v1__feed__timeline__connection = timelinejson
        console.debug("[ADFILTER] modified feedTimelineConnection", json)
        return json
    }
    // overriding JSON.parse to filter out ads from the timeline
    var _JSONParse = JSON.parse
    JSON.parse = function(json) {
        try {
            var parsed = _JSONParse(json)
            return feedTimelineConnectionAdFilter(parsed)
        } catch(ex) { }
        return _JSONParse(json)
    }

    // initial RelayPrefetchedStreamCache
    _.defineAndRequire("Friendly_RelayPrefetchedStreamCache", ["RelayPrefetchedStreamCache"], function(module, exports, RelayPrefetchedStreamCache){
        console.debug("[ADFILTER][RelayPrefetchedStreamCache]", RelayPrefetchedStreamCache)
        RelayPrefetchedStreamCache.ow_next = RelayPrefetchedStreamCache.next
        RelayPrefetchedStreamCache.next = function(a,b) {
            try {
                var {result: result} = b
                b.result = feedTimelineConnectionAdFilter(result)
                return RelayPrefetchedStreamCache.ow_next(a,b)
            } catch(ex) {
                console.error("[ADFILTER][RelayPrefetchedStreamCache] error", ex)
            }
            return RelayPrefetchedStreamCache.ow_next(a,b)
        }
    })

    // ad detection
    function parseTimeline(timeline) {
        console.debug("[IG] parsing timeline")
        var feed_items = timeline && (timeline["items"] || timeline["feed_items"])
        if (!feed_items) {
            console.debug("[IG] no feed items")
            /// window.friendlyfied.plugins.AnalyticsWebPlugin.track("IGADFETCH_NOFEEDITEMS_ERROR", {})
            return null;
        }
        var items = []
        feed_items.forEach(function(item){
            try {
                if (media_or_ad = item["media_or_ad"]) {
                    if (ad_id = media_or_ad["ad_id"]) {
                        console.debug("[IG][ADITEM]", item)
                        if (adItems = media_or_ad["items"]) {
                            adItems.forEach((adItem) => {
                                if (adItem["code"] && adItem["id"]) {
                                    var source = adItem["user"] && adItem["user"]["full_name"]
                                    var data = {
                                        adInbox: {
                                            owner:  source,
                                            ownerURL: "https://www.instagram.com/"+adItem["user"]["username"],
                                            avatarURL: adItem["user"]["profile_pic_url"],
                                            body: adItem["caption"] && adItem["caption"]["text"]
                                        }
                                    }
                                    items.push({
                                        visible: false,
                                        url: "https://www.instagram.com/p/"+adItem["code"],
                                        source: source,
                                        data: data
                                    })
                                }
                            })
                        }
                    }
                }
            } catch(ex) {
                console.debug("[IG] parse feed item error", ex)
            }
        })

        console.debug("[IG][AD] 1 sending ads items", items)

        if (items.length > 0) {
            var payload = { "origin": "instagram", "parser": "JS_XHR", "html": "", "ads": items}
            console.debug("[IG][AD] 2 sending ads", payload)
            // window.friendlyfied.defenderWebPlugin.trackDetectedAdsCount(items.length)
            // window.friendlyfied.plugins.AdLogWebPlugin.log(payload)
            _fas_.logNewAdGroup(JSON.stringify(payload), true)
        }
    }

    _.onOwDefined = function() {
        console.debug("[OW_DEFINED] onOwDefined");
        _.defineQueue.forEach(function(item) {
            // console.debug("[OW_DEFINED] lazy call to defineAndRequire", item);
            _.defineAndRequire.call(item);
        })
        _.defineQueue = []
    }

    _.defineOwDefine = function(__d) {
        try {
             _.ow_define = function(moduleName,dependencies,fn){
                __d(moduleName,dependencies,function(global,require,requireDynamic,requireLazy,module,exports,a,b,c,d,e,f,g,h,i,j){
                    try{
                        if (require.__markCompiled) {
                            require.__markCompiled();
                        }
                        var global = arguments[0];
                        var require = arguments[1];
                        var requireDynamic = arguments[2];
                        var requireLazy = arguments[3];
                        var module = arguments[4];
                        var exports = arguments[5];
                        var deps = [module,exports];
                        for (var i=6;i<arguments.length;i++){
                            deps.push(arguments[i]);
                        }
                        // console.debug("[OW_DEFINED] Calling define function ",module,dependencies,deps);
                        fn.apply(null,deps);
                    } catch(ex){
                        console.error("[OW_DEFINED] ow_define", ex);
                    }
                    // console.debug("[OW_DEFINED] Defined",moduleName,module);
                });
            };
            _.onOwDefined();
        } catch(ex) {
            console.error("[OW_DEFINED] defineOwDefine", ex);
        }
    }

    try {
        var self = _;

        if (window.requireLazy != undefined) {
            console.debug("[OW_DEFINED] window.requireLazy already defined")
            self.requireLazy = window.requireLazy
            _.defineOwDefine(window.__d)
        } else {
            console.debug("[OW_DEFINED] window.requireLazy not yet defined")
        }

        window.__defineGetter__("requireLazy", function(){ return self.requireLazy})
        window.__defineSetter__("requireLazy", function(v){
            console.debug("[OW_DEFINED] __defineSetter__ requireLazy", v);
            self.requireLazy = v;
            _.defineOwDefine(window.__d);
        })
    } catch(ex) {
        console.error("[OW_DEFINED] activate", ex);
    }

})();