(function($, exports) {
    console.debug("twitter user script", exports)

    if (typeof(exports) == "undefined") {
        exports = {};
    }

    var DOMScanner = exports.DOMScanner

    window.fas_changeColor = (function() {
        try {
            for (var i = 0; i < document.styleSheets.length; i++) {
                var style = document.styleSheets[i];
                if (style.cssRules !== undefined) {
                    for (var j = 0; j < style.cssRules.length; j++) {
                        var rule = style.cssRules[j];
                        if (rule.style && rule.style.color &&
                            (rule.style.color === "rgb(29, 161, 242)" ||
                                rule.style.color === "rgb(29, 155, 240)" ||
                                rule.style.color === "rgb(27, 149, 224)")) {
                            rule.style.color = window.OW_color["base"];
                        }
                        if (rule.style && rule.style.borderBottomColor &&
                            (rule.style.borderBottomColor === "rgb(29, 161, 242)" ||
                                rule.style.borderBottomColor === "rgb(29, 155, 240)" ||
                                rule.style.borderBottomColor === "rgb(27, 149, 224)")) {
                            rule.style.borderBottomColor = window.OW_color["base"];
                        }
                        if (rule.style && rule.style.borderLeftColor &&
                            (rule.style.borderLeftColor === "rgb(29, 161, 242)" ||
                                rule.style.borderLeftColor === "rgb(29, 155, 240)" ||
                                rule.style.borderLeftColor === "rgb(27, 149, 224)")) {
                            rule.style.borderLeftColor = window.OW_color["base"];
                        }
                        if (rule.style && rule.style.borderRightColor &&
                            (rule.style.borderRightColor === "rgb(29, 161, 242)" ||
                                rule.style.borderRightColor === "rgb(29, 155, 240)" ||
                                rule.style.borderRightColor === "rgb(27, 149, 224)")) {
                            rule.style.borderRightColor = window.OW_color["base"];
                        }
                        if (rule.style && rule.style.borderTopColor &&
                            (rule.style.borderTopColor === "rgb(29, 161, 242)" ||
                                rule.style.borderTopColor === "rgb(29, 155, 240)" ||
                                rule.style.borderTopColor === "rgb(27, 149, 224)")) {
                            rule.style.borderTopColor = window.OW_color["base"];
                        }
                        if (rule.style && rule.style.backgroundColor &&
                            (rule.style.backgroundColor === "rgb(29, 161, 242)" ||
                                rule.style.backgroundColor === "rgb(29, 155, 240)" ||
                                rule.style.backgroundColor === "rgb(27, 149, 224)")) {
                            rule.style.backgroundColor = window.OW_color["base"];
                        }
                        if (rule.style && rule.style.fill &&
                            (rule.style.fill === "rgb(29, 161, 242)" ||
                                rule.style.fill === "rgb(29, 155, 240)" ||
                                rule.style.fill === "rgb(27, 149, 224)")) {
                            rule.style.fill = window.OW_color["base"];
                        }
                        if (rule.style && rule.style.stroke &&
                            (rule.style.stroke === "rgb(29, 161, 242)" ||
                                rule.style.stroke === "rgb(29, 155, 240)" ||
                                rule.style.stroke === "rgb(27, 149, 224)")) {
                            rule.style.stroke = window.OW_color["base"];
                        }
                    }
                }
            }
        } catch (ex) {
            console.debug(ex)
        }
    });

    window.fas_resetScanned = (function() {
        ow_jQuery("article[role=article]").removeClass("ow_scanned")
        ow_jQuery("article[role=article]").removeClass("ow_videoScanned")
    });

    var Main = (function() {
        var _ = {};

        _.scanAllArticlesNew = function() {
            try {
                DOMScanner.scan({
                    onMoreShareVideo: function(v) { _fas_.onMoreShareVideo(v) },
                    onMoreShare: function(v) { console.debug("OnMoreShare:", arguments); _fas_.onMoreShare(v) },
                    shareReport: function(v) { _fas_.shareReport(v) }
                })
            } catch (ex) {
                console.debug(ex)
            }
        };

        _.getVideoURLFromTweets = function(urlToCompare) {
            if (urlToCompare === undefined || urlToCompare === "") {
                return null
            }
            var tmpUrl = null
            window._fas_tweetVideos.forEach(function(tweet) {
                if (tweet.videos !== undefined) {
                    tweet.videos.forEach(function(video) {
                        if (video.media_url_https.indexOf(urlToCompare) !== -1) {
                            var variantVideos = video.video_info.variants
                            variantVideos = variantVideos.filter(function(item) {
                                return item.bitrate !== undefined;
                            })
                            variantVideos = variantVideos.sort(function(a, b) {
                                return b.bitrate - a.bitrate;
                            })
                            tmpUrl = variantVideos[0].url
                        }
                    })
                }
            })
            return tmpUrl
        }

        _.isTweetVideo = function(href) {
            var isVideo = false
            window._fas_tweetVideos.forEach(function(tweet) {
                if (tweet.tweetID !== undefined && href.indexOf(tweet.tweetID) !== -1) {
                    isVideo = true
                }
            })
            return isVideo
        }

        _.scheduleColorChange = (function() {
            window.fas_changeColor();
            setInterval(function() {
                window.fas_changeColor()
            }, 300);
            return _;
        })

        _.insertDownloadPictureButton = function() {
            try {
                var closeSvg = ow_jQuery("svg > g > path[d='M10.59 12L4.54 5.96l1.42-1.42L12 10.59l6.04-6.05 1.42 1.42L13.41 12l6.05 6.04-1.42 1.42L12 13.41l-6.04 6.05-1.42-1.42L10.59 12z']")
                if (closeSvg.size() > 0) {

                    var color = closeSvg.css("color")
                    var picture = ow_jQuery('img[src^="https"]')
                    var isInjected = false
                    var pathName = document.location.pathname

                    if (picture.size() > 0) {
                        var url = picture.attr("src")
                        if (pathName.localeCompare(window._fas_latestPathNameTestedPicture) === 0) {
                            window._fas_tweetPictures.forEach(function(tweet) {
                                if (tweet.pictures !== undefined) {
                                    tweet.pictures.forEach(function(picture) {
                                        try {
                                            if (picture.permaLink.indexOf(pathName) !== -1 &&
                                                picture.media_url_https !== undefined) {
                                                _.downloadButtonHTML("ow_download_picture", color, picture.media_url_https)
                                                //_.downloadManagerButtonHTML(color)
                                                closeSvg.parent().parent().css({
                                                    "right": "1px",
                                                    "bottom": "1px"
                                                })
                                                isInjected = true
                                            }
                                        } catch (ex) {
                                            console.debug(ex)
                                        }
                                    })
                                }
                            })
                        }
                        if (!isInjected)
                            window._fas_latestPathNameTestedPicture = pathName
                    }
                } else {
                    ow_jQuery(".ow_download_picture").hide()
                    ow_jQuery(".ow_download_manager").hide()
                }
            } catch (ex) {
                console.debug(ex)
            }
        }

        _.scanTwitterLogo = function() {
            if (window.OW_hideXLogo === false || window.OW_hideXLogo === undefined) {
                return
            }
            try {
                var twitterLogo = ow_jQuery("svg > g > path[d='M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z']")
                if (twitterLogo.size() > 0) {
                    twitterLogo.attr("d", "M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.669 5.108 1.523 6.574-.806-.026-1.566-.247-2.229-.616-.054 2.281 1.581 4.415 3.949 4.89-.693.188-1.452.232-2.224.084.626 1.956 2.444 3.379 4.6 3.419-2.07 1.623-4.678 2.348-7.29 2.04 2.179 1.397 4.768 2.212 7.548 2.212 9.142 0 14.307-7.721 13.995-14.646.962-.695 1.797-1.562 2.457-2.549z")
                    twitterLogo.css({ fill: OW_color["base"] });
                }
            } catch (ex) {
                console.debug(ex)
            }
        }

        _.downloadButtonHTML = function(className, color, url) {
            var downloadButton = ow_jQuery("." + className)
            if (downloadButton.size() == 0)
                ow_jQuery("body").append('<div class="' + className + '"><svg class="friendly" width="100%" height="100%" viewBox="0 0 24 24"  version="1.1" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:1.41421;"> <path d="M0 0h24v24H0V0z" fill="none"/><path d="M19 13v5c0 .55-.45 1-1 1H6c-.55 0-1-.45-1-1v-5c0-.55-.45-1-1-1s-1 .45-1 1v6c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-6c0-.55-.45-1-1-1s-1 .45-1 1zm-6-.33l1.88-1.88c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41l-3.59 3.59c-.39.39-1.02.39-1.41 0L7.7 12.2c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0L11 12.67V4c0-.55.45-1 1-1s1 .45 1 1v8.67z"/> </svg></div>')
            ow_jQuery("." + className).show()
            ow_jQuery("." + className).attr("src", url)
            ow_jQuery("." + className + " > svg").css("fill", color)
        }

        _.start = function() {
            _.scheduleColorChange()

            setInterval(function() {
                _.scanAllArticlesNew()
                _.insertDownloadPictureButton()
                _.scanTwitterLogo()
            }, 300);
            _.scanTwitterLogo()

            setTimeout(function() {
                _fas_.hideLoader()
            }, 300);

            ow_jQuery("body").on("click", ".ow_removeAd", function(e) {
                _fas_.openPreferences()
                e.preventDefault()
                e.stopPropagation()
            })

            ow_jQuery("body").on("click", ".ow_download_picture", function(e) {
                _fas_.onMoreShare($(this).attr("src"))
                e.preventDefault()
                e.stopPropagation()
            });

            ow_jQuery("body").on("click", ".ow_download_video, .ow_downloadButton", function(e) {
                _fas_.onMoreShareVideo($(this).attr("src"))
                e.preventDefault()
                e.stopPropagation()
            });

            ow_jQuery("body").on("click", ".ow_download_manager", function(e) {
                _fas_.openChooserDirectory()
                e.preventDefault()
                e.stopPropagation()
            });

            exports.AccountLib.ifLoggedInThen(function(userID) {
                setTimeout(function() {
                    console.debug(" exports.AccountLib ", exports.AccountLib);
                    exports.AccountLib.identityUserIfRequired(userID);
                }, 1000);
            });

        }

        _.init = function() {
            _.start();
            return _;
        }
        return _;

    })().init();
})